/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pce.pceservice;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.onlab.util.DataRateUnit;
import org.onosproject.incubator.net.tunnel.Tunnel;
import org.onosproject.incubator.net.tunnel.TunnelId;
import org.onosproject.net.intent.Constraint;
import org.onosproject.net.intent.constraint.BandwidthConstraint;
import org.onosproject.pce.pceservice.LspType;
import org.onosproject.pce.pceservice.PcePath;
import org.onosproject.pce.pceservice.constraint.CostConstraint;

public final class DefaultPcePath
implements PcePath {
    private TunnelId id;
    private String source;
    private String destination;
    private LspType lspType;
    private String name;
    private Constraint costConstraint;
    private Constraint bandwidthConstraint;

    private DefaultPcePath(TunnelId id, String src, String dst, LspType lspType, String name, Constraint costConstrnt, Constraint bandwidthConstrnt) {
        this.id = id;
        this.source = src;
        this.destination = dst;
        this.lspType = lspType;
        this.name = name;
        this.costConstraint = costConstrnt;
        this.bandwidthConstraint = bandwidthConstrnt;
    }

    @Override
    public TunnelId id() {
        return this.id;
    }

    @Override
    public void id(TunnelId id) {
        this.id = id;
    }

    @Override
    public String source() {
        return this.source;
    }

    @Override
    public void source(String src) {
        this.source = src;
    }

    @Override
    public String destination() {
        return this.destination;
    }

    @Override
    public void destination(String dst) {
        this.destination = dst;
    }

    @Override
    public LspType lspType() {
        return this.lspType;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Constraint costConstraint() {
        return this.costConstraint;
    }

    @Override
    public Constraint bandwidthConstraint() {
        return this.bandwidthConstraint;
    }

    @Override
    public PcePath copy(PcePath path) {
        if (null != path.source()) {
            this.source = path.source();
        }
        if (null != path.destination()) {
            this.destination = path.destination();
        }
        this.lspType = path.lspType();
        if (null != path.name()) {
            this.name = path.name();
        }
        if (null != path.costConstraint()) {
            this.costConstraint = path.costConstraint();
        }
        if (null != path.bandwidthConstraint()) {
            this.bandwidthConstraint = path.bandwidthConstraint();
        }
        return this;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.source, this.destination, this.lspType, this.name, this.costConstraint, this.bandwidthConstraint});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultPcePath) {
            DefaultPcePath that = (DefaultPcePath)obj;
            return Objects.equals(this.id, that.id) && Objects.equals(this.source, that.source) && Objects.equals(this.destination, that.destination) && Objects.equals((Object)this.lspType, (Object)that.lspType) && Objects.equals(this.name, that.name) && Objects.equals(this.costConstraint, that.costConstraint) && Objects.equals(this.bandwidthConstraint, that.bandwidthConstraint);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id()).add("source", (Object)this.source).add("destination", (Object)this.destination).add("lsptype", (Object)this.lspType).add("name", (Object)this.name).add("costConstraint", (Object)this.costConstraint.toString()).add("bandwidthConstraint", (Object)this.bandwidthConstraint.toString()).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements PcePath.Builder {
        private TunnelId id;
        private String source;
        private String destination;
        private LspType lspType;
        private String name;
        private Constraint costConstraint;
        private Constraint bandwidthConstraint;

        @Override
        public Builder id(String id) {
            this.id = TunnelId.valueOf((String)id);
            return this;
        }

        @Override
        public Builder source(String source) {
            this.source = source;
            return this;
        }

        @Override
        public Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        @Override
        public Builder lspType(String type) {
            if (null != type) {
                this.lspType = LspType.values()[Integer.valueOf(type)];
            }
            return this;
        }

        @Override
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Builder costConstraint(String cost) {
            this.costConstraint = CostConstraint.of(CostConstraint.Type.values()[Integer.valueOf(cost) - 1]);
            return this;
        }

        @Override
        public Builder bandwidthConstraint(String bandwidth) {
            this.bandwidthConstraint = BandwidthConstraint.of((double)Double.valueOf(bandwidth), (DataRateUnit)DataRateUnit.valueOf((String)"BPS"));
            return this;
        }

        @Override
        public Builder of(Tunnel tunnel) {
            String bandwidth;
            String costType;
            this.id = TunnelId.valueOf((String)((String)tunnel.tunnelId().id()));
            this.source = tunnel.src().toString();
            this.destination = tunnel.dst().toString();
            this.name = tunnel.tunnelName().toString();
            String lspType = tunnel.annotations().value("lspSigType");
            if (lspType != null) {
                this.lspType = LspType.values()[Integer.valueOf(lspType) - 1];
            }
            if ((costType = tunnel.annotations().value("costType")) != null) {
                this.costConstraint = CostConstraint.of(CostConstraint.Type.values()[Integer.valueOf(costType) - 1]);
            }
            if ((bandwidth = tunnel.annotations().value("bandwidth")) != null) {
                this.bandwidthConstraint = BandwidthConstraint.of((double)Double.parseDouble(bandwidth), (DataRateUnit)DataRateUnit.valueOf((String)"BPS"));
            }
            return this;
        }

        @Override
        public PcePath build() {
            return new DefaultPcePath(this.id, this.source, this.destination, this.lspType, this.name, this.costConstraint, this.bandwidthConstraint);
        }
    }
}

