/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pce.pceservice;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.packet.Ethernet;
import org.onlab.packet.IPv4;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.TCP;
import org.onlab.util.Bandwidth;
import org.onlab.util.KryoNamespace;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.core.IdGenerator;
import org.onosproject.event.EventListener;
import org.onosproject.incubator.net.resource.label.LabelResourceAdminService;
import org.onosproject.incubator.net.resource.label.LabelResourceId;
import org.onosproject.incubator.net.resource.label.LabelResourceService;
import org.onosproject.incubator.net.tunnel.DefaultTunnel;
import org.onosproject.incubator.net.tunnel.IpTunnelEndPoint;
import org.onosproject.incubator.net.tunnel.LabelStack;
import org.onosproject.incubator.net.tunnel.Tunnel;
import org.onosproject.incubator.net.tunnel.TunnelEndPoint;
import org.onosproject.incubator.net.tunnel.TunnelEvent;
import org.onosproject.incubator.net.tunnel.TunnelId;
import org.onosproject.incubator.net.tunnel.TunnelListener;
import org.onosproject.incubator.net.tunnel.TunnelName;
import org.onosproject.incubator.net.tunnel.TunnelService;
import org.onosproject.mastership.MastershipService;
import org.onosproject.net.Annotations;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.Link;
import org.onosproject.net.MastershipRole;
import org.onosproject.net.NetworkResource;
import org.onosproject.net.Path;
import org.onosproject.net.PortNumber;
import org.onosproject.net.config.NetworkConfigEvent;
import org.onosproject.net.config.NetworkConfigListener;
import org.onosproject.net.config.NetworkConfigService;
import org.onosproject.net.device.DeviceEvent;
import org.onosproject.net.device.DeviceListener;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.flowobjective.FlowObjectiveService;
import org.onosproject.net.flowobjective.Objective;
import org.onosproject.net.intent.Constraint;
import org.onosproject.net.intent.constraint.BandwidthConstraint;
import org.onosproject.net.link.LinkEvent;
import org.onosproject.net.link.LinkListener;
import org.onosproject.net.link.LinkService;
import org.onosproject.net.packet.InboundPacket;
import org.onosproject.net.packet.PacketContext;
import org.onosproject.net.packet.PacketProcessor;
import org.onosproject.net.packet.PacketService;
import org.onosproject.net.resource.ContinuousResource;
import org.onosproject.net.resource.Resource;
import org.onosproject.net.resource.ResourceConsumer;
import org.onosproject.net.resource.ResourceQueryService;
import org.onosproject.net.resource.ResourceService;
import org.onosproject.net.resource.Resources;
import org.onosproject.net.topology.LinkWeight;
import org.onosproject.net.topology.PathService;
import org.onosproject.net.topology.TopologyEdge;
import org.onosproject.net.topology.TopologyEvent;
import org.onosproject.net.topology.TopologyListener;
import org.onosproject.net.topology.TopologyService;
import org.onosproject.pce.pceservice.BasicPceccHandler;
import org.onosproject.pce.pceservice.LspType;
import org.onosproject.pce.pceservice.PceccSrTeBeHandler;
import org.onosproject.pce.pceservice.TunnelConsumerId;
import org.onosproject.pce.pceservice.api.PceService;
import org.onosproject.pce.pceservice.constraint.CapabilityConstraint;
import org.onosproject.pce.pceservice.constraint.CostConstraint;
import org.onosproject.pce.pceservice.constraint.SharedBandwidthConstraint;
import org.onosproject.pce.pcestore.PcePathInfo;
import org.onosproject.pce.pcestore.PceccTunnelInfo;
import org.onosproject.pce.pcestore.api.PceStore;
import org.onosproject.pcep.api.DeviceCapability;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.AsyncDistributedSet;
import org.onosproject.store.service.DistributedSet;
import org.onosproject.store.service.DistributedSetBuilder;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class PceManager
implements PceService {
    private static final Logger log = LoggerFactory.getLogger(PceManager.class);
    public static final long GLOBAL_LABEL_SPACE_MIN = 4097L;
    public static final long GLOBAL_LABEL_SPACE_MAX = 5121L;
    private static final String DEVICE_NULL = "Device-cannot be null";
    private static final String LINK_NULL = "Link-cannot be null";
    public static final String PCE_SERVICE_APP = "org.onosproject.pce";
    private static final String LOCAL_LSP_ID_GEN_TOPIC = "pcep-local-lsp-id";
    public static final String DEVICE_TYPE = "type";
    public static final String L3_DEVICE = "L3";
    private static final int PREFIX_LENGTH = 32;
    private static final String TUNNEL_CONSUMER_ID_GEN_TOPIC = "pcep-tunnel-consumer-id";
    private IdGenerator tunnelConsumerIdGen;
    private static final String LSRID = "lsrId";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static final String END_OF_SYNC_IP_PREFIX = "0.0.0.0/32";
    public static final int PCEP_PORT = 4189;
    private IdGenerator localLspIdIdGen;
    protected DistributedSet<Short> localLspIdFreeList;
    private Map<String, DeviceId> lsrIdDeviceIdMap = new HashMap<String, DeviceId>();
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ResourceService resourceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected ResourceQueryService resourceQueryService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected PathService pathService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected PceStore pceStore;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected TunnelService tunnelService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected PacketService packetService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected LinkService linkService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected NetworkConfigService netCfgService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected LabelResourceAdminService labelRsrcAdminService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected LabelResourceService labelRsrcService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected FlowObjectiveService flowObjectiveService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected MastershipService mastershipService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected TopologyService topologyService;
    private TunnelListener listener = new InnerTunnelListener();
    private DeviceListener deviceListener = new InternalDeviceListener();
    private LinkListener linkListener = new InternalLinkListener();
    private InternalConfigListener cfgListener = new InternalConfigListener();
    private BasicPceccHandler crHandler;
    private PceccSrTeBeHandler srTeHandler;
    private ApplicationId appId;
    private final PcepPacketProcessor processor = new PcepPacketProcessor();
    private final TopologyListener topologyListener = new InternalTopologyListener();
    private ScheduledExecutorService executor;
    public static final int INITIAL_DELAY = 30;
    public static final int PERIODIC_DELAY = 30;

    @Activate
    protected void activate() {
        this.appId = this.coreService.registerApplication(PCE_SERVICE_APP);
        this.crHandler = BasicPceccHandler.getInstance();
        this.crHandler.initialize(this.labelRsrcService, this.flowObjectiveService, this.appId, this.pceStore);
        this.srTeHandler = PceccSrTeBeHandler.getInstance();
        this.srTeHandler.initialize(this.labelRsrcAdminService, this.labelRsrcService, this.flowObjectiveService, this.appId, this.pceStore, this.deviceService);
        this.tunnelService.addListener((EventListener)this.listener);
        this.deviceService.addListener((EventListener)this.deviceListener);
        this.linkService.addListener((EventListener)this.linkListener);
        this.netCfgService.addListener((EventListener)this.cfgListener);
        this.tunnelConsumerIdGen = this.coreService.getIdGenerator(TUNNEL_CONSUMER_ID_GEN_TOPIC);
        this.localLspIdIdGen = this.coreService.getIdGenerator(LOCAL_LSP_ID_GEN_TOPIC);
        this.localLspIdIdGen.getNewId();
        this.localLspIdFreeList = ((AsyncDistributedSet)((DistributedSetBuilder)((DistributedSetBuilder)this.storageService.setBuilder().withName("pcepLocalLspIdDeletedList")).withSerializer(Serializer.using((KryoNamespace)KryoNamespaces.API))).build()).asDistributedSet();
        this.packetService.addProcessor((PacketProcessor)this.processor, PacketProcessor.director((int)4));
        this.topologyService.addListener((EventListener)this.topologyListener);
        this.executor = Executors.newSingleThreadScheduledExecutor();
        this.executor.scheduleAtFixedRate(new GlobalOptimizationTimer(), 30L, 30L, TimeUnit.MINUTES);
        if (!this.srTeHandler.reserveGlobalPool(4097L, 5121L)) {
            log.debug("Global node pool was already reserved.");
        }
        log.info("Started");
    }

    @Deactivate
    protected void deactivate() {
        this.tunnelService.removeListener((EventListener)this.listener);
        this.deviceService.removeListener((EventListener)this.deviceListener);
        this.linkService.removeListener((EventListener)this.linkListener);
        this.netCfgService.removeListener((EventListener)this.cfgListener);
        this.packetService.removeProcessor((PacketProcessor)this.processor);
        this.topologyService.removeListener((EventListener)this.topologyListener);
        this.executor.shutdown();
        log.info("Stopped");
    }

    private LinkWeight weight(List<Constraint> constraints) {
        return new TeConstraintBasedLinkWeight(constraints);
    }

    protected Set<Path> computePath(DeviceId src, DeviceId dst, List<Constraint> constraints) {
        if (this.pathService == null) {
            return ImmutableSet.of();
        }
        Set paths = this.pathService.getPaths((ElementId)src, (ElementId)dst, this.weight(constraints));
        if (!paths.isEmpty()) {
            return paths;
        }
        return ImmutableSet.of();
    }

    @Override
    public boolean setupPath(DeviceId src, DeviceId dst, String tunnelName, List<Constraint> constraints, LspType lspType) {
        Preconditions.checkNotNull((Object)src);
        Preconditions.checkNotNull((Object)dst);
        Preconditions.checkNotNull((Object)tunnelName);
        Preconditions.checkNotNull((Object)((Object)lspType));
        Device srcDevice = this.deviceService.getDevice(src);
        Device dstDevice = this.deviceService.getDevice(dst);
        if (srcDevice == null || dstDevice == null) {
            this.pceStore.addFailedPathInfo(new PcePathInfo(src, dst, tunnelName, constraints, lspType));
            return false;
        }
        String srcLsrId = srcDevice.annotations().value(LSRID);
        String dstLsrId = dstDevice.annotations().value(LSRID);
        if (srcLsrId == null || dstLsrId == null) {
            this.pceStore.addFailedPathInfo(new PcePathInfo(src, dst, tunnelName, constraints, lspType));
            return false;
        }
        DeviceCapability cfg = (DeviceCapability)this.netCfgService.getConfig((Object)DeviceId.deviceId((String)srcLsrId), DeviceCapability.class);
        if (cfg == null) {
            log.debug("No session to ingress.");
            this.pceStore.addFailedPathInfo(new PcePathInfo(src, dst, tunnelName, constraints, lspType));
            return false;
        }
        IpTunnelEndPoint srcEndPoint = IpTunnelEndPoint.ipTunnelPoint((IpAddress)IpAddress.valueOf((String)srcLsrId));
        IpTunnelEndPoint dstEndPoint = IpTunnelEndPoint.ipTunnelPoint((IpAddress)IpAddress.valueOf((String)dstLsrId));
        double bwConstraintValue = 0.0;
        CostConstraint costConstraint = null;
        if (constraints != null) {
            constraints.add((Constraint)CapabilityConstraint.of(CapabilityConstraint.CapabilityType.valueOf(lspType.name())));
            for (Constraint constraint : constraints) {
                if (constraint instanceof BandwidthConstraint) {
                    bwConstraintValue = ((BandwidthConstraint)constraint).bandwidth().bps();
                    continue;
                }
                if (!(constraint instanceof CostConstraint)) continue;
                costConstraint = (CostConstraint)constraint;
            }
            if (costConstraint != null) {
                constraints.remove(costConstraint);
                constraints.add(costConstraint);
            }
        } else {
            constraints = new LinkedList<Constraint>();
            constraints.add((Constraint)CapabilityConstraint.of(CapabilityConstraint.CapabilityType.valueOf(lspType.name())));
        }
        Set<Path> computedPathSet = this.computePath(src, dst, constraints);
        if (computedPathSet.isEmpty()) {
            this.pceStore.addFailedPathInfo(new PcePathInfo(src, dst, tunnelName, constraints, lspType));
            return false;
        }
        DefaultAnnotations.Builder annotationBuilder = DefaultAnnotations.builder();
        if (bwConstraintValue != 0.0) {
            annotationBuilder.set("bandwidth", String.valueOf(bwConstraintValue));
        }
        if (costConstraint != null) {
            annotationBuilder.set("costType", String.valueOf((Object)costConstraint.type()));
        }
        annotationBuilder.set("lspSigType", lspType.name());
        annotationBuilder.set("pceInit", TRUE);
        annotationBuilder.set("delegate", TRUE);
        Path computedPath = computedPathSet.iterator().next();
        LabelStack labelStack = null;
        if (lspType == LspType.SR_WITHOUT_SIGNALLING && (labelStack = this.srTeHandler.computeLabelStack(computedPath)) == null) {
            this.pceStore.addFailedPathInfo(new PcePathInfo(src, dst, tunnelName, constraints, lspType));
            return false;
        }
        if (lspType != LspType.WITH_SIGNALLING) {
            annotationBuilder.set("localLspId", String.valueOf(this.getNextLocalLspId()));
        }
        DefaultTunnel tunnel = new DefaultTunnel(null, (TunnelEndPoint)srcEndPoint, (TunnelEndPoint)dstEndPoint, Tunnel.Type.MPLS, Tunnel.State.INIT, null, null, TunnelName.tunnelName((String)tunnelName), computedPath, (NetworkResource)labelStack, new Annotations[]{annotationBuilder.build()});
        TunnelConsumerId consumerId = null;
        if (bwConstraintValue != 0.0 && (consumerId = this.reserveBandwidth(computedPath, bwConstraintValue, null)) == null) {
            this.pceStore.addFailedPathInfo(new PcePathInfo(src, dst, tunnelName, constraints, lspType));
            return false;
        }
        TunnelId tunnelId = this.tunnelService.setupTunnel(this.appId, (ElementId)src, (Tunnel)tunnel, computedPath);
        if (tunnelId == null) {
            this.pceStore.addFailedPathInfo(new PcePathInfo(src, dst, tunnelName, constraints, lspType));
            if (consumerId != null) {
                this.resourceService.release((ResourceConsumer)consumerId);
            }
            return false;
        }
        if (consumerId != null) {
            PceccTunnelInfo pceccTunnelInfo = new PceccTunnelInfo(null, consumerId);
            this.pceStore.addTunnelInfo(tunnelId, pceccTunnelInfo);
        }
        return true;
    }

    @Override
    public boolean updatePath(TunnelId tunnelId, List<Constraint> constraints) {
        DefaultTunnel tunnelForlabelDownload;
        Preconditions.checkNotNull((Object)tunnelId);
        Set<Path> computedPathSet = null;
        Tunnel tunnel = this.tunnelService.queryTunnel(tunnelId);
        if (tunnel == null) {
            return false;
        }
        if (tunnel.type() != Tunnel.Type.MPLS || FALSE.equalsIgnoreCase(tunnel.annotations().value("delegate"))) {
            return false;
        }
        List links = tunnel.path().links();
        String lspSigType = tunnel.annotations().value("lspSigType");
        double bwConstraintValue = 0.0;
        String costType = null;
        SharedBandwidthConstraint shBwConstraint = null;
        BandwidthConstraint bwConstraint = null;
        CostConstraint costConstraint = null;
        if (constraints != null) {
            for (Constraint constraint : constraints) {
                if (constraint instanceof BandwidthConstraint) {
                    bwConstraint = (BandwidthConstraint)constraint;
                    bwConstraintValue = bwConstraint.bandwidth().bps();
                    continue;
                }
                if (!(constraint instanceof CostConstraint)) continue;
                costConstraint = (CostConstraint)constraint;
                costType = costConstraint.type().name();
            }
            if (costConstraint != null) {
                constraints.remove(costConstraint);
            }
            Bandwidth existingBwValue = null;
            String existingBwAnnotation = tunnel.annotations().value("bandwidth");
            if (existingBwAnnotation != null) {
                existingBwValue = Bandwidth.bps((double)Double.parseDouble(existingBwAnnotation));
                if (bwConstraint != null) {
                    constraints.remove(bwConstraint);
                }
            }
            if (existingBwValue != null) {
                if (bwConstraintValue == 0.0) {
                    bwConstraintValue = existingBwValue.bps();
                }
                shBwConstraint = bwConstraint != null ? new SharedBandwidthConstraint(links, existingBwValue, bwConstraint.bandwidth()) : new SharedBandwidthConstraint(links, existingBwValue, existingBwValue);
                constraints.add((Constraint)shBwConstraint);
            }
        } else {
            constraints = new LinkedList<Constraint>();
        }
        constraints.add((Constraint)CapabilityConstraint.of(CapabilityConstraint.CapabilityType.valueOf(lspSigType)));
        if (costConstraint != null) {
            constraints.add(costConstraint);
        }
        if ((computedPathSet = this.computePath(((Link)links.get(0)).src().deviceId(), ((Link)links.get(links.size() - 1)).dst().deviceId(), constraints)).isEmpty()) {
            return false;
        }
        DefaultAnnotations.Builder annotationBuilder = DefaultAnnotations.builder();
        annotationBuilder.set("bandwidth", String.valueOf(bwConstraintValue));
        if (costType != null) {
            annotationBuilder.set("costType", costType);
        }
        annotationBuilder.set("lspSigType", lspSigType);
        annotationBuilder.set("pceInit", TRUE);
        annotationBuilder.set("delegate", TRUE);
        annotationBuilder.set("PLspId", tunnel.annotations().value("PLspId"));
        annotationBuilder.set("PccTunnelId", tunnel.annotations().value("PccTunnelId"));
        Path computedPath = computedPathSet.iterator().next();
        LabelStack labelStack = null;
        TunnelConsumerId consumerId = null;
        LspType lspType = LspType.valueOf(lspSigType);
        long localLspId = 0L;
        if (lspType != LspType.WITH_SIGNALLING) {
            localLspId = this.getNextLocalLspId();
            annotationBuilder.set("localLspId", String.valueOf(localLspId));
            if (lspType == LspType.SR_WITHOUT_SIGNALLING && (labelStack = this.srTeHandler.computeLabelStack(computedPath)) == null) {
                return false;
            }
        }
        DefaultTunnel updatedTunnel = new DefaultTunnel(null, tunnel.src(), tunnel.dst(), Tunnel.Type.MPLS, Tunnel.State.INIT, null, null, tunnel.tunnelName(), computedPath, (NetworkResource)labelStack, new Annotations[]{annotationBuilder.build()});
        if (bwConstraintValue != 0.0 && (consumerId = this.reserveBandwidth(computedPath, bwConstraintValue, shBwConstraint)) == null) {
            return false;
        }
        TunnelId updatedTunnelId = this.tunnelService.setupTunnel(this.appId, (ElementId)((Link)links.get(0)).src().deviceId(), (Tunnel)updatedTunnel, computedPath);
        if (updatedTunnelId == null) {
            if (consumerId != null) {
                this.resourceService.release((ResourceConsumer)consumerId);
            }
            return false;
        }
        if (consumerId != null) {
            PceccTunnelInfo pceccTunnelInfo = new PceccTunnelInfo(null, consumerId);
            this.pceStore.addTunnelInfo(updatedTunnelId, pceccTunnelInfo);
        }
        if (lspType == LspType.WITHOUT_SIGNALLING_AND_WITHOUT_SR && !this.crHandler.allocateLabel((Tunnel)(tunnelForlabelDownload = new DefaultTunnel(null, tunnel.src(), tunnel.dst(), Tunnel.Type.MPLS, Tunnel.State.INIT, null, updatedTunnelId, tunnel.tunnelName(), computedPath, (NetworkResource)labelStack, new Annotations[]{annotationBuilder.build()})))) {
            log.error("Unable to allocate labels for the tunnel {}.", (Object)tunnel.toString());
        }
        return true;
    }

    @Override
    public boolean releasePath(TunnelId tunnelId) {
        Preconditions.checkNotNull((Object)tunnelId);
        Tunnel tunnel = this.tunnelService.queryTunnel(tunnelId);
        if (tunnel == null) {
            return false;
        }
        return this.tunnelService.downTunnel(this.appId, tunnel.tunnelId());
    }

    @Override
    public Iterable<Tunnel> queryAllPath() {
        return this.tunnelService.queryTunnel(Tunnel.Type.MPLS);
    }

    @Override
    public Tunnel queryPath(TunnelId tunnelId) {
        return this.tunnelService.queryTunnel(tunnelId);
    }

    private short getNextLocalLspId() {
        if (this.localLspIdFreeList.isEmpty()) {
            return (short)this.localLspIdIdGen.getNewId();
        }
        Iterator it = this.localLspIdFreeList.iterator();
        Short value = (Short)it.next();
        this.localLspIdFreeList.remove((Object)value);
        return value;
    }

    private boolean checkForMasterAndUpdateTunnel(DeviceId src, Tunnel tunnel) {
        if (this.mastershipService.isLocalMaster(src) && Boolean.valueOf(tunnel.annotations().value("delegate")) != null) {
            LinkedList<Constraint> constraintList = new LinkedList<Constraint>();
            if (tunnel.annotations().value("bandwidth") != null) {
                BandwidthConstraint localConst = new BandwidthConstraint(Bandwidth.bps((double)Double.parseDouble(tunnel.annotations().value("bandwidth"))));
                constraintList.add((Constraint)localConst);
            }
            if (tunnel.annotations().value("costType") != null) {
                constraintList.add(CostConstraint.of(CostConstraint.Type.valueOf(tunnel.annotations().value("costType"))));
            }
            if (!this.updatePath(tunnel.tunnelId(), constraintList) && !tunnel.state().equals((Object)Tunnel.State.FAILED)) {
                this.pceStore.addFailedPathInfo(new PcePathInfo(tunnel.path().src().deviceId(), tunnel.path().dst().deviceId(), tunnel.tunnelName().value(), constraintList, LspType.valueOf(tunnel.annotations().value("lspSigType"))));
                this.releasePath(tunnel.tunnelId());
            }
        }
        return false;
    }

    private TunnelConsumerId reserveBandwidth(Path computedPath, double bandwidthConstraint, SharedBandwidthConstraint shBwConstraint) {
        Preconditions.checkNotNull((Object)computedPath);
        Preconditions.checkNotNull((Object)bandwidthConstraint);
        ContinuousResource resource = null;
        double bwToAllocate = 0.0;
        TunnelConsumerId consumer = TunnelConsumerId.valueOf(this.tunnelConsumerIdGen.getNewId());
        Double additionalBwValue = null;
        if (shBwConstraint != null) {
            additionalBwValue = bandwidthConstraint - shBwConstraint.sharedBwValue().bps() <= 0.0 ? null : Double.valueOf(bandwidthConstraint - shBwConstraint.sharedBwValue().bps());
        }
        Optional resAlloc = null;
        for (Link link : computedPath.links()) {
            bwToAllocate = 0.0;
            if (shBwConstraint != null && shBwConstraint.links().contains(link)) {
                if (additionalBwValue != null) {
                    bwToAllocate = bandwidthConstraint - additionalBwValue;
                }
            } else {
                bwToAllocate = bandwidthConstraint;
            }
            if (bwToAllocate == 0.0 || (resAlloc = this.resourceService.allocate((ResourceConsumer)consumer, (Resource)(resource = Resources.continuous((DeviceId)link.src().deviceId(), (PortNumber)link.src().port(), Bandwidth.class).resource(bwToAllocate)))).isPresent()) continue;
            this.resourceService.release((ResourceConsumer)consumer);
            return null;
        }
        return consumer;
    }

    private void releaseBandwidth(Tunnel tunnel) {
        Collection tunnelQueryResult = this.tunnelService.queryTunnel(tunnel.src(), tunnel.dst());
        Tunnel newTunnel = null;
        for (Tunnel tunnelObj : tunnelQueryResult) {
            if (!tunnel.tunnelName().value().equals(tunnelObj.tunnelName().value())) continue;
            newTunnel = tunnelObj;
            break;
        }
        boolean isLinkShared = false;
        if (newTunnel != null) {
            for (Link link : tunnel.path().links()) {
                if (!newTunnel.path().links().contains(link)) continue;
                isLinkShared = true;
                break;
            }
        }
        if (isLinkShared) {
            this.releaseSharedBandwidth(newTunnel, tunnel);
            return;
        }
        this.resourceService.release(this.pceStore.getTunnelInfo(tunnel.tunnelId()).tunnelConsumerId());
    }

    private synchronized void releaseSharedBandwidth(Tunnel newTunnel, Tunnel oldTunnel) {
        this.resourceService.release(this.pceStore.getTunnelInfo(oldTunnel.tunnelId()).tunnelConsumerId());
        ResourceConsumer consumer = this.pceStore.getTunnelInfo(newTunnel.tunnelId()).tunnelConsumerId();
        this.resourceService.release(consumer);
        double bandwidth = Double.parseDouble(newTunnel.annotations().value("bandwidth"));
        for (Link link : newTunnel.path().links()) {
            ContinuousResource resource = Resources.continuous((DeviceId)link.src().deviceId(), (PortNumber)link.src().port(), Bandwidth.class).resource(bandwidth);
            this.resourceService.allocate(consumer, (Resource)resource);
        }
    }

    public void allocateNodeLabel(Device specificDevice) {
        Preconditions.checkNotNull((Object)specificDevice, (Object)DEVICE_NULL);
        DeviceId deviceId = specificDevice.id();
        if (specificDevice.annotations() == null) {
            log.debug("Device {} does not have annotations.", (Object)specificDevice.toString());
            return;
        }
        String lsrId = specificDevice.annotations().value(LSRID);
        if (lsrId == null) {
            log.debug("Unable to retrieve lsr-id of a device {}.", (Object)specificDevice.toString());
            return;
        }
        DeviceCapability cfg = (DeviceCapability)this.netCfgService.getConfig((Object)DeviceId.deviceId((String)lsrId), DeviceCapability.class);
        if (cfg == null) {
            log.error("Unable to find corresponding capability for a lsrd {} from NetConfig.", (Object)lsrId);
            this.lsrIdDeviceIdMap.put(lsrId, specificDevice.id());
            return;
        }
        if (cfg.labelStackCap()) {
            this.srTeHandler.allocateNodeLabel(deviceId, lsrId);
        }
    }

    public void releaseNodeLabel(Device specificDevice) {
        Preconditions.checkNotNull((Object)specificDevice, (Object)DEVICE_NULL);
        DeviceId deviceId = specificDevice.id();
        if (specificDevice.annotations() == null) {
            log.debug("Device {} does not have annotations.", (Object)specificDevice.toString());
            return;
        }
        String lsrId = specificDevice.annotations().value(LSRID);
        if (lsrId == null) {
            log.debug("Unable to retrieve lsr-id of a device {}.", (Object)specificDevice.toString());
            return;
        }
        DeviceCapability cfg = (DeviceCapability)this.netCfgService.getConfig((Object)DeviceId.deviceId((String)lsrId), DeviceCapability.class);
        if (cfg == null) {
            log.error("Unable to find corresponding capabilty for a lsrd {} from NetConfig.", (Object)lsrId);
            return;
        }
        if (cfg.labelStackCap() && !this.srTeHandler.releaseNodeLabel(deviceId, lsrId)) {
            log.error("Unable to release node label for a device id {}.", (Object)deviceId.toString());
        }
    }

    public void allocateAdjacencyLabel(Link link) {
        Preconditions.checkNotNull((Object)link, (Object)LINK_NULL);
        Device specificDevice = this.deviceService.getDevice(link.src().deviceId());
        DeviceId deviceId = specificDevice.id();
        if (specificDevice.annotations() == null) {
            log.debug("Device {} does not have annotations.", (Object)specificDevice.toString());
            return;
        }
        String lsrId = specificDevice.annotations().value(LSRID);
        if (lsrId == null) {
            log.debug("Unable to retrieve lsr-id of a device {}.", (Object)specificDevice.toString());
            return;
        }
        DeviceCapability cfg = (DeviceCapability)this.netCfgService.getConfig((Object)DeviceId.deviceId((String)lsrId), DeviceCapability.class);
        if (cfg == null) {
            log.error("Unable to find corresponding capabilty for a lsrd {} from NetConfig.", (Object)lsrId);
            if (this.lsrIdDeviceIdMap.get(lsrId) != null) {
                this.lsrIdDeviceIdMap.put(lsrId, specificDevice.id());
            }
            return;
        }
        if (cfg.labelStackCap()) {
            this.srTeHandler.allocateAdjacencyLabel(link);
        }
    }

    public void releaseAdjacencyLabel(Link link) {
        Preconditions.checkNotNull((Object)link, (Object)LINK_NULL);
        Device specificDevice = this.deviceService.getDevice(link.src().deviceId());
        DeviceId deviceId = specificDevice.id();
        if (specificDevice.annotations() == null) {
            log.debug("Device {} does not have annotations.", (Object)specificDevice.toString());
            return;
        }
        String lsrId = specificDevice.annotations().value(LSRID);
        if (lsrId == null) {
            log.debug("Unable to retrieve lsr-id of a device {}.", (Object)specificDevice.toString());
            return;
        }
        DeviceCapability cfg = (DeviceCapability)this.netCfgService.getConfig((Object)DeviceId.deviceId((String)lsrId), DeviceCapability.class);
        if (cfg == null) {
            log.error("Unable to find corresponding capabilty for a lsrd {} from NetConfig.", (Object)lsrId);
            return;
        }
        if (cfg.labelStackCap() && !this.srTeHandler.releaseAdjacencyLabel(link)) {
            log.error("Unable to release adjacency labels for a link {}.", (Object)link.toString());
            return;
        }
    }

    private boolean syncLabelDb(DeviceId deviceId) {
        Preconditions.checkNotNull((Object)deviceId);
        DeviceId actualDevcieId = this.pceStore.getLsrIdDevice(deviceId.toString());
        if (actualDevcieId == null) {
            log.error("Device not available {}.", (Object)deviceId.toString());
            this.pceStore.addPccLsr(deviceId);
            return false;
        }
        Device specificDevice = this.deviceService.getDevice(actualDevcieId);
        if (specificDevice == null) {
            log.error("Unable to find device for specific device id {}.", (Object)actualDevcieId.toString());
            return false;
        }
        if (this.pceStore.getGlobalNodeLabel(actualDevcieId) != null) {
            Map<DeviceId, LabelResourceId> globalNodeLabelMap = this.pceStore.getGlobalNodeLabels();
            for (Map.Entry<DeviceId, LabelResourceId> entry : globalNodeLabelMap.entrySet()) {
                String srcLsrId;
                Device device = this.deviceService.getDevice(entry.getKey());
                if (device == null || (srcLsrId = device.annotations().value(LSRID)) == null) continue;
                this.srTeHandler.advertiseNodeLabelRule(actualDevcieId, (LabelResourceId)entry.getValue(), IpPrefix.valueOf((IpAddress)IpAddress.valueOf((String)srcLsrId), (int)32), Objective.Operation.ADD, false);
            }
            Map<Link, LabelResourceId> adjLabelMap = this.pceStore.getAdjLabels();
            for (Map.Entry entry : adjLabelMap.entrySet()) {
                if (!((Link)entry.getKey()).src().deviceId().equals((Object)actualDevcieId)) continue;
                this.srTeHandler.installAdjLabelRule(actualDevcieId, (LabelResourceId)entry.getValue(), ((Link)entry.getKey()).src().port(), ((Link)entry.getKey()).dst().port(), Objective.Operation.ADD);
            }
        }
        this.srTeHandler.advertiseNodeLabelRule(actualDevcieId, LabelResourceId.labelResourceId((long)0L), IpPrefix.valueOf((String)END_OF_SYNC_IP_PREFIX), Objective.Operation.ADD, true);
        log.debug("End of label DB sync for device {}", (Object)actualDevcieId);
        if (this.mastershipService.getLocalRole(specificDevice.id()) == MastershipRole.MASTER) {
            this.allocateNodeLabel(specificDevice);
            Set links = this.linkService.getDeviceEgressLinks(specificDevice.id());
            if (links != null) {
                for (Link link : links) {
                    this.allocateAdjacencyLabel(link);
                }
            }
        }
        return true;
    }

    private void callForOptimization() {
        for (PcePathInfo failedPathInfo : this.pceStore.getFailedPathInfos()) {
            this.checkForMasterAndSetupPath(failedPathInfo);
        }
        this.tunnelService.queryTunnel(Tunnel.Type.MPLS).forEach(t -> this.checkForMasterAndUpdateTunnel(t.path().src().deviceId(), (Tunnel)t));
    }

    private boolean checkForMasterAndSetupPath(PcePathInfo failedPathInfo) {
        if (this.mastershipService.isLocalMaster(failedPathInfo.src()) && this.setupPath(failedPathInfo.src(), failedPathInfo.dst(), failedPathInfo.name(), failedPathInfo.constraints(), failedPathInfo.lspType())) {
            this.pceStore.removeFailedPathInfo(failedPathInfo);
            return true;
        }
        return false;
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindResourceService(ResourceService resourceService) {
        this.resourceService = resourceService;
    }

    protected void unbindResourceService(ResourceService resourceService) {
        if (this.resourceService == resourceService) {
            this.resourceService = null;
        }
    }

    protected void bindResourceQueryService(ResourceQueryService resourceQueryService) {
        this.resourceQueryService = resourceQueryService;
    }

    protected void unbindResourceQueryService(ResourceQueryService resourceQueryService) {
        if (this.resourceQueryService == resourceQueryService) {
            this.resourceQueryService = null;
        }
    }

    protected void bindPathService(PathService pathService) {
        this.pathService = pathService;
    }

    protected void unbindPathService(PathService pathService) {
        if (this.pathService == pathService) {
            this.pathService = null;
        }
    }

    protected void bindPceStore(PceStore pceStore) {
        this.pceStore = pceStore;
    }

    protected void unbindPceStore(PceStore pceStore) {
        if (this.pceStore == pceStore) {
            this.pceStore = null;
        }
    }

    protected void bindTunnelService(TunnelService tunnelService) {
        this.tunnelService = tunnelService;
    }

    protected void unbindTunnelService(TunnelService tunnelService) {
        if (this.tunnelService == tunnelService) {
            this.tunnelService = null;
        }
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }

    protected void bindPacketService(PacketService packetService) {
        this.packetService = packetService;
    }

    protected void unbindPacketService(PacketService packetService) {
        if (this.packetService == packetService) {
            this.packetService = null;
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }

    protected void bindLinkService(LinkService linkService) {
        this.linkService = linkService;
    }

    protected void unbindLinkService(LinkService linkService) {
        if (this.linkService == linkService) {
            this.linkService = null;
        }
    }

    protected void bindNetCfgService(NetworkConfigService networkConfigService) {
        this.netCfgService = networkConfigService;
    }

    protected void unbindNetCfgService(NetworkConfigService networkConfigService) {
        if (this.netCfgService == networkConfigService) {
            this.netCfgService = null;
        }
    }

    protected void bindLabelRsrcAdminService(LabelResourceAdminService labelResourceAdminService) {
        this.labelRsrcAdminService = labelResourceAdminService;
    }

    protected void unbindLabelRsrcAdminService(LabelResourceAdminService labelResourceAdminService) {
        if (this.labelRsrcAdminService == labelResourceAdminService) {
            this.labelRsrcAdminService = null;
        }
    }

    protected void bindLabelRsrcService(LabelResourceService labelResourceService) {
        this.labelRsrcService = labelResourceService;
    }

    protected void unbindLabelRsrcService(LabelResourceService labelResourceService) {
        if (this.labelRsrcService == labelResourceService) {
            this.labelRsrcService = null;
        }
    }

    protected void bindFlowObjectiveService(FlowObjectiveService flowObjectiveService) {
        this.flowObjectiveService = flowObjectiveService;
    }

    protected void unbindFlowObjectiveService(FlowObjectiveService flowObjectiveService) {
        if (this.flowObjectiveService == flowObjectiveService) {
            this.flowObjectiveService = null;
        }
    }

    protected void bindMastershipService(MastershipService mastershipService) {
        this.mastershipService = mastershipService;
    }

    protected void unbindMastershipService(MastershipService mastershipService) {
        if (this.mastershipService == mastershipService) {
            this.mastershipService = null;
        }
    }

    protected void bindTopologyService(TopologyService topologyService) {
        this.topologyService = topologyService;
    }

    protected void unbindTopologyService(TopologyService topologyService) {
        if (this.topologyService == topologyService) {
            this.topologyService = null;
        }
    }

    private class GlobalOptimizationTimer
    implements Runnable {
        @Override
        public void run() {
            PceManager.this.callForOptimization();
        }
    }

    private class PcepPacketProcessor
    implements PacketProcessor {
        private PcepPacketProcessor() {
        }

        public void process(PacketContext context) {
            log.debug("Received trigger for label DB sync.");
            if (context.isHandled()) {
                return;
            }
            InboundPacket pkt = context.inPacket();
            if (pkt == null) {
                return;
            }
            Ethernet ethernet = pkt.parsed();
            if (ethernet == null || ethernet.getEtherType() != Ethernet.TYPE_IPV4) {
                return;
            }
            IPv4 ipPacket = (IPv4)ethernet.getPayload();
            if (ipPacket == null || ipPacket.getProtocol() != 6) {
                return;
            }
            TCP tcp = (TCP)ipPacket.getPayload();
            if (tcp == null || tcp.getDestinationPort() != 4189) {
                return;
            }
            PceManager.this.syncLabelDb(pkt.receivedFrom().deviceId());
        }
    }

    private class InternalConfigListener
    implements NetworkConfigListener {
        private InternalConfigListener() {
        }

        public void event(NetworkConfigEvent event) {
            if (event.type() == NetworkConfigEvent.Type.CONFIG_ADDED && event.configClass().equals(DeviceCapability.class)) {
                DeviceId deviceIdLsrId = (DeviceId)event.subject();
                String lsrId = deviceIdLsrId.toString();
                DeviceId deviceId = (DeviceId)PceManager.this.lsrIdDeviceIdMap.get(lsrId);
                if (deviceId == null) {
                    log.debug("Unable to find device id for a lsr-id {} from lsr-id and device-id map.", (Object)lsrId);
                    return;
                }
                DeviceCapability cfg = (DeviceCapability)PceManager.this.netCfgService.getConfig((Object)DeviceId.deviceId((String)lsrId), DeviceCapability.class);
                if (cfg == null) {
                    log.error("Unable to find corresponding capabilty for a lsrd {}.", (Object)lsrId);
                    return;
                }
                if (cfg.labelStackCap() && PceManager.this.mastershipService.getLocalRole(deviceId) == MastershipRole.MASTER) {
                    PceManager.this.srTeHandler.allocateNodeLabel(deviceId, lsrId);
                    Set links = PceManager.this.linkService.getDeviceEgressLinks(deviceId);
                    for (Link link : links) {
                        if (PceManager.this.srTeHandler.allocateAdjacencyLabel(link)) continue;
                        return;
                    }
                }
                PceManager.this.lsrIdDeviceIdMap.remove(lsrId);
            }
        }
    }

    private class InnerTunnelListener
    implements TunnelListener {
        private InnerTunnelListener() {
        }

        public void event(TunnelEvent event) {
            Tunnel tunnel = (Tunnel)event.subject();
            if (tunnel.type() != Tunnel.Type.MPLS) {
                return;
            }
            LspType lspType = LspType.valueOf(tunnel.annotations().value("lspSigType"));
            String tunnelBandwidth = tunnel.annotations().value("bandwidth");
            double bwConstraintValue = 0.0;
            if (tunnelBandwidth != null) {
                bwConstraintValue = Double.parseDouble(tunnelBandwidth);
            }
            switch ((TunnelEvent.Type)event.type()) {
                case TUNNEL_ADDED: {
                    String pceInit = tunnel.annotations().value("pceInit");
                    if (!PceManager.FALSE.equalsIgnoreCase(pceInit) || bwConstraintValue == 0.0) break;
                    PceManager.this.reserveBandwidth(tunnel.path(), bwConstraintValue, null);
                    break;
                }
                case TUNNEL_UPDATED: {
                    String costType;
                    if (tunnel.state() == Tunnel.State.ESTABLISHED && lspType == LspType.WITHOUT_SIGNALLING_AND_WITHOUT_SR && PceManager.this.mastershipService.getLocalRole(tunnel.path().src().deviceId()) == MastershipRole.MASTER && !PceManager.this.crHandler.allocateLabel(tunnel)) {
                        log.error("Unable to allocate labels for a tunnel {}.", (Object)tunnel.toString());
                    }
                    if (tunnel.state() != Tunnel.State.UNSTABLE) break;
                    LinkedList<Constraint> constraints = new LinkedList<Constraint>();
                    String bandwidth = tunnel.annotations().value("bandwidth");
                    if (bandwidth != null) {
                        constraints.add((Constraint)new BandwidthConstraint(Bandwidth.bps((double)Double.parseDouble(bandwidth))));
                    }
                    if ((costType = tunnel.annotations().value("costType")) != null) {
                        CostConstraint costConstraint = new CostConstraint(CostConstraint.Type.valueOf(costType));
                        constraints.add(costConstraint);
                    }
                    constraints.add((Constraint)CapabilityConstraint.of(CapabilityConstraint.CapabilityType.valueOf(tunnel.annotations().value("lspSigType"))));
                    List links = tunnel.path().links();
                    PceManager.this.pceStore.addFailedPathInfo(new PcePathInfo(((Link)links.get(0)).src().deviceId(), ((Link)links.get(links.size() - 1)).dst().deviceId(), tunnel.tunnelName().value(), constraints, lspType));
                    break;
                }
                case TUNNEL_REMOVED: {
                    if (lspType != LspType.WITH_SIGNALLING) {
                        PceManager.this.localLspIdFreeList.add((Object)Short.valueOf(tunnel.annotations().value("localLspId")));
                    }
                    if (bwConstraintValue == 0.0) break;
                    PceManager.this.releaseBandwidth((Tunnel)event.subject());
                    if (lspType == LspType.WITHOUT_SIGNALLING_AND_WITHOUT_SR) {
                        PceccTunnelInfo pceccTunnelInfo = PceManager.this.pceStore.getTunnelInfo(tunnel.tunnelId());
                        pceccTunnelInfo.tunnelConsumerId(null);
                        if (PceManager.this.mastershipService.getLocalRole(tunnel.path().src().deviceId()) != MastershipRole.MASTER) break;
                        PceManager.this.crHandler.releaseLabel(tunnel);
                        break;
                    }
                    PceManager.this.pceStore.removeTunnelInfo(tunnel.tunnelId());
                    break;
                }
            }
        }
    }

    private class InternalLinkListener
    implements LinkListener {
        private InternalLinkListener() {
        }

        public void event(LinkEvent event) {
            Link link = (Link)event.subject();
            switch ((LinkEvent.Type)event.type()) {
                case LINK_ADDED: {
                    if (PceManager.this.mastershipService.getLocalRole(link.src().deviceId()) != MastershipRole.MASTER) break;
                    PceManager.this.allocateAdjacencyLabel(link);
                    break;
                }
                case LINK_REMOVED: {
                    if (PceManager.this.mastershipService.getLocalRole(link.src().deviceId()) != MastershipRole.MASTER) break;
                    PceManager.this.releaseAdjacencyLabel(link);
                    break;
                }
            }
        }
    }

    private class InternalDeviceListener
    implements DeviceListener {
        private InternalDeviceListener() {
        }

        public void event(DeviceEvent event) {
            Device specificDevice = (Device)event.subject();
            if (specificDevice == null) {
                log.error("Unable to find device from device event.");
                return;
            }
            switch ((DeviceEvent.Type)event.type()) {
                case DEVICE_ADDED: {
                    String lsrId = specificDevice.annotations().value(PceManager.LSRID);
                    if (lsrId == null) break;
                    PceManager.this.pceStore.addLsrIdDevice(lsrId, specificDevice.id());
                    DeviceId pccDeviceId = DeviceId.deviceId((String)lsrId);
                    if (!PceManager.this.pceStore.hasPccLsr(pccDeviceId)) break;
                    log.debug("Continue to perform label DB sync for device {}.", (Object)pccDeviceId.toString());
                    PceManager.this.syncLabelDb(pccDeviceId);
                    PceManager.this.pceStore.removePccLsr(pccDeviceId);
                    break;
                }
                case DEVICE_REMOVED: {
                    if (PceManager.this.mastershipService.getLocalRole(specificDevice.id()) == MastershipRole.MASTER) {
                        PceManager.this.releaseNodeLabel(specificDevice);
                    }
                    if (specificDevice.annotations().value(PceManager.LSRID) == null) break;
                    PceManager.this.pceStore.removeLsrIdDevice(specificDevice.annotations().value(PceManager.LSRID));
                    break;
                }
            }
        }
    }

    private class InternalTopologyListener
    implements TopologyListener {
        private InternalTopologyListener() {
        }

        public void event(TopologyEvent event) {
            event.reasons().forEach(e -> {
                LinkEvent linkEvent;
                if (e instanceof LinkEvent && (linkEvent = (LinkEvent)e).type() == LinkEvent.Type.LINK_REMOVED) {
                    PceManager.this.tunnelService.queryTunnel(Tunnel.Type.MPLS).forEach(t -> {
                        if (t.path().links().contains(e.subject())) {
                            PceManager.this.checkForMasterAndUpdateTunnel(t.path().src().deviceId(), t);
                        }
                    });
                }
            });
        }
    }

    protected class TeConstraintBasedLinkWeight
    implements LinkWeight {
        private final List<Constraint> constraints;

        public TeConstraintBasedLinkWeight(List<Constraint> constraints) {
            this.constraints = constraints == null ? Collections.emptyList() : ImmutableList.copyOf(constraints);
        }

        public double weight(TopologyEdge edge) {
            if (!this.constraints.iterator().hasNext()) {
                return 1.0;
            }
            Iterator<Constraint> it = this.constraints.iterator();
            double cost = 1.0;
            while (it.hasNext() && cost > 0.0) {
                Constraint constraint = it.next();
                if (constraint instanceof CapabilityConstraint) {
                    cost = ((CapabilityConstraint)constraint).isValidLink(edge.link(), PceManager.this.deviceService, PceManager.this.netCfgService) ? 1.0 : -1.0;
                    continue;
                }
                cost = constraint.cost(edge.link(), arg_0 -> ((ResourceService)PceManager.this.resourceService).isAvailable(arg_0));
            }
            return cost;
        }
    }
}

