/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pce.pceservice;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.MplsLabel;
import org.onosproject.core.ApplicationId;
import org.onosproject.incubator.net.resource.label.DefaultLabelResource;
import org.onosproject.incubator.net.resource.label.LabelResourceAdminService;
import org.onosproject.incubator.net.resource.label.LabelResourceId;
import org.onosproject.incubator.net.resource.label.LabelResourceService;
import org.onosproject.incubator.net.tunnel.DefaultLabelStack;
import org.onosproject.incubator.net.tunnel.LabelStack;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Link;
import org.onosproject.net.Path;
import org.onosproject.net.PortNumber;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flowobjective.DefaultForwardingObjective;
import org.onosproject.net.flowobjective.FlowObjectiveService;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.net.flowobjective.Objective;
import org.onosproject.pce.pcestore.api.PceStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PceccSrTeBeHandler {
    private static final Logger log = LoggerFactory.getLogger(PceccSrTeBeHandler.class);
    private static final String LABEL_RESOURCE_ADMIN_SERVICE_NULL = "Label Resource Admin Service cannot be null";
    private static final String LABEL_RESOURCE_SERVICE_NULL = "Label Resource Service cannot be null";
    private static final String PCE_STORE_NULL = "PCE Store cannot be null";
    private static final String DEVICE_ID_NULL = "Device-Id cannot be null";
    private static final String LSR_ID_NULL = "LSR-Id cannot be null";
    private static final String LINK_NULL = "Link cannot be null";
    private static final String PATH_NULL = "Path cannot be null";
    private static final String LSR_ID = "lsrId";
    private static final int PREFIX_LENGTH = 32;
    private static PceccSrTeBeHandler srTeHandlerInstance = null;
    private LabelResourceAdminService labelRsrcAdminService;
    private LabelResourceService labelRsrcService;
    private FlowObjectiveService flowObjectiveService;
    private DeviceService deviceService;
    private PceStore pceStore;
    private ApplicationId appId;

    private PceccSrTeBeHandler() {
    }

    public static PceccSrTeBeHandler getInstance() {
        if (srTeHandlerInstance == null) {
            srTeHandlerInstance = new PceccSrTeBeHandler();
        }
        return srTeHandlerInstance;
    }

    public void initialize(LabelResourceAdminService labelRsrcAdminService, LabelResourceService labelRsrcService, FlowObjectiveService flowObjectiveService, ApplicationId appId, PceStore pceStore, DeviceService deviceService) {
        this.labelRsrcAdminService = labelRsrcAdminService;
        this.labelRsrcService = labelRsrcService;
        this.flowObjectiveService = flowObjectiveService;
        this.pceStore = pceStore;
        this.appId = appId;
        this.deviceService = deviceService;
    }

    public boolean reserveGlobalPool(long beginLabel, long endLabel) {
        Preconditions.checkNotNull((Object)this.labelRsrcAdminService, (Object)LABEL_RESOURCE_ADMIN_SERVICE_NULL);
        return this.labelRsrcAdminService.createGlobalPool(LabelResourceId.labelResourceId((long)beginLabel), LabelResourceId.labelResourceId((long)endLabel));
    }

    public String getLsrId(DeviceId deviceId) {
        Preconditions.checkNotNull((Object)deviceId, (Object)DEVICE_ID_NULL);
        Device device = this.deviceService.getDevice(deviceId);
        if (device == null) {
            log.debug("Device is not available for device id {} in device service.", (Object)deviceId.toString());
            return null;
        }
        if (device.annotations() == null) {
            log.debug("Device {} does not have annotation.", (Object)device.toString());
            return null;
        }
        String lsrId = device.annotations().value(LSR_ID);
        if (lsrId == null) {
            log.debug("The lsr-id of device {} is null.", (Object)device.toString());
            return null;
        }
        return lsrId;
    }

    public boolean allocateNodeLabel(DeviceId specificDeviceId, String specificLsrId) {
        long applyNum = 1L;
        LabelResourceId specificLabelId = null;
        Preconditions.checkNotNull((Object)specificDeviceId, (Object)DEVICE_ID_NULL);
        Preconditions.checkNotNull((Object)specificLsrId, (Object)LSR_ID_NULL);
        Preconditions.checkNotNull((Object)this.labelRsrcService, (Object)LABEL_RESOURCE_SERVICE_NULL);
        Preconditions.checkNotNull((Object)this.pceStore, (Object)PCE_STORE_NULL);
        if (this.pceStore.getGlobalNodeLabel(specificDeviceId) != null) {
            log.debug("Node label was already configured for device {}.", (Object)specificDeviceId.toString());
            return false;
        }
        Collection result = this.labelRsrcService.applyFromGlobalPool(applyNum);
        if (result.size() > 0) {
            Iterator iterator = result.iterator();
            DefaultLabelResource defaultLabelResource = (DefaultLabelResource)iterator.next();
            specificLabelId = defaultLabelResource.labelResourceId();
            if (specificLabelId == null) {
                log.error("Unable to retrieve global node label for a device id {}.", (Object)specificDeviceId.toString());
                return false;
            }
        } else {
            log.error("Unable to allocate global node label for a device id {}.", (Object)specificDeviceId.toString());
            return false;
        }
        this.pceStore.addGlobalNodeLabel(specificDeviceId, specificLabelId);
        this.advertiseNodeLabelRule(specificDeviceId, specificLabelId, IpPrefix.valueOf((IpAddress)IpAddress.valueOf((String)specificLsrId), (int)32), Objective.Operation.ADD, false);
        for (Map.Entry<DeviceId, LabelResourceId> element : this.pceStore.getGlobalNodeLabels().entrySet()) {
            DeviceId otherDevId = element.getKey();
            LabelResourceId otherLabelId = element.getValue();
            String otherLsrId = this.getLsrId(otherDevId);
            if (otherLsrId == null) {
                log.error("The lsr-id of device id {} is null.", (Object)otherDevId.toString());
                this.releaseNodeLabel(specificDeviceId, specificLsrId);
                return false;
            }
            if (otherDevId.equals((Object)specificDeviceId)) continue;
            this.advertiseNodeLabelRule(otherDevId, specificLabelId, IpPrefix.valueOf((IpAddress)IpAddress.valueOf((String)specificLsrId), (int)32), Objective.Operation.ADD, false);
            this.advertiseNodeLabelRule(specificDeviceId, otherLabelId, IpPrefix.valueOf((IpAddress)IpAddress.valueOf((String)otherLsrId), (int)32), Objective.Operation.ADD, false);
        }
        return true;
    }

    public boolean releaseNodeLabel(DeviceId specificDeviceId, String specificLsrId) {
        Preconditions.checkNotNull((Object)specificDeviceId, (Object)DEVICE_ID_NULL);
        Preconditions.checkNotNull((Object)specificLsrId, (Object)LSR_ID_NULL);
        Preconditions.checkNotNull((Object)this.labelRsrcService, (Object)LABEL_RESOURCE_SERVICE_NULL);
        Preconditions.checkNotNull((Object)this.pceStore, (Object)PCE_STORE_NULL);
        boolean retValue = true;
        LabelResourceId labelId = this.pceStore.getGlobalNodeLabel(specificDeviceId);
        if (labelId == null) {
            log.error("Unable to retrieve label of a device id {} from store.", (Object)specificDeviceId.toString());
            return false;
        }
        for (Map.Entry<DeviceId, LabelResourceId> element : this.pceStore.getGlobalNodeLabels().entrySet()) {
            DeviceId otherDevId = element.getKey();
            if (specificDeviceId.equals((Object)otherDevId)) continue;
            this.advertiseNodeLabelRule(otherDevId, labelId, IpPrefix.valueOf((IpAddress)IpAddress.valueOf((String)specificLsrId), (int)32), Objective.Operation.REMOVE, false);
        }
        HashSet<LabelResourceId> release = new HashSet<LabelResourceId>();
        release.add(labelId);
        if (!this.labelRsrcService.releaseToGlobalPool(release)) {
            log.error("Unable to release label id {} from label manager.", (Object)labelId.toString());
            retValue = false;
        }
        if (!this.pceStore.removeGlobalNodeLabel(specificDeviceId)) {
            log.error("Unable to remove global node label id {} from store.", (Object)labelId.toString());
            retValue = false;
        }
        return retValue;
    }

    public boolean allocateAdjacencyLabel(Link link) {
        long applyNum = 1L;
        DeviceId srcDeviceId = link.src().deviceId();
        Preconditions.checkNotNull((Object)link, (Object)LINK_NULL);
        Preconditions.checkNotNull((Object)this.labelRsrcService, (Object)LABEL_RESOURCE_SERVICE_NULL);
        Preconditions.checkNotNull((Object)this.pceStore, (Object)PCE_STORE_NULL);
        LabelResourceId labelId = this.pceStore.getAdjLabel(link);
        if (labelId != null) {
            log.debug("Adjacency label {} was already allocated for a link {}.", (Object)labelId.toString(), (Object)link.toString());
            return false;
        }
        Collection labelList = this.labelRsrcService.applyFromDevicePool(srcDeviceId, applyNum);
        if (labelList.size() <= 0) {
            log.error("Unable to allocate label to a device id {}.", (Object)srcDeviceId.toString());
            return false;
        }
        Iterator iterator = labelList.iterator();
        DefaultLabelResource defaultLabelResource = (DefaultLabelResource)iterator.next();
        labelId = defaultLabelResource.labelResourceId();
        if (labelId == null) {
            log.error("Unable to allocate label to a device id {}.", (Object)srcDeviceId.toString());
            return false;
        }
        log.debug("Allocated adjacency label {} to a link {}.", (Object)labelId.toString(), (Object)link.toString());
        this.installAdjLabelRule(srcDeviceId, labelId, link.src().port(), link.dst().port(), Objective.Operation.ADD);
        this.pceStore.addAdjLabel(link, labelId);
        return true;
    }

    public boolean releaseAdjacencyLabel(Link link) {
        Preconditions.checkNotNull((Object)link, (Object)LINK_NULL);
        Preconditions.checkNotNull((Object)this.labelRsrcService, (Object)LABEL_RESOURCE_SERVICE_NULL);
        Preconditions.checkNotNull((Object)this.pceStore, (Object)PCE_STORE_NULL);
        boolean retValue = true;
        LabelResourceId labelId = this.pceStore.getAdjLabel(link);
        if (labelId == null) {
            log.error("Unabel to retrieve label for a link {} from store.", (Object)link.toString());
            return false;
        }
        DeviceId srcDeviceId = link.src().deviceId();
        this.installAdjLabelRule(srcDeviceId, labelId, link.src().port(), link.dst().port(), Objective.Operation.REMOVE);
        ArrayListMultimap release = ArrayListMultimap.create();
        DefaultLabelResource defaultLabelResource = new DefaultLabelResource(srcDeviceId, labelId);
        release.put((Object)srcDeviceId, (Object)defaultLabelResource);
        if (!this.labelRsrcService.releaseToDevicePool((Multimap)release)) {
            log.error("Unable to release label id {} from label manager.", (Object)labelId.toString());
            retValue = false;
        }
        if (!this.pceStore.removeAdjLabel(link)) {
            log.error("Unable to remove adjacency label id {} from store.", (Object)labelId.toString());
            retValue = false;
        }
        return retValue;
    }

    public LabelStack computeLabelStack(Path path) {
        Preconditions.checkNotNull((Object)path, (Object)PATH_NULL);
        LinkedList<LabelResourceId> labelStack = new LinkedList<LabelResourceId>();
        List linkList = path.links();
        if (linkList != null && linkList.size() > 0) {
            Link link2 = null;
            LabelResourceId nodeLabelId = null;
            LabelResourceId adjLabelId = null;
            DeviceId deviceId = null;
            for (Link link2 : linkList) {
                adjLabelId = this.pceStore.getAdjLabel(link2);
                if (adjLabelId == null) {
                    log.error("Adjacency label id is null for a link {}.", (Object)link2.toString());
                    return null;
                }
                labelStack.add(adjLabelId);
                deviceId = link2.dst().deviceId();
                nodeLabelId = this.pceStore.getGlobalNodeLabel(deviceId);
                if (nodeLabelId == null) {
                    log.error("Unable to find node label for a device id {} in store.", (Object)deviceId.toString());
                    return null;
                }
                labelStack.add(nodeLabelId);
            }
        } else {
            log.debug("Empty link in path.");
            return null;
        }
        return new DefaultLabelStack(labelStack);
    }

    private void installNodeLabelRule(DeviceId deviceId, LabelResourceId labelId, Objective.Operation type) {
        Preconditions.checkNotNull((Object)this.flowObjectiveService);
        Preconditions.checkNotNull((Object)this.appId);
        TrafficSelector.Builder selectorBuilder = DefaultTrafficSelector.builder();
        selectorBuilder.matchMplsLabel(MplsLabel.mplsLabel((int)((Long)labelId.id()).intValue()));
        TrafficTreatment treatment = DefaultTrafficTreatment.builder().build();
        DefaultForwardingObjective.Builder forwardingObjective = DefaultForwardingObjective.builder().withSelector(selectorBuilder.build()).withTreatment(treatment).withFlag(ForwardingObjective.Flag.VERSATILE).fromApp(this.appId).makePermanent();
        if (type.equals((Object)Objective.Operation.ADD)) {
            this.flowObjectiveService.forward(deviceId, forwardingObjective.add());
        } else {
            this.flowObjectiveService.forward(deviceId, forwardingObjective.remove());
        }
    }

    public void advertiseNodeLabelRule(DeviceId deviceId, LabelResourceId labelId, IpPrefix ipPrefix, Objective.Operation type, boolean bBos) {
        Preconditions.checkNotNull((Object)this.flowObjectiveService);
        Preconditions.checkNotNull((Object)this.appId);
        TrafficSelector.Builder selectorBuilder = DefaultTrafficSelector.builder();
        selectorBuilder.matchMplsLabel(MplsLabel.mplsLabel((int)((Long)labelId.id()).intValue()));
        selectorBuilder.matchIPSrc(ipPrefix);
        if (bBos) {
            selectorBuilder.matchMplsBos(bBos);
        }
        TrafficTreatment treatment = DefaultTrafficTreatment.builder().build();
        DefaultForwardingObjective.Builder forwardingObjective = DefaultForwardingObjective.builder().withSelector(selectorBuilder.build()).withTreatment(treatment).withFlag(ForwardingObjective.Flag.VERSATILE).fromApp(this.appId).makePermanent();
        if (type.equals((Object)Objective.Operation.ADD)) {
            this.flowObjectiveService.forward(deviceId, forwardingObjective.add());
        } else {
            this.flowObjectiveService.forward(deviceId, forwardingObjective.remove());
        }
    }

    public void installAdjLabelRule(DeviceId deviceId, LabelResourceId labelId, PortNumber srcPortNum, PortNumber dstPortNum, Objective.Operation type) {
        Preconditions.checkNotNull((Object)this.flowObjectiveService);
        Preconditions.checkNotNull((Object)this.appId);
        TrafficSelector.Builder selectorBuilder = DefaultTrafficSelector.builder();
        selectorBuilder.matchMplsLabel(MplsLabel.mplsLabel((int)((Long)labelId.id()).intValue()));
        selectorBuilder.matchIPSrc(IpPrefix.valueOf((int)((int)srcPortNum.toLong()), (int)32));
        selectorBuilder.matchIPDst(IpPrefix.valueOf((int)((int)dstPortNum.toLong()), (int)32));
        TrafficTreatment treatment = DefaultTrafficTreatment.builder().build();
        DefaultForwardingObjective.Builder forwardingObjective = DefaultForwardingObjective.builder().withSelector(selectorBuilder.build()).withTreatment(treatment).withFlag(ForwardingObjective.Flag.VERSATILE).fromApp(this.appId).makePermanent();
        if (type.equals((Object)Objective.Operation.ADD)) {
            this.flowObjectiveService.forward(deviceId, forwardingObjective.add());
        } else {
            this.flowObjectiveService.forward(deviceId, forwardingObjective.remove());
        }
    }
}

