/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pce.pceservice.constraint;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Link;
import org.onosproject.net.config.NetworkConfigService;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.intent.ResourceContext;
import org.onosproject.net.intent.constraint.BooleanConstraint;
import org.onosproject.pcep.api.DeviceCapability;

public final class CapabilityConstraint
extends BooleanConstraint {
    private final CapabilityType capabilityType;
    public static final String LSRID = "lsrId";
    public static final String TRUE = "true";

    private CapabilityConstraint() {
        this.capabilityType = null;
    }

    public CapabilityConstraint(CapabilityType capabilityType) {
        this.capabilityType = capabilityType;
    }

    public static CapabilityConstraint of(CapabilityType capabilityType) {
        return new CapabilityConstraint(capabilityType);
    }

    public CapabilityType capabilityType() {
        return this.capabilityType;
    }

    public boolean isValidLink(Link link, DeviceService deviceService, NetworkConfigService netCfgService) {
        if (deviceService == null || netCfgService == null) {
            return false;
        }
        Device srcDevice = deviceService.getDevice(link.src().deviceId());
        Device dstDevice = deviceService.getDevice(link.dst().deviceId());
        if (srcDevice == null || dstDevice == null) {
            return false;
        }
        String srcLsrId = srcDevice.annotations().value(LSRID);
        String dstLsrId = dstDevice.annotations().value(LSRID);
        DeviceCapability srcDeviceConfig = (DeviceCapability)netCfgService.getConfig((Object)DeviceId.deviceId((String)srcLsrId), DeviceCapability.class);
        DeviceCapability dstDeviceConfig = (DeviceCapability)netCfgService.getConfig((Object)DeviceId.deviceId((String)dstLsrId), DeviceCapability.class);
        switch (this.capabilityType) {
            case WITH_SIGNALLING: {
                return true;
            }
            case WITHOUT_SIGNALLING_AND_WITHOUT_SR: {
                return srcDeviceConfig != null && dstDeviceConfig != null && srcDeviceConfig.localLabelCap() && dstDeviceConfig.localLabelCap();
            }
            case SR_WITHOUT_SIGNALLING: {
                return srcDeviceConfig != null && dstDeviceConfig != null && srcDeviceConfig.srCap() && dstDeviceConfig.srCap() && srcDeviceConfig.labelStackCap() && dstDeviceConfig.labelStackCap();
            }
        }
        return false;
    }

    public boolean isValid(Link link, ResourceContext context) {
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.capabilityType});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof CapabilityConstraint) {
            CapabilityConstraint other = (CapabilityConstraint)((Object)obj);
            return Objects.equals((Object)this.capabilityType, (Object)other.capabilityType);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("capabilityType", (Object)this.capabilityType).toString();
    }

    public static enum CapabilityType {
        WITH_SIGNALLING(0),
        SR_WITHOUT_SIGNALLING(1),
        WITHOUT_SIGNALLING_AND_WITHOUT_SR(2);

        int value;

        private CapabilityType(int val) {
            this.value = val;
        }

        public byte type() {
            return (byte)this.value;
        }
    }
}

