/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pce.pceservice.constraint;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onosproject.net.Link;
import org.onosproject.net.Path;
import org.onosproject.net.intent.Constraint;
import org.onosproject.net.intent.ResourceContext;

public final class CostConstraint
implements Constraint {
    private final Type type;
    public static final String TE_COST = "teCost";
    public static final String COST = "cost";

    private CostConstraint() {
        this.type = null;
    }

    public CostConstraint(Type type) {
        this.type = (Type)((Object)Preconditions.checkNotNull((Object)((Object)type), (Object)"Type cannot be null"));
    }

    public static CostConstraint of(Type type) {
        return new CostConstraint(type);
    }

    public Type type() {
        return this.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof CostConstraint) {
            CostConstraint other = (CostConstraint)obj;
            return Objects.equals((Object)this.type, (Object)other.type);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).toString();
    }

    public double cost(Link link, ResourceContext context) {
        switch (this.type) {
            case COST: {
                if (link.annotations().value(COST) != null) {
                    return Double.parseDouble(link.annotations().value(COST));
                }
                return -1.0;
            }
            case TE_COST: {
                if (link.annotations().value(TE_COST) != null) {
                    return Double.parseDouble(link.annotations().value(TE_COST));
                }
                return -1.0;
            }
        }
        return -1.0;
    }

    public boolean validate(Path path, ResourceContext context) {
        return false;
    }

    public static enum Type {
        COST(1),
        TE_COST(2);

        int value;

        private Type(int val) {
            this.value = val;
        }

        public byte type() {
            return (byte)this.value;
        }
    }
}

