/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pce.pceservice.constraint;

import com.google.common.base.MoreObjects;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.onlab.util.Bandwidth;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Link;
import org.onosproject.net.PortNumber;
import org.onosproject.net.intent.ResourceContext;
import org.onosproject.net.intent.constraint.BooleanConstraint;
import org.onosproject.net.resource.Resources;

public final class SharedBandwidthConstraint
extends BooleanConstraint {
    private final List<Link> links;
    private final Bandwidth sharedBwValue;
    private final Bandwidth requestBwValue;
    private Bandwidth changedBwValue;

    private SharedBandwidthConstraint() {
        this.links = null;
        this.sharedBwValue = null;
        this.requestBwValue = null;
    }

    public SharedBandwidthConstraint(List<Link> links, Bandwidth sharedBwValue, Bandwidth requestBwValue) {
        this.links = links;
        this.sharedBwValue = sharedBwValue;
        this.requestBwValue = requestBwValue;
    }

    public static SharedBandwidthConstraint of(List<Link> links, Bandwidth sharedBwValue, Bandwidth requestBwValue) {
        return new SharedBandwidthConstraint(links, sharedBwValue, requestBwValue);
    }

    public List<Link> links() {
        return this.links;
    }

    public Bandwidth sharedBwValue() {
        return this.sharedBwValue;
    }

    public Bandwidth requestBwValue() {
        return this.requestBwValue;
    }

    public boolean isValid(Link link, ResourceContext context) {
        this.changedBwValue = this.requestBwValue;
        if (this.links.contains(link)) {
            this.changedBwValue = this.requestBwValue.isGreaterThan((Object)this.sharedBwValue) ? this.requestBwValue.subtract(this.sharedBwValue) : Bandwidth.bps((long)0L);
        }
        return Stream.of(link.src(), link.dst()).map(cp -> Resources.continuous((DeviceId)cp.deviceId(), (PortNumber)cp.port(), Bandwidth.class).resource(this.changedBwValue.bps())).allMatch(arg_0 -> ((ResourceContext)context).isAvailable(arg_0));
    }

    public int hashCode() {
        return Objects.hash(this.requestBwValue, this.sharedBwValue, this.links);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SharedBandwidthConstraint) {
            SharedBandwidthConstraint other = (SharedBandwidthConstraint)((Object)obj);
            return Objects.equals(this.requestBwValue, other.requestBwValue) && Objects.equals(this.sharedBwValue, other.sharedBwValue) && Objects.equals(this.links, other.links);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("requestBwValue", (Object)this.requestBwValue).add("sharedBwValue", (Object)this.sharedBwValue).add("links", this.links).toString();
    }
}

