/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pce.pcestore;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.onosproject.incubator.net.resource.label.LabelResourceId;
import org.onosproject.net.DeviceId;
import org.onosproject.net.PortNumber;
import org.onosproject.pce.pcestore.api.LspLocalLabelInfo;

public final class DefaultLspLocalLabelInfo
implements LspLocalLabelInfo {
    private final DeviceId deviceId;
    private final LabelResourceId inLabelId;
    private final LabelResourceId outLabelId;
    private final PortNumber inPort;
    private final PortNumber outPort;

    private DefaultLspLocalLabelInfo(DeviceId deviceId, LabelResourceId inLabelId, LabelResourceId outLabelId, PortNumber inPort, PortNumber outPort) {
        this.deviceId = deviceId;
        this.inLabelId = inLabelId;
        this.outLabelId = outLabelId;
        this.inPort = inPort;
        this.outPort = outPort;
    }

    private DefaultLspLocalLabelInfo() {
        this.deviceId = null;
        this.inLabelId = null;
        this.outLabelId = null;
        this.inPort = null;
        this.outPort = null;
    }

    @Override
    public DeviceId deviceId() {
        return this.deviceId;
    }

    @Override
    public LabelResourceId inLabelId() {
        return this.inLabelId;
    }

    @Override
    public LabelResourceId outLabelId() {
        return this.outLabelId;
    }

    @Override
    public PortNumber inPort() {
        return this.inPort;
    }

    @Override
    public PortNumber outPort() {
        return this.outPort;
    }

    public int hashCode() {
        return Objects.hash(this.deviceId, this.inLabelId, this.outLabelId, this.inPort, this.outPort);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LspLocalLabelInfo) {
            DefaultLspLocalLabelInfo other = (DefaultLspLocalLabelInfo)obj;
            return Objects.equals(this.deviceId, other.deviceId) && Objects.equals(this.inLabelId, other.inLabelId) && Objects.equals(this.outLabelId, other.outLabelId) && Objects.equals(this.inPort, other.inPort) && Objects.equals(this.outPort, other.outPort);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("DeviceId", (Object)this.deviceId.toString()).add("InLabelId", (Object)this.inLabelId.toString()).add("OutLabelId", (Object)this.outLabelId.toString()).add("InPort", (Object)this.inPort.toString()).add("OutPort", (Object)this.outPort.toString()).toString();
    }

    public static Builder builder(LspLocalLabelInfo deviceLabelInfo) {
        return new Builder(deviceLabelInfo);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements LspLocalLabelInfo.Builder {
        private DeviceId deviceId;
        private LabelResourceId inLabelId;
        private LabelResourceId outLabelId;
        private PortNumber inPort;
        private PortNumber outPort;

        private Builder() {
        }

        private Builder(LspLocalLabelInfo deviceLabelInfo) {
            this.deviceId = deviceLabelInfo.deviceId();
            this.inLabelId = deviceLabelInfo.inLabelId();
            this.outLabelId = deviceLabelInfo.outLabelId();
            this.inPort = deviceLabelInfo.inPort();
            this.outPort = deviceLabelInfo.outPort();
        }

        @Override
        public Builder deviceId(DeviceId id) {
            this.deviceId = id;
            return this;
        }

        @Override
        public Builder inLabelId(LabelResourceId id) {
            this.inLabelId = id;
            return this;
        }

        @Override
        public Builder outLabelId(LabelResourceId id) {
            this.outLabelId = id;
            return this;
        }

        @Override
        public Builder inPort(PortNumber port) {
            this.inPort = port;
            return this;
        }

        @Override
        public Builder outPort(PortNumber port) {
            this.outPort = port;
            return this;
        }

        @Override
        public LspLocalLabelInfo build() {
            return new DefaultLspLocalLabelInfo(this.deviceId, this.inLabelId, this.outLabelId, this.inPort, this.outPort);
        }
    }
}

