/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pce.pcestore;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.KryoNamespace;
import org.onosproject.incubator.net.resource.label.LabelResource;
import org.onosproject.incubator.net.resource.label.LabelResourceId;
import org.onosproject.incubator.net.tunnel.TunnelId;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Link;
import org.onosproject.net.intent.constraint.BandwidthConstraint;
import org.onosproject.net.resource.ResourceConsumer;
import org.onosproject.pce.pceservice.LspType;
import org.onosproject.pce.pceservice.TunnelConsumerId;
import org.onosproject.pce.pceservice.constraint.CapabilityConstraint;
import org.onosproject.pce.pceservice.constraint.CostConstraint;
import org.onosproject.pce.pcestore.DefaultLspLocalLabelInfo;
import org.onosproject.pce.pcestore.PcePathInfo;
import org.onosproject.pce.pcestore.PceccTunnelInfo;
import org.onosproject.pce.pcestore.api.LspLocalLabelInfo;
import org.onosproject.pce.pcestore.api.PceStore;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.AsyncDistributedSet;
import org.onosproject.store.service.ConsistentMap;
import org.onosproject.store.service.ConsistentMapBuilder;
import org.onosproject.store.service.DistributedSet;
import org.onosproject.store.service.DistributedSetBuilder;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.StorageService;
import org.onosproject.store.service.Versioned;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class DistributedPceStore
implements PceStore {
    private static final String DEVICE_ID_NULL = "Device ID cannot be null";
    private static final String DEVICE_LABEL_STORE_INFO_NULL = "Device Label Store cannot be null";
    private static final String LABEL_RESOURCE_ID_NULL = "Label Resource Id cannot be null";
    private static final String LABEL_RESOURCE_LIST_NULL = "Label Resource List cannot be null";
    private static final String LABEL_RESOURCE_NULL = "Label Resource cannot be null";
    private static final String LINK_NULL = "LINK cannot be null";
    private static final String LSP_LOCAL_LABEL_INFO_NULL = "LSP Local Label Info cannot be null";
    private static final String PATH_INFO_NULL = "Path Info cannot be null";
    private static final String PCECC_TUNNEL_INFO_NULL = "PCECC Tunnel Info cannot be null";
    private static final String TUNNEL_ID_NULL = "Tunnel Id cannot be null";
    private static final String TUNNEL_CONSUMER_ID_NULL = "Tunnel consumer Id cannot be null";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;
    private ConsistentMap<DeviceId, LabelResourceId> globalNodeLabelMap;
    private ConsistentMap<Link, LabelResourceId> adjLabelMap;
    private ConsistentMap<TunnelId, PceccTunnelInfo> tunnelInfoMap;
    private DistributedSet<PcePathInfo> failedPathSet;
    private Map<String, DeviceId> lsrIdDeviceIdMap = new HashMap<String, DeviceId>();
    private HashSet<DeviceId> pendinglabelDbSyncPccMap = new HashSet();

    @Activate
    protected void activate() {
        this.globalNodeLabelMap = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withName("onos-pce-globalnodelabelmap")).withSerializer(Serializer.using((KryoNamespace)new KryoNamespace.Builder().register(KryoNamespaces.API).register(new Class[]{LabelResourceId.class}).build()))).build();
        this.adjLabelMap = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withName("onos-pce-adjlabelmap")).withSerializer(Serializer.using((KryoNamespace)new KryoNamespace.Builder().register(KryoNamespaces.API).register(new Class[]{Link.class, LabelResource.class, LabelResourceId.class}).build()))).build();
        this.tunnelInfoMap = (ConsistentMap)((ConsistentMapBuilder)((ConsistentMapBuilder)this.storageService.consistentMapBuilder().withName("onos-pce-tunnelinfomap")).withSerializer(Serializer.using((KryoNamespace)new KryoNamespace.Builder().register(KryoNamespaces.API).register(new Class[]{TunnelId.class, PceccTunnelInfo.class, DefaultLspLocalLabelInfo.class, TunnelConsumerId.class, LabelResourceId.class}).build()))).build();
        this.failedPathSet = ((AsyncDistributedSet)((DistributedSetBuilder)((DistributedSetBuilder)this.storageService.setBuilder().withName("failed-path-info")).withSerializer(Serializer.using((KryoNamespace)new KryoNamespace.Builder().register(KryoNamespaces.API).register(new Class[]{PcePathInfo.class, CostConstraint.class, CostConstraint.Type.class, BandwidthConstraint.class, CapabilityConstraint.class, CapabilityConstraint.CapabilityType.class, LspType.class}).build()))).build()).asDistributedSet();
        this.log.info("Started");
    }

    @Deactivate
    protected void deactivate() {
        this.log.info("Stopped");
    }

    @Override
    public boolean existsGlobalNodeLabel(DeviceId id) {
        Preconditions.checkNotNull((Object)id, (Object)DEVICE_ID_NULL);
        return this.globalNodeLabelMap.containsKey((Object)id);
    }

    @Override
    public boolean existsAdjLabel(Link link) {
        Preconditions.checkNotNull((Object)link, (Object)LINK_NULL);
        return this.adjLabelMap.containsKey((Object)link);
    }

    @Override
    public boolean existsTunnelInfo(TunnelId tunnelId) {
        Preconditions.checkNotNull((Object)tunnelId, (Object)TUNNEL_ID_NULL);
        return this.tunnelInfoMap.containsKey((Object)tunnelId);
    }

    @Override
    public boolean existsFailedPathInfo(PcePathInfo failedPathInfo) {
        Preconditions.checkNotNull((Object)failedPathInfo, (Object)PATH_INFO_NULL);
        return this.failedPathSet.contains((Object)failedPathInfo);
    }

    @Override
    public int getGlobalNodeLabelCount() {
        return this.globalNodeLabelMap.size();
    }

    @Override
    public int getAdjLabelCount() {
        return this.adjLabelMap.size();
    }

    @Override
    public int getTunnelInfoCount() {
        return this.tunnelInfoMap.size();
    }

    @Override
    public int getFailedPathInfoCount() {
        return this.failedPathSet.size();
    }

    @Override
    public Map<DeviceId, LabelResourceId> getGlobalNodeLabels() {
        return this.globalNodeLabelMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (LabelResourceId)((Versioned)e.getValue()).value()));
    }

    @Override
    public Map<Link, LabelResourceId> getAdjLabels() {
        return this.adjLabelMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (LabelResourceId)((Versioned)e.getValue()).value()));
    }

    @Override
    public Map<TunnelId, PceccTunnelInfo> getTunnelInfos() {
        return this.tunnelInfoMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (PceccTunnelInfo)((Versioned)e.getValue()).value()));
    }

    @Override
    public Iterable<PcePathInfo> getFailedPathInfos() {
        return ImmutableSet.copyOf(this.failedPathSet);
    }

    @Override
    public LabelResourceId getGlobalNodeLabel(DeviceId id) {
        Preconditions.checkNotNull((Object)id, (Object)DEVICE_ID_NULL);
        return this.globalNodeLabelMap.get((Object)id) == null ? null : (LabelResourceId)this.globalNodeLabelMap.get((Object)id).value();
    }

    @Override
    public LabelResourceId getAdjLabel(Link link) {
        Preconditions.checkNotNull((Object)link, (Object)LINK_NULL);
        return this.adjLabelMap.get((Object)link) == null ? null : (LabelResourceId)this.adjLabelMap.get((Object)link).value();
    }

    @Override
    public PceccTunnelInfo getTunnelInfo(TunnelId tunnelId) {
        Preconditions.checkNotNull((Object)tunnelId, (Object)TUNNEL_ID_NULL);
        return this.tunnelInfoMap.get((Object)tunnelId) == null ? null : (PceccTunnelInfo)this.tunnelInfoMap.get((Object)tunnelId).value();
    }

    @Override
    public void addGlobalNodeLabel(DeviceId deviceId, LabelResourceId labelId) {
        Preconditions.checkNotNull((Object)deviceId, (Object)DEVICE_ID_NULL);
        Preconditions.checkNotNull((Object)labelId, (Object)LABEL_RESOURCE_ID_NULL);
        this.globalNodeLabelMap.put((Object)deviceId, (Object)labelId);
    }

    @Override
    public void addAdjLabel(Link link, LabelResourceId labelId) {
        Preconditions.checkNotNull((Object)link, (Object)LINK_NULL);
        Preconditions.checkNotNull((Object)labelId, (Object)LABEL_RESOURCE_ID_NULL);
        this.adjLabelMap.put((Object)link, (Object)labelId);
    }

    @Override
    public void addTunnelInfo(TunnelId tunnelId, PceccTunnelInfo pceccTunnelInfo) {
        Preconditions.checkNotNull((Object)tunnelId, (Object)TUNNEL_ID_NULL);
        Preconditions.checkNotNull((Object)pceccTunnelInfo, (Object)PCECC_TUNNEL_INFO_NULL);
        this.tunnelInfoMap.put((Object)tunnelId, (Object)pceccTunnelInfo);
    }

    @Override
    public void addFailedPathInfo(PcePathInfo failedPathInfo) {
        Preconditions.checkNotNull((Object)failedPathInfo, (Object)PATH_INFO_NULL);
        this.failedPathSet.add((Object)failedPathInfo);
    }

    @Override
    public boolean updateTunnelInfo(TunnelId tunnelId, List<LspLocalLabelInfo> lspLocalLabelInfoList) {
        Preconditions.checkNotNull((Object)tunnelId, (Object)TUNNEL_ID_NULL);
        Preconditions.checkNotNull(lspLocalLabelInfoList, (Object)LSP_LOCAL_LABEL_INFO_NULL);
        if (!this.tunnelInfoMap.containsKey((Object)tunnelId)) {
            this.log.debug("Tunnel info does not exist whose tunnel id is {}.", (Object)tunnelId.toString());
            return false;
        }
        PceccTunnelInfo tunnelInfo = (PceccTunnelInfo)this.tunnelInfoMap.get((Object)tunnelId).value();
        tunnelInfo.lspLocalLabelInfoList(lspLocalLabelInfoList);
        this.tunnelInfoMap.put((Object)tunnelId, (Object)tunnelInfo);
        return true;
    }

    @Override
    public boolean updateTunnelInfo(TunnelId tunnelId, ResourceConsumer tunnelConsumerId) {
        Preconditions.checkNotNull((Object)tunnelId, (Object)TUNNEL_ID_NULL);
        Preconditions.checkNotNull((Object)tunnelConsumerId, (Object)TUNNEL_CONSUMER_ID_NULL);
        if (!this.tunnelInfoMap.containsKey((Object)tunnelId)) {
            this.log.debug("Tunnel info does not exist whose tunnel id is {}.", (Object)tunnelId.toString());
            return false;
        }
        PceccTunnelInfo tunnelInfo = (PceccTunnelInfo)this.tunnelInfoMap.get((Object)tunnelId).value();
        tunnelInfo.tunnelConsumerId(tunnelConsumerId);
        this.tunnelInfoMap.put((Object)tunnelId, (Object)tunnelInfo);
        return true;
    }

    @Override
    public boolean removeGlobalNodeLabel(DeviceId id) {
        Preconditions.checkNotNull((Object)id, (Object)DEVICE_ID_NULL);
        if (this.globalNodeLabelMap.remove((Object)id) == null) {
            this.log.error("SR-TE node label deletion for device {} has failed.", (Object)id.toString());
            return false;
        }
        return true;
    }

    @Override
    public boolean removeAdjLabel(Link link) {
        Preconditions.checkNotNull((Object)link, (Object)LINK_NULL);
        if (this.adjLabelMap.remove((Object)link) == null) {
            this.log.error("Adjacency label deletion for link {} hash failed.", (Object)link.toString());
            return false;
        }
        return true;
    }

    @Override
    public boolean removeTunnelInfo(TunnelId tunnelId) {
        Preconditions.checkNotNull((Object)tunnelId, (Object)TUNNEL_ID_NULL);
        if (this.tunnelInfoMap.remove((Object)tunnelId) == null) {
            this.log.error("Tunnel info deletion for tunnel id {} has failed.", (Object)tunnelId.toString());
            return false;
        }
        return true;
    }

    @Override
    public boolean removeFailedPathInfo(PcePathInfo failedPathInfo) {
        Preconditions.checkNotNull((Object)failedPathInfo, (Object)PATH_INFO_NULL);
        if (!this.failedPathSet.remove((Object)failedPathInfo)) {
            this.log.error("Failed path info {} deletion has failed.", (Object)failedPathInfo.toString());
            return false;
        }
        return true;
    }

    @Override
    public boolean addLsrIdDevice(String lsrId, DeviceId deviceId) {
        Preconditions.checkNotNull((Object)lsrId);
        Preconditions.checkNotNull((Object)deviceId);
        this.lsrIdDeviceIdMap.put(lsrId, deviceId);
        return true;
    }

    @Override
    public boolean removeLsrIdDevice(String lsrId) {
        Preconditions.checkNotNull((Object)lsrId);
        this.lsrIdDeviceIdMap.remove(lsrId);
        return true;
    }

    @Override
    public DeviceId getLsrIdDevice(String lsrId) {
        Preconditions.checkNotNull((Object)lsrId);
        return this.lsrIdDeviceIdMap.get(lsrId);
    }

    @Override
    public boolean addPccLsr(DeviceId lsrId) {
        Preconditions.checkNotNull((Object)lsrId);
        this.pendinglabelDbSyncPccMap.add(lsrId);
        return true;
    }

    @Override
    public boolean removePccLsr(DeviceId lsrId) {
        Preconditions.checkNotNull((Object)lsrId);
        this.pendinglabelDbSyncPccMap.remove(lsrId);
        return true;
    }

    @Override
    public boolean hasPccLsr(DeviceId lsrId) {
        Preconditions.checkNotNull((Object)lsrId);
        return this.pendinglabelDbSyncPccMap.contains(lsrId);
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }
}

