/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pce.rest;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import org.onosproject.codec.CodecContext;
import org.onosproject.codec.JsonCodec;
import org.onosproject.pce.pceservice.DefaultPcePath;
import org.onosproject.pce.pceservice.PcePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PcePathCodec
extends JsonCodec<PcePath> {
    private final Logger log = LoggerFactory.getLogger(PcePathCodec.class);
    private static final String SOURCE = "source";
    private static final String DESTINATION = "destination";
    private static final String LSP_TYPE = "pathType";
    private static final String SYMBOLIC_PATH_NAME = "name";
    private static final String CONSTRAINT = "constraint";
    private static final String COST = "cost";
    private static final String BANDWIDTH = "bandwidth";
    private static final String PATH_ID = "pathId";
    private static final String MISSING_MEMBER_MESSAGE = " member is required in pce-path";

    public PcePath decode(ObjectNode json, CodecContext context) {
        JsonNode constraintJNode;
        if (json == null || !json.isObject()) {
            this.log.error("Empty json input");
            return null;
        }
        DefaultPcePath.Builder resultBuilder = new DefaultPcePath.Builder();
        JsonNode jNode = json.get(SOURCE);
        if (jNode != null) {
            String src = jNode.asText();
            resultBuilder.source(src);
        }
        if ((jNode = json.get(DESTINATION)) != null) {
            String dst = jNode.asText();
            resultBuilder.destination(dst);
        }
        if ((jNode = json.get(LSP_TYPE)) != null) {
            String lspType = jNode.asText();
            resultBuilder.lspType(lspType);
        }
        if ((jNode = json.get(SYMBOLIC_PATH_NAME)) != null) {
            String name = jNode.asText();
            resultBuilder.name(name);
        }
        if ((constraintJNode = json.path(CONSTRAINT)) != null && !constraintJNode.isMissingNode()) {
            jNode = constraintJNode.get(COST);
            if (jNode != null) {
                String cost = jNode.asText();
                resultBuilder.costConstraint(cost);
            }
            if ((jNode = constraintJNode.get(BANDWIDTH)) != null) {
                String bandwidth = jNode.asText();
                resultBuilder.bandwidthConstraint(bandwidth);
            }
        }
        return resultBuilder.build();
    }

    public ObjectNode encode(PcePath path, CodecContext context) {
        Preconditions.checkNotNull((Object)path, (Object)"path output cannot be null");
        ObjectNode result = context.mapper().createObjectNode().put(PATH_ID, (String)path.id().id()).put(SOURCE, path.source()).put(DESTINATION, path.destination()).put(LSP_TYPE, (short)path.lspType().type()).put(SYMBOLIC_PATH_NAME, path.name());
        ObjectNode constraintNode = context.mapper().createObjectNode().put(COST, path.costConstraint().toString()).put(BANDWIDTH, path.bandwidthConstraint().toString());
        result.set(CONSTRAINT, (JsonNode)constraintNode);
        return result;
    }
}

