/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pce.rest;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.onlab.util.Tools;
import org.onosproject.codec.CodecContext;
import org.onosproject.incubator.net.tunnel.Tunnel;
import org.onosproject.incubator.net.tunnel.TunnelId;
import org.onosproject.net.DeviceId;
import org.onosproject.net.intent.Constraint;
import org.onosproject.pce.pceservice.DefaultPcePath;
import org.onosproject.pce.pceservice.LspType;
import org.onosproject.pce.pceservice.PcePath;
import org.onosproject.pce.pceservice.api.PceService;
import org.onosproject.rest.AbstractWebResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="path")
public class PcePathWebResource
extends AbstractWebResource {
    private final Logger log = LoggerFactory.getLogger(PcePathWebResource.class);
    public static final String PCE_PATH_NOT_FOUND = "Path not found";
    public static final String PCE_PATH_ID_EXIST = "Path exists";
    public static final String PCE_PATH_ID_NOT_EXIST = "Path does not exist for the identifier";
    public static final String PCE_SETUP_PATH_FAILED = "PCE Setup path has failed.";

    @GET
    @Produces(value={"application/json"})
    public Response queryAllPath() {
        this.log.debug("Query all paths.");
        Iterable<Tunnel> tunnels = ((PceService)this.get(PceService.class)).queryAllPath();
        ObjectNode result = this.mapper().createObjectNode();
        ArrayNode pathEntry = result.putArray("paths");
        if (tunnels != null) {
            for (Tunnel tunnel : tunnels) {
                PcePath path = DefaultPcePath.builder().of(tunnel).build();
                pathEntry.add((JsonNode)this.codec(PcePath.class).encode((Object)path, (CodecContext)this));
            }
        }
        return PcePathWebResource.ok((Object)result.toString()).build();
    }

    @GET
    @Path(value="{path_id}")
    @Produces(value={"application/json"})
    public Response queryPath(@PathParam(value="path_id") String id) {
        this.log.debug("Query path by identifier {}.", (Object)id);
        Tunnel tunnel = (Tunnel)Tools.nullIsNotFound((Object)((PceService)this.get(PceService.class)).queryPath(TunnelId.valueOf((String)id)), (String)PCE_PATH_NOT_FOUND);
        PcePath path = DefaultPcePath.builder().of(tunnel).build();
        ObjectNode result = this.mapper().createObjectNode();
        result.set("path", (JsonNode)this.codec(PcePath.class).encode((Object)path, (CodecContext)this));
        return PcePathWebResource.ok((Object)result.toString()).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response setupPath(InputStream stream) {
        this.log.debug("Setup path.");
        try {
            ObjectNode jsonTree = (ObjectNode)this.mapper().readTree(stream);
            JsonNode port = jsonTree.get("path");
            PcePath path = (PcePath)this.codec(PcePath.class).decode((ObjectNode)port, (CodecContext)this);
            DeviceId srcDevice = DeviceId.deviceId((String)path.source());
            DeviceId dstDevice = DeviceId.deviceId((String)path.destination());
            LspType lspType = path.lspType();
            LinkedList<Constraint> listConstrnt = new LinkedList<Constraint>();
            listConstrnt.add(path.bandwidthConstraint());
            listConstrnt.add(path.costConstraint());
            Boolean issuccess = (Boolean)Tools.nullIsNotFound((Object)((PceService)this.get(PceService.class)).setupPath(srcDevice, dstDevice, path.name(), listConstrnt, lspType), (String)PCE_SETUP_PATH_FAILED);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)issuccess.toString()).build();
        }
        catch (IOException e) {
            this.log.error("Exception while creating path {}.", (Object)e.toString());
            throw new IllegalArgumentException(e);
        }
    }

    @PUT
    @Path(value="{path_id}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response updatePath(@PathParam(value="path_id") String id, InputStream stream) {
        this.log.debug("Update path by identifier {}.", (Object)id);
        try {
            ObjectNode jsonTree = (ObjectNode)this.mapper().readTree(stream);
            JsonNode pathNode = jsonTree.get("path");
            PcePath path = (PcePath)this.codec(PcePath.class).decode((ObjectNode)pathNode, (CodecContext)this);
            LinkedList<Constraint> constrntList = new LinkedList<Constraint>();
            if (path.bandwidthConstraint() != null) {
                constrntList.add(path.bandwidthConstraint());
            }
            if (path.costConstraint() != null) {
                constrntList.add(path.costConstraint());
            }
            Boolean result = (Boolean)Tools.nullIsNotFound((Object)((PceService)this.get(PceService.class)).updatePath(TunnelId.valueOf((String)id), constrntList), (String)PCE_PATH_NOT_FOUND);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)result.toString()).build();
        }
        catch (IOException e) {
            this.log.error("Update path failed because of exception {}.", (Object)e.toString());
            throw new IllegalArgumentException(e);
        }
    }

    @Path(value="{path_id}")
    @DELETE
    public Response releasePath(@PathParam(value="path_id") String id) {
        this.log.debug("Deletes path by identifier {}.", (Object)id);
        Boolean isSuccess = (Boolean)Tools.nullIsNotFound((Object)((PceService)this.get(PceService.class)).releasePath(TunnelId.valueOf((String)id)), (String)PCE_PATH_NOT_FOUND);
        if (!isSuccess.booleanValue()) {
            this.log.debug("Path identifier {} does not exist", (Object)id);
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)isSuccess.toString()).build();
    }
}

