/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pim.cli;

import java.util.Set;
import org.apache.karaf.shell.commands.Command;
import org.onlab.util.Tools;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.pim.impl.PIMInterface;
import org.onosproject.pim.impl.PIMInterfaceService;
import org.onosproject.pim.impl.PIMNeighbor;

@Command(scope="onos", name="pim-neighbors", description="Lists the PIM neighbors")
public class PimNeighborsListCommand
extends AbstractShellCommand {
    private static final String INTF_FORMAT = "interface=%s, address=%s";
    private static final String NEIGHBOR_FORMAT = "  neighbor=%s, uptime=%s, holdtime=%s, drPriority=%s, genId=%s";

    protected void execute() {
        PIMInterfaceService interfaceService = (PIMInterfaceService)PimNeighborsListCommand.get(PIMInterfaceService.class);
        Set<PIMInterface> interfaces = interfaceService.getPimInterfaces();
        for (PIMInterface intf : interfaces) {
            this.print(INTF_FORMAT, new Object[]{intf.getInterface().name(), intf.getIpAddress()});
            for (PIMNeighbor neighbor : intf.getNeighbors()) {
                if (neighbor.ipAddress().equals((Object)intf.getIpAddress())) continue;
                this.print(NEIGHBOR_FORMAT, new Object[]{neighbor.ipAddress(), Tools.timeAgo((long)neighbor.upTime()), neighbor.holdtime(), neighbor.priority(), neighbor.generationId()});
            }
        }
    }
}

