/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pim.impl;

import org.onlab.packet.Ethernet;
import org.onlab.packet.IPacket;
import org.onlab.packet.IPv4;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.MacAddress;
import org.onlab.packet.PIM;

public class PIMPacket {
    private Ethernet ethHeader = new Ethernet();
    private IPv4 ipHeader = new IPv4();
    private PIM pimHeader = new PIM();
    private byte pimType;
    private MacAddress pimDestinationMac = MacAddress.valueOf((String)"01:00:5E:00:00:0d");

    public PIMPacket(byte type) {
        this.pimType = type;
        this.initDefaults();
    }

    public void initDefaults() {
        this.ethHeader.setDestinationMACAddress(this.pimDestinationMac);
        this.ethHeader.setEtherType(Ethernet.TYPE_IPV4);
        this.ipHeader.setDestinationAddress(PIM.PIM_ADDRESS.getIp4Address().toInt());
        this.ipHeader.setTtl((byte)1);
        this.ipHeader.setProtocol((byte)103);
        this.ethHeader.setPayload((IPacket)this.ipHeader);
        this.ipHeader.setParent((IPacket)this.ethHeader);
        this.pimHeader.setPIMType(this.pimType);
        this.ipHeader.setPayload((IPacket)this.pimHeader);
        this.pimHeader.setParent((IPacket)this.ipHeader);
    }

    public void setSrcMacAddr(MacAddress src) {
        this.ethHeader.setSourceMACAddress(src);
    }

    public void setSrcIpAddress(Ip4Address ipSrcAddress) {
        this.ipHeader.setSourceAddress(ipSrcAddress.toInt());
    }

    public void setPIMPayload(IPacket payload) {
        this.pimHeader.setPayload(payload);
        payload.setParent((IPacket)this.pimHeader);
    }

    public Ethernet getEthernet() {
        return this.ethHeader;
    }

    public IPv4 getIpv4() {
        return this.ipHeader;
    }
}

