/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pim.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.SafeRecurringTask;
import org.onosproject.event.EventListener;
import org.onosproject.incubator.net.intf.Interface;
import org.onosproject.incubator.net.intf.InterfaceEvent;
import org.onosproject.incubator.net.intf.InterfaceListener;
import org.onosproject.incubator.net.intf.InterfaceService;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Host;
import org.onosproject.net.config.ConfigFactory;
import org.onosproject.net.config.NetworkConfigEvent;
import org.onosproject.net.config.NetworkConfigListener;
import org.onosproject.net.config.NetworkConfigRegistry;
import org.onosproject.net.config.basics.SubjectFactories;
import org.onosproject.net.host.HostService;
import org.onosproject.net.mcast.McastEvent;
import org.onosproject.net.mcast.McastListener;
import org.onosproject.net.mcast.McastRoute;
import org.onosproject.net.mcast.McastRouteInfo;
import org.onosproject.net.mcast.MulticastRouteService;
import org.onosproject.net.packet.PacketService;
import org.onosproject.pim.impl.PIMInterface;
import org.onosproject.pim.impl.PIMInterfaceService;
import org.onosproject.pim.impl.PimInterfaceConfig;
import org.onosproject.routing.RouteEntry;
import org.onosproject.routing.RoutingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class PIMInterfaceManager
implements PIMInterfaceService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final Class<PimInterfaceConfig> PIM_INTERFACE_CONFIG_CLASS = PimInterfaceConfig.class;
    private static final String PIM_INTERFACE_CONFIG_KEY = "pimInterface";
    public static final int DEFAULT_HELLO_INTERVAL = 30;
    private static final int DEFAULT_TASK_PERIOD_MS = 250;
    private final ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1);
    private final long initialHelloDelay = 1000L;
    private final long pimHelloPeriod = 250L;
    private final int timeoutTaskPeriod = 250;
    private final int joinTaskPeriod = 10000;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected PacketService packetService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected NetworkConfigRegistry networkConfig;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected InterfaceService interfaceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected HostService hostService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected MulticastRouteService multicastRouteService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected RoutingService unicastRoutingService;
    private final Map<ConnectPoint, PIMInterface> pimInterfaces = Maps.newConcurrentMap();
    private final Map<McastRoute, PIMInterface> routes = Maps.newConcurrentMap();
    private final InternalNetworkConfigListener configListener = new InternalNetworkConfigListener();
    private final InternalInterfaceListener interfaceListener = new InternalInterfaceListener();
    private final InternalMulticastListener multicastListener = new InternalMulticastListener();
    private final ConfigFactory<ConnectPoint, PimInterfaceConfig> pimConfigFactory = new ConfigFactory<ConnectPoint, PimInterfaceConfig>(SubjectFactories.CONNECT_POINT_SUBJECT_FACTORY, PIM_INTERFACE_CONFIG_CLASS, "pimInterface"){

        public PimInterfaceConfig createConfig() {
            return new PimInterfaceConfig();
        }
    };

    @Activate
    public void activate() {
        this.networkConfig.registerConfigFactory(this.pimConfigFactory);
        Set subjects = this.networkConfig.getSubjects(ConnectPoint.class, PIM_INTERFACE_CONFIG_CLASS);
        for (ConnectPoint cp : subjects) {
            PimInterfaceConfig config = (PimInterfaceConfig)this.networkConfig.getConfig((Object)cp, PIM_INTERFACE_CONFIG_CLASS);
            this.updateInterface(config);
        }
        this.networkConfig.addListener((EventListener)this.configListener);
        this.interfaceService.addListener((EventListener)this.interfaceListener);
        this.multicastRouteService.addListener((EventListener)this.multicastListener);
        this.multicastRouteService.getRoutes().forEach(this::addRoute);
        this.scheduledExecutorService.scheduleAtFixedRate((Runnable)SafeRecurringTask.wrap(() -> this.pimInterfaces.values().forEach(PIMInterface::sendHello)), 1000L, 250L, TimeUnit.MILLISECONDS);
        this.scheduledExecutorService.scheduleAtFixedRate((Runnable)SafeRecurringTask.wrap(() -> this.pimInterfaces.values().forEach(PIMInterface::checkNeighborTimeouts)), 0L, 250L, TimeUnit.MILLISECONDS);
        this.scheduledExecutorService.scheduleAtFixedRate((Runnable)SafeRecurringTask.wrap(() -> this.pimInterfaces.values().forEach(PIMInterface::sendJoins)), 0L, 10000L, TimeUnit.MILLISECONDS);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.interfaceService.removeListener((EventListener)this.interfaceListener);
        this.networkConfig.removeListener((EventListener)this.configListener);
        this.multicastRouteService.removeListener((EventListener)this.multicastListener);
        this.networkConfig.unregisterConfigFactory(this.pimConfigFactory);
        this.scheduledExecutorService.shutdown();
        this.log.info("Stopped");
    }

    @Override
    public PIMInterface getPIMInterface(ConnectPoint cp) {
        PIMInterface pi = this.pimInterfaces.get(cp);
        if (pi == null && this.log.isTraceEnabled()) {
            this.log.trace("We have been asked for an Interface we don't have: {}", (Object)cp);
        }
        return pi;
    }

    @Override
    public Set<PIMInterface> getPimInterfaces() {
        return ImmutableSet.copyOf(this.pimInterfaces.values());
    }

    private void updateInterface(PimInterfaceConfig config) {
        ConnectPoint cp = (ConnectPoint)config.subject();
        if (!config.isEnabled()) {
            this.removeInterface(cp);
            return;
        }
        String intfName = config.getInterfaceName();
        Interface intf = this.interfaceService.getInterfaceByName(cp, intfName);
        if (intf == null) {
            this.log.debug("Interface configuration missing: {}", (Object)config.getInterfaceName());
            return;
        }
        this.log.debug("Updating Interface for " + intf.connectPoint().toString());
        this.pimInterfaces.computeIfAbsent(cp, k -> this.buildPimInterface(config, intf));
    }

    private void removeInterface(ConnectPoint cp) {
        this.pimInterfaces.remove(cp);
    }

    private PIMInterface buildPimInterface(PimInterfaceConfig config, Interface intf) {
        PIMInterface.Builder builder = PIMInterface.builder().withPacketService(this.packetService).withInterface(intf);
        config.getHelloInterval().ifPresent(builder::withHelloInterval);
        config.getHoldTime().ifPresent(builder::withHoldTime);
        config.getPriority().ifPresent(builder::withPriority);
        config.getPropagationDelay().ifPresent(builder::withPropagationDelay);
        config.getOverrideInterval().ifPresent(builder::withOverrideInterval);
        return builder.build();
    }

    private void addRoute(McastRoute route) {
        PIMInterface pimInterface = this.getSourceInterface(route);
        if (pimInterface == null) {
            return;
        }
        this.routes.put(route, pimInterface);
    }

    private void removeRoute(McastRoute route) {
        PIMInterface pimInterface = this.routes.remove(route);
        if (pimInterface == null) {
            return;
        }
        pimInterface.removeRoute(route);
    }

    private PIMInterface getSourceInterface(McastRoute route) {
        RouteEntry routeEntry = this.unicastRoutingService.getLongestMatchableRouteEntry(route.source());
        if (routeEntry == null) {
            this.log.warn("No route to source {}", (Object)route.source());
            return null;
        }
        Interface intf = this.interfaceService.getMatchingInterface(routeEntry.nextHop());
        if (intf == null) {
            this.log.warn("No interface with route to next hop {}", (Object)routeEntry.nextHop());
            return null;
        }
        PIMInterface pimInterface = this.pimInterfaces.get(intf.connectPoint());
        if (pimInterface == null) {
            this.log.warn("PIM is not enabled on interface {}", (Object)intf);
            return null;
        }
        Set hosts = this.hostService.getHostsByIp(routeEntry.nextHop());
        Host host = null;
        for (Host h : hosts) {
            if (!h.vlan().equals((Object)intf.vlan())) continue;
            host = h;
        }
        if (host == null) {
            this.log.warn("Next hop host entry not found: {}", (Object)routeEntry.nextHop());
            return null;
        }
        pimInterface.addRoute(route, routeEntry.nextHop(), host.mac());
        return pimInterface;
    }

    protected void bindPacketService(PacketService packetService) {
        this.packetService = packetService;
    }

    protected void unbindPacketService(PacketService packetService) {
        if (this.packetService == packetService) {
            this.packetService = null;
        }
    }

    protected void bindNetworkConfig(NetworkConfigRegistry networkConfigRegistry) {
        this.networkConfig = networkConfigRegistry;
    }

    protected void unbindNetworkConfig(NetworkConfigRegistry networkConfigRegistry) {
        if (this.networkConfig == networkConfigRegistry) {
            this.networkConfig = null;
        }
    }

    protected void bindInterfaceService(InterfaceService interfaceService) {
        this.interfaceService = interfaceService;
    }

    protected void unbindInterfaceService(InterfaceService interfaceService) {
        if (this.interfaceService == interfaceService) {
            this.interfaceService = null;
        }
    }

    protected void bindHostService(HostService hostService) {
        this.hostService = hostService;
    }

    protected void unbindHostService(HostService hostService) {
        if (this.hostService == hostService) {
            this.hostService = null;
        }
    }

    protected void bindMulticastRouteService(MulticastRouteService multicastRouteService) {
        this.multicastRouteService = multicastRouteService;
    }

    protected void unbindMulticastRouteService(MulticastRouteService multicastRouteService) {
        if (this.multicastRouteService == multicastRouteService) {
            this.multicastRouteService = null;
        }
    }

    protected void bindUnicastRoutingService(RoutingService routingService) {
        this.unicastRoutingService = routingService;
    }

    protected void unbindUnicastRoutingService(RoutingService routingService) {
        if (this.unicastRoutingService == routingService) {
            this.unicastRoutingService = null;
        }
    }

    private class InternalMulticastListener
    implements McastListener {
        private InternalMulticastListener() {
        }

        public void event(McastEvent event) {
            switch ((McastEvent.Type)event.type()) {
                case ROUTE_ADDED: {
                    PIMInterfaceManager.this.addRoute(((McastRouteInfo)event.subject()).route());
                    break;
                }
                case ROUTE_REMOVED: {
                    PIMInterfaceManager.this.removeRoute(((McastRouteInfo)event.subject()).route());
                    break;
                }
            }
        }
    }

    private class InternalInterfaceListener
    implements InterfaceListener {
        private InternalInterfaceListener() {
        }

        public void event(InterfaceEvent event) {
            switch ((InterfaceEvent.Type)event.type()) {
                case INTERFACE_ADDED: {
                    PimInterfaceConfig config = (PimInterfaceConfig)PIMInterfaceManager.this.networkConfig.getConfig((Object)((Interface)event.subject()).connectPoint(), PIM_INTERFACE_CONFIG_CLASS);
                    if (config == null) break;
                    PIMInterfaceManager.this.updateInterface(config);
                    break;
                }
                case INTERFACE_UPDATED: {
                    break;
                }
                case INTERFACE_REMOVED: {
                    PIMInterfaceManager.this.removeInterface(((Interface)event.subject()).connectPoint());
                    break;
                }
            }
        }
    }

    private class InternalNetworkConfigListener
    implements NetworkConfigListener {
        private InternalNetworkConfigListener() {
        }

        public void event(NetworkConfigEvent event) {
            if (event.configClass() != PIM_INTERFACE_CONFIG_CLASS) {
                return;
            }
            switch ((NetworkConfigEvent.Type)event.type()) {
                case CONFIG_REGISTERED: 
                case CONFIG_UNREGISTERED: {
                    break;
                }
                case CONFIG_ADDED: 
                case CONFIG_UPDATED: {
                    ConnectPoint cp = (ConnectPoint)event.subject();
                    PimInterfaceConfig config = (PimInterfaceConfig)PIMInterfaceManager.this.networkConfig.getConfig((Object)cp, PIM_INTERFACE_CONFIG_CLASS);
                    PIMInterfaceManager.this.updateInterface(config);
                    break;
                }
                case CONFIG_REMOVED: {
                    PIMInterfaceManager.this.removeInterface((ConnectPoint)event.subject());
                    break;
                }
            }
        }
    }
}

