/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.pim.impl;

import java.util.Optional;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onlab.packet.Ethernet;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.mcast.MulticastRouteService;
import org.onosproject.net.packet.InboundPacket;
import org.onosproject.net.packet.PacketContext;
import org.onosproject.net.packet.PacketPriority;
import org.onosproject.net.packet.PacketProcessor;
import org.onosproject.net.packet.PacketService;
import org.onosproject.pim.impl.PimInterface;
import org.onosproject.pim.impl.PimInterfaceService;
import org.onosproject.pim.impl.PimPacketHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class PimApplication {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    private static ApplicationId appId;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected PacketService packetService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected MulticastRouteService ms;
    protected PimPacketHandler pimPacketHandler;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected PimInterfaceService pimInterfaceManager;
    private final PimPacketProcessor processor = new PimPacketProcessor();

    @Activate
    public void activate() {
        appId = this.coreService.registerApplication("org.onosproject.pim");
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        selector.matchEthType(Ethernet.TYPE_IPV4);
        selector.matchIPProtocol((byte)103);
        this.packetService.addProcessor((PacketProcessor)this.processor, PacketProcessor.director((int)5));
        this.packetService.requestPackets(selector.build(), PacketPriority.CONTROL, appId, Optional.empty());
        this.pimPacketHandler = new PimPacketHandler();
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.packetService.removeProcessor((PacketProcessor)this.processor);
        this.log.info("Stopped");
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindPacketService(PacketService packetService) {
        this.packetService = packetService;
    }

    protected void unbindPacketService(PacketService packetService) {
        if (this.packetService == packetService) {
            this.packetService = null;
        }
    }

    protected void bindMs(MulticastRouteService multicastRouteService) {
        this.ms = multicastRouteService;
    }

    protected void unbindMs(MulticastRouteService multicastRouteService) {
        if (this.ms == multicastRouteService) {
            this.ms = null;
        }
    }

    protected void bindPimInterfaceManager(PimInterfaceService pimInterfaceService) {
        this.pimInterfaceManager = pimInterfaceService;
    }

    protected void unbindPimInterfaceManager(PimInterfaceService pimInterfaceService) {
        if (this.pimInterfaceManager == pimInterfaceService) {
            this.pimInterfaceManager = null;
        }
    }

    public class PimPacketProcessor
    implements PacketProcessor {
        public void process(PacketContext context) {
            if (context.isHandled()) {
                return;
            }
            InboundPacket pkt = context.inPacket();
            if (pkt == null) {
                PimApplication.this.log.debug("Could not retrieve packet from context");
                return;
            }
            Ethernet eth = pkt.parsed();
            if (eth == null) {
                PimApplication.this.log.debug("Could not retrieve ethernet packet from the parsed packet");
                return;
            }
            PimInterface pimi = PimApplication.this.pimInterfaceManager.getPimInterface(pkt.receivedFrom());
            if (pimi == null) {
                return;
            }
            PimApplication.this.pimPacketHandler.processPacket(eth, pimi);
        }
    }
}

