/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.sfcweb;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.TimerTask;
import jersey.repackaged.com.google.common.collect.Lists;
import org.onlab.osgi.DefaultServiceDirectory;
import org.onlab.osgi.ServiceDirectory;
import org.onlab.packet.MacAddress;
import org.onosproject.net.DefaultEdgeLink;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Element;
import org.onosproject.net.Host;
import org.onosproject.net.HostId;
import org.onosproject.net.Link;
import org.onosproject.net.host.HostService;
import org.onosproject.net.link.LinkService;
import org.onosproject.sfcweb.SfcLink;
import org.onosproject.sfcweb.SfcLinkMap;
import org.onosproject.ui.RequestHandler;
import org.onosproject.ui.UiConnection;
import org.onosproject.ui.UiMessageHandler;
import org.onosproject.ui.topo.DeviceHighlight;
import org.onosproject.ui.topo.Highlights;
import org.onosproject.ui.topo.HostHighlight;
import org.onosproject.ui.topo.NodeBadge;
import org.onosproject.ui.topo.TopoJson;
import org.onosproject.vtnrsc.FiveTuple;
import org.onosproject.vtnrsc.FixedIp;
import org.onosproject.vtnrsc.LoadBalanceId;
import org.onosproject.vtnrsc.PortChain;
import org.onosproject.vtnrsc.PortChainId;
import org.onosproject.vtnrsc.PortPair;
import org.onosproject.vtnrsc.PortPairId;
import org.onosproject.vtnrsc.VirtualPort;
import org.onosproject.vtnrsc.VirtualPortId;
import org.onosproject.vtnrsc.portchain.PortChainService;
import org.onosproject.vtnrsc.portpair.PortPairService;
import org.onosproject.vtnrsc.portpairgroup.PortPairGroupService;
import org.onosproject.vtnrsc.service.VtnRscService;
import org.onosproject.vtnrsc.virtualport.VirtualPortService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SfcwebUiTopovMessageHandler
extends UiMessageHandler {
    private static final String SAMPLE_TOPOV_DISPLAY_START = "sfcwebTopovDisplayStart";
    private static final String SAMPLE_TOPOV_DISPLAY_SFC = "showSfcInfo";
    private static final String SAMPLE_TOPOV_DISPLAY_STOP = "sfcTopovClear";
    private static final String CONFIG_SFP_MSG = "configSfpMessage";
    private static final String SAMPLE_TOPOV_SHOW_SFC_PATH = "showSfcPath";
    private static final String ID = "id";
    private static final String MODE = "mode";
    private static final String CLASSIFIER = "CLS";
    private static final String FORWARDER = "SFF";
    private static final Link[] EMPTY_LINK_SET = new Link[0];
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private HostService hostService;
    private LinkService linkService;
    private TimerTask demoTask = null;
    private Mode currentMode = Mode.IDLE;
    private Element elementOfNote;
    private Link[] linkSet = EMPTY_LINK_SET;
    protected PortPairService portPairService;
    protected VtnRscService vtnRscService;
    protected VirtualPortService virtualPortService;
    protected PortChainService portChainService;
    protected PortPairGroupService portPairGroupService;

    public void init(UiConnection connection, ServiceDirectory directory) {
        super.init(connection, directory);
        this.hostService = (HostService)directory.get(HostService.class);
        this.linkService = (LinkService)directory.get(LinkService.class);
        this.portChainService = (PortChainService)directory.get(PortChainService.class);
        this.portPairService = (PortPairService)directory.get(PortPairService.class);
        this.portPairGroupService = (PortPairGroupService)directory.get(PortPairGroupService.class);
    }

    protected Collection<RequestHandler> createRequestHandlers() {
        return ImmutableSet.of((Object)((Object)new DisplayStartHandler()), (Object)((Object)new DisplayStopHandler()), (Object)((Object)new ConfigSfpMsg()));
    }

    private Link getLinkBetweenDevices(DeviceId deviceId, DeviceId previousDeviceId) {
        Set deviceLinks = this.linkService.getDeviceEgressLinks(deviceId);
        Set previousDeviceLinks = this.linkService.getDeviceIngressLinks(previousDeviceId);
        Iterator iterator = deviceLinks.iterator();
        if (iterator.hasNext()) {
            Link link = (Link)iterator.next();
            previousDeviceLinks.contains(link);
            return link;
        }
        return null;
    }

    private void addEdgeLinks(SfcLinkMap linkMap, Host host1) {
        linkMap.add((Link)DefaultEdgeLink.createEdgeLink((Host)host1, (boolean)true));
        linkMap.add((Link)DefaultEdgeLink.createEdgeLink((Host)host1, (boolean)false));
    }

    private synchronized void cancelTask() {
        if (this.demoTask != null) {
            this.demoTask.cancel();
            this.demoTask = null;
        }
    }

    private void clearState() {
        this.currentMode = Mode.IDLE;
        this.elementOfNote = null;
        this.linkSet = EMPTY_LINK_SET;
    }

    private void clearForMode() {
        this.sendHighlights(new Highlights());
    }

    private void sendHighlights(Highlights highlights) {
        this.sendMessage(TopoJson.highlightsMessage((Highlights)highlights));
    }

    private final class ConfigSfpMsg
    extends RequestHandler {
        public ConfigSfpMsg() {
            super(SfcwebUiTopovMessageHandler.CONFIG_SFP_MSG);
        }

        public void process(long sid, ObjectNode payload) {
            String id = this.string(payload, SfcwebUiTopovMessageHandler.ID);
            DefaultServiceDirectory serviceDirectory = new DefaultServiceDirectory();
            SfcwebUiTopovMessageHandler.this.vtnRscService = (VtnRscService)serviceDirectory.get(VtnRscService.class);
            SfcwebUiTopovMessageHandler.this.virtualPortService = (VirtualPortService)serviceDirectory.get(VirtualPortService.class);
            ArrayList sfcPathList = Lists.newArrayList();
            Highlights highlights = new Highlights();
            SfcLinkMap linkMap = new SfcLinkMap();
            PortChainId portChainId = PortChainId.of((String)id);
            boolean portChainIdExist = SfcwebUiTopovMessageHandler.this.portChainService.exists(portChainId);
            if (!portChainIdExist) {
                SfcwebUiTopovMessageHandler.this.log.info("portchain id doesn't exist");
                return;
            }
            PortChain portChain = SfcwebUiTopovMessageHandler.this.portChainService.getPortChain(portChainId);
            Set fiveTupleSet = portChain.getLoadBalanceIdMapKeys();
            for (FiveTuple fiveTuple : fiveTupleSet) {
                List path = portChain.getLoadBalancePath(fiveTuple);
                LoadBalanceId lbId = portChain.getLoadBalanceId(fiveTuple);
                ListIterator pathIterator = path.listIterator();
                Host srcHost = SfcwebUiTopovMessageHandler.this.hostService.getHost(HostId.hostId((MacAddress)fiveTuple.macSrc()));
                HostHighlight hSrc = new HostHighlight(srcHost.id().toString());
                hSrc.setBadge(NodeBadge.text((String)"SRC"));
                String sfcPath = "SRC -> ";
                highlights.add(hSrc);
                DeviceId previousDeviceId = null;
                while (pathIterator.hasNext()) {
                    PortPairId portPairId = (PortPairId)pathIterator.next();
                    PortPair portPair = SfcwebUiTopovMessageHandler.this.portPairService.getPortPair(portPairId);
                    DeviceId deviceId = SfcwebUiTopovMessageHandler.this.vtnRscService.getSfToSffMaping(VirtualPortId.portId((String)portPair.egress()));
                    VirtualPort vPort = SfcwebUiTopovMessageHandler.this.virtualPortService.getPort(VirtualPortId.portId((String)portPair.egress()));
                    MacAddress dstMacAddress = vPort.macAddress();
                    Host host = SfcwebUiTopovMessageHandler.this.hostService.getHost(HostId.hostId((MacAddress)dstMacAddress));
                    SfcwebUiTopovMessageHandler.this.addEdgeLinks(linkMap, host);
                    SfcwebUiTopovMessageHandler.this.log.info("before check");
                    if (previousDeviceId != null) {
                        Link link;
                        SfcwebUiTopovMessageHandler.this.log.info("pdid not null");
                        if (!deviceId.equals(previousDeviceId) && (link = SfcwebUiTopovMessageHandler.this.getLinkBetweenDevices(deviceId, previousDeviceId)) != null) {
                            linkMap.add(link);
                        }
                    }
                    DeviceHighlight dh = new DeviceHighlight(deviceId.toString());
                    if (portChain.getSfcClassifiers(lbId).contains(deviceId)) {
                        dh.setBadge(NodeBadge.text((String)SfcwebUiTopovMessageHandler.CLASSIFIER));
                    } else {
                        dh.setBadge(NodeBadge.text((String)SfcwebUiTopovMessageHandler.FORWARDER));
                    }
                    highlights.add(dh);
                    HostHighlight hhDst = new HostHighlight(host.id().toString());
                    hhDst.setBadge(NodeBadge.text((String)portPair.name()));
                    sfcPath = sfcPath + portPair.name() + "(" + ((FixedIp)vPort.fixedIps().iterator().next()).ip() + ") -> ";
                    if (!portPair.ingress().equals(portPair.egress())) {
                        MacAddress srcMacAddress = SfcwebUiTopovMessageHandler.this.virtualPortService.getPort(VirtualPortId.portId((String)portPair.ingress())).macAddress();
                        Host hostSrc = SfcwebUiTopovMessageHandler.this.hostService.getHost(HostId.hostId((MacAddress)srcMacAddress));
                        HostHighlight hhSrc = new HostHighlight(hostSrc.id().toString());
                        hhSrc.setBadge(NodeBadge.text((String)portPair.name()));
                        highlights.add(hhSrc);
                    }
                    highlights.add(hhDst);
                    previousDeviceId = deviceId;
                }
                Host dstHost = SfcwebUiTopovMessageHandler.this.hostService.getHost(HostId.hostId((MacAddress)fiveTuple.macDst()));
                HostHighlight hDst = new HostHighlight(dstHost.id().toString());
                hDst.setBadge(NodeBadge.text((String)"DST"));
                sfcPath = sfcPath + "DST";
                highlights.add(hDst);
                sfcPathList.add(sfcPath);
            }
            for (SfcLink sfcLink : linkMap.biLinks()) {
                highlights.add(sfcLink.highlight(null));
            }
            SfcwebUiTopovMessageHandler.this.sendHighlights(highlights);
            ObjectNode result = SfcwebUiTopovMessageHandler.this.objectNode();
            ArrayNode arrayNode = SfcwebUiTopovMessageHandler.this.arrayNode();
            for (String path : sfcPathList) {
                arrayNode.add(path);
            }
            result.putArray("sfcPathList").addAll(arrayNode);
            this.sendMessage(SfcwebUiTopovMessageHandler.SAMPLE_TOPOV_SHOW_SFC_PATH, sid, result);
        }
    }

    private final class DisplayStopHandler
    extends RequestHandler {
        public DisplayStopHandler() {
            super(SfcwebUiTopovMessageHandler.SAMPLE_TOPOV_DISPLAY_STOP);
        }

        public void process(long sid, ObjectNode payload) {
            SfcwebUiTopovMessageHandler.this.log.debug("Stop Display");
            SfcwebUiTopovMessageHandler.this.clearState();
            SfcwebUiTopovMessageHandler.this.clearForMode();
            SfcwebUiTopovMessageHandler.this.cancelTask();
        }
    }

    private final class DisplayStartHandler
    extends RequestHandler {
        public DisplayStartHandler() {
            super(SfcwebUiTopovMessageHandler.SAMPLE_TOPOV_DISPLAY_START);
        }

        public void process(long sid, ObjectNode payload) {
            String mode = this.string(payload, SfcwebUiTopovMessageHandler.MODE);
            PortChainService pcs = (PortChainService)this.get(PortChainService.class);
            Iterable portChains = pcs.getPortChains();
            ObjectNode result = SfcwebUiTopovMessageHandler.this.objectNode();
            ArrayNode arrayNode = SfcwebUiTopovMessageHandler.this.arrayNode();
            for (PortChain portChain : portChains) {
                arrayNode.add(portChain.portChainId().value().toString());
            }
            result.putArray("a").addAll(arrayNode);
            this.sendMessage(SfcwebUiTopovMessageHandler.SAMPLE_TOPOV_DISPLAY_SFC, sid, result);
        }
    }

    private static enum Mode {
        IDLE,
        MOUSE,
        LINK;

    }
}

