/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.sfcweb;

import org.onlab.packet.MacAddress;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Host;
import org.onosproject.net.HostId;
import org.onosproject.net.host.HostService;
import org.onosproject.ui.UiTopoOverlay;
import org.onosproject.ui.topo.PropertyPanel;
import org.onosproject.vtnrsc.FixedIp;
import org.onosproject.vtnrsc.PortPair;
import org.onosproject.vtnrsc.VirtualPort;
import org.onosproject.vtnrsc.VirtualPortId;
import org.onosproject.vtnrsc.portpair.PortPairService;
import org.onosproject.vtnrsc.virtualport.VirtualPortService;

public class SfcwebUiTopovOverlay
extends UiTopoOverlay {
    private static final String OVERLAY_ID = "SFC-Service-overlay";
    private static final String MY_DEVICE_TITLE = "SFF specific device details";
    private static final String MY_HOST_TITLE = "SF specific host details";

    public SfcwebUiTopovOverlay() {
        super(OVERLAY_ID);
    }

    public void modifyDeviceDetails(PropertyPanel pp, DeviceId deviceId) {
        pp.title(MY_DEVICE_TITLE);
        pp.removeAllProps();
        pp.addProp("SFF Device Id", deviceId.toString());
    }

    public void modifyHostDetails(PropertyPanel pp, HostId hostId) {
        pp.title(MY_HOST_TITLE);
        pp.removeAllProps();
        PortPairService portPairService = (PortPairService)AbstractShellCommand.get(PortPairService.class);
        VirtualPortService virtualPortService = (VirtualPortService)AbstractShellCommand.get(VirtualPortService.class);
        HostService hostService = (HostService)AbstractShellCommand.get(HostService.class);
        Iterable portPairs = portPairService.getPortPairs();
        for (PortPair portPair : portPairs) {
            VirtualPort vPort = virtualPortService.getPort(VirtualPortId.portId((String)portPair.ingress()));
            MacAddress dstMacAddress = vPort.macAddress();
            Host host = hostService.getHost(HostId.hostId((MacAddress)dstMacAddress));
            if (!hostId.toString().equals(host.id().toString())) continue;
            pp.addProp("SF Name", portPair.name());
            pp.addProp("SF Ip", (Object)((FixedIp)vPort.fixedIps().iterator().next()).ip());
        }
        pp.addProp("SF host Address", hostId.toString());
    }
}

