/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.tvue;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.GET;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.onlab.packet.IpAddress;
import org.onlab.rest.BaseResource;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.Host;
import org.onosproject.net.HostId;
import org.onosproject.net.Link;
import org.onosproject.net.Path;
import org.onosproject.net.PortNumber;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.host.HostService;
import org.onosproject.net.link.LinkService;
import org.onosproject.net.topology.PathService;
import org.onosproject.net.topology.Topology;
import org.onosproject.net.topology.TopologyGraph;
import org.onosproject.net.topology.TopologyService;
import org.onosproject.net.topology.TopologyVertex;
import org.onosproject.tvue.TopologyResource;

/*
 * Exception performing whole class analysis ignored.
 */
@javax.ws.rs.Path(value="topology")
public class TopologyResource
extends BaseResource {
    @javax.ws.rs.Path(value="/graph")
    @GET
    @Produces(value={"application/json"})
    public Response graph() {
        ObjectMapper mapper = new ObjectMapper();
        DeviceService deviceService = (DeviceService)this.get(DeviceService.class);
        HostService hostService = (HostService)this.get(HostService.class);
        TopologyService topologyService = (TopologyService)this.get(TopologyService.class);
        Topology topo = topologyService.currentTopology();
        TopologyGraph graph = topologyService.getGraph(topo);
        ArrayNode vertexesNode = mapper.createArrayNode();
        for (TopologyVertex vertex : graph.getVertexes()) {
            vertexesNode.add((JsonNode)this.json(mapper, (ElementId)vertex.deviceId(), 2, vertex.deviceId().uri().getSchemeSpecificPart(), deviceService.isAvailable(vertex.deviceId())));
        }
        Map linkRecords = this.aggregateLinks();
        ArrayNode edgesNode = mapper.createArrayNode();
        for (AggLink lr : linkRecords.values()) {
            edgesNode.add((JsonNode)this.json(mapper, lr.links.size(), lr.link.src(), lr.link.dst()));
        }
        for (Host host : hostService.getHosts()) {
            Set ipAddresses = host.ipAddresses();
            IpAddress ipAddress = ipAddresses.isEmpty() ? null : (IpAddress)ipAddresses.iterator().next();
            String label = ipAddress != null ? ipAddress.toString() : host.mac().toString();
            vertexesNode.add((JsonNode)this.json(mapper, (ElementId)host.id(), 3, label, true));
            edgesNode.add((JsonNode)this.json(mapper, 1, (ConnectPoint)host.location(), new ConnectPoint((ElementId)host.id(), PortNumber.portNumber((long)-1L))));
        }
        ObjectNode rootNode = mapper.createObjectNode();
        rootNode.set("vertexes", (JsonNode)vertexesNode);
        rootNode.set("edges", (JsonNode)edgesNode);
        return Response.ok((Object)rootNode.toString()).build();
    }

    @javax.ws.rs.Path(value="/paths/{src}/{dst}")
    @GET
    @Produces(value={"application/json"})
    public Response paths(@PathParam(value="src") String src, @PathParam(value="dst") String dst) {
        ObjectMapper mapper = new ObjectMapper();
        PathService pathService = (PathService)this.get(PathService.class);
        Set paths = pathService.getPaths(this.elementId(src), this.elementId(dst));
        ArrayNode pathsNode = mapper.createArrayNode();
        for (Path path : paths) {
            pathsNode.add((JsonNode)this.json(mapper, path));
        }
        ObjectNode rootNode = mapper.createObjectNode();
        rootNode.set("paths", (JsonNode)pathsNode);
        return Response.ok((Object)rootNode.toString()).build();
    }

    private ElementId elementId(String id) {
        return id.startsWith("nic:") ? HostId.hostId((String)id) : DeviceId.deviceId((String)id);
    }

    private Map<String, AggLink> aggregateLinks() {
        HashMap<String, AggLink> aggLinks = new HashMap<String, AggLink>();
        LinkService linkService = (LinkService)this.get(LinkService.class);
        for (Link link : linkService.getLinks()) {
            String key = TopologyResource.key((Link)link);
            AggLink lr = (AggLink)aggLinks.get(key);
            if (lr == null) {
                lr = new AggLink(this, key);
                aggLinks.put(key, lr);
            }
            lr.addLink(link);
        }
        return aggLinks;
    }

    private ObjectNode json(ObjectMapper mapper, ElementId id, int group, String label, boolean isOnline) {
        return mapper.createObjectNode().put("name", id.toString()).put("label", label).put("group", group).put("online", isOnline);
    }

    private ObjectNode json(ObjectMapper mapper, int count, ConnectPoint src, ConnectPoint dst) {
        return this.json(mapper, count, TopologyResource.id((ConnectPoint)src), TopologyResource.id((ConnectPoint)dst));
    }

    private ObjectNode json(ObjectMapper mapper, int count, String src, String dst) {
        return mapper.createObjectNode().put("source", src).put("target", dst).put("value", count);
    }

    private ArrayNode json(ObjectMapper mapper, Path path) {
        ArrayNode pathNode = mapper.createArrayNode();
        for (Link link : path.links()) {
            ObjectNode linkNode = mapper.createObjectNode().put("src", TopologyResource.id((ConnectPoint)link.src())).put("dst", TopologyResource.id((ConnectPoint)link.dst()));
            pathNode.add((JsonNode)linkNode);
        }
        return pathNode;
    }

    static String key(Link link) {
        String d;
        String s = TopologyResource.id((ConnectPoint)link.src());
        return s.compareTo(d = TopologyResource.id((ConnectPoint)link.dst())) > 0 ? d + s : s + d;
    }

    private static String id(ConnectPoint cp) {
        return cp.elementId().toString();
    }
}

