/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.virtualbng;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.MacAddress;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Host;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.host.HostListener;
import org.onosproject.net.host.HostService;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentService;
import org.onosproject.net.intent.Key;
import org.onosproject.net.intent.PointToPointIntent;
import org.onosproject.virtualbng.VbngConfigurationService;
import org.onosproject.virtualbng.VbngManager;
import org.onosproject.virtualbng.VbngService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class VbngManager
implements VbngService {
    private static final String APP_NAME = "org.onosproject.virtualbng";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected HostService hostService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected IntentService intentService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected VbngConfigurationService vbngConfigurationService;
    private ApplicationId appId;
    private Map<IpAddress, PointToPointIntent> p2pIntentsFromHost;
    private Map<IpAddress, PointToPointIntent> p2pIntentsToHost;
    private Set<IpAddress> privateIpAddressSet;
    private HostListener hostListener;
    private IpAddress nextHopIpAddress;

    @Activate
    public void activate() {
        this.appId = this.coreService.registerApplication(APP_NAME);
        this.p2pIntentsFromHost = new ConcurrentHashMap();
        this.p2pIntentsToHost = new ConcurrentHashMap();
        this.privateIpAddressSet = Sets.newConcurrentHashSet();
        this.nextHopIpAddress = this.vbngConfigurationService.getNextHopIpAddress();
        this.hostListener = new InternalHostListener(this, null);
        this.hostService.addListener(this.hostListener);
        this.log.info("vBNG Started");
    }

    @Deactivate
    public void deactivate() {
        this.hostService.removeListener(this.hostListener);
        this.log.info("vBNG Stopped");
    }

    public IpAddress createVbng(IpAddress privateIpAddress) {
        IpAddress publicIpAddress = this.vbngConfigurationService.getAvailablePublicIpAddress(privateIpAddress);
        if (publicIpAddress == null) {
            this.log.info("Did not find an available public IP address to use.");
            return null;
        }
        this.log.info("[ADD] Private IP to Public IP mapping: {} --> {}", (Object)privateIpAddress, (Object)publicIpAddress);
        if (!this.setupForwardingPaths(privateIpAddress, publicIpAddress)) {
            this.privateIpAddressSet.add(privateIpAddress);
        }
        return publicIpAddress;
    }

    public IpAddress deleteVbng(IpAddress privateIpAddress) {
        IpAddress assignedPublicIpAddress = this.vbngConfigurationService.recycleAssignedPublicIpAddress(privateIpAddress);
        if (assignedPublicIpAddress == null) {
            return null;
        }
        this.privateIpAddressSet.remove(privateIpAddress);
        this.removeForwardingPaths(privateIpAddress);
        return assignedPublicIpAddress;
    }

    private void removeForwardingPaths(IpAddress privateIp) {
        PointToPointIntent toLocalHostIntent;
        PointToPointIntent toNextHopIntent = (PointToPointIntent)this.p2pIntentsFromHost.remove(privateIp);
        if (toNextHopIntent != null) {
            this.intentService.withdraw((Intent)toNextHopIntent);
        }
        if ((toLocalHostIntent = (PointToPointIntent)this.p2pIntentsToHost.remove(privateIp)) != null) {
            this.intentService.withdraw((Intent)toLocalHostIntent);
        }
    }

    private boolean setupForwardingPaths(IpAddress privateIp, IpAddress publicIp) {
        Preconditions.checkNotNull((Object)privateIp);
        Preconditions.checkNotNull((Object)publicIp);
        if (this.nextHopIpAddress == null) {
            this.log.warn("Did not find next hop IP address");
            return false;
        }
        if (this.p2pIntentsFromHost.containsKey(privateIp) && this.p2pIntentsToHost.containsKey(privateIp)) {
            return true;
        }
        Host localHost = null;
        Host nextHopHost = null;
        if (this.hostService.getHostsByIp(this.nextHopIpAddress).isEmpty()) {
            this.hostService.startMonitoringIp(this.nextHopIpAddress);
            if (this.hostService.getHostsByIp(privateIp).isEmpty()) {
                this.hostService.startMonitoringIp(privateIp);
            }
            return false;
        }
        nextHopHost = (Host)this.hostService.getHostsByIp(this.nextHopIpAddress).iterator().next();
        if (this.hostService.getHostsByIp(privateIp).isEmpty()) {
            this.hostService.startMonitoringIp(privateIp);
            return false;
        }
        localHost = (Host)this.hostService.getHostsByIp(privateIp).iterator().next();
        ConnectPoint nextHopConnectPoint = new ConnectPoint(nextHopHost.location().elementId(), nextHopHost.location().port());
        ConnectPoint localHostConnectPoint = new ConnectPoint(localHost.location().elementId(), localHost.location().port());
        if (!this.p2pIntentsFromHost.containsKey(privateIp)) {
            PointToPointIntent toNextHopIntent = this.srcMatchIntentGenerator(privateIp, publicIp, nextHopHost.mac(), nextHopConnectPoint, localHostConnectPoint);
            this.p2pIntentsFromHost.put(privateIp, toNextHopIntent);
            this.intentService.submit((Intent)toNextHopIntent);
        }
        if (!this.p2pIntentsToHost.containsKey(privateIp)) {
            PointToPointIntent toLocalHostIntent = this.dstMatchIntentGenerator(publicIp, privateIp, localHost.mac(), localHostConnectPoint, nextHopConnectPoint);
            this.p2pIntentsToHost.put(privateIp, toLocalHostIntent);
            this.intentService.submit((Intent)toLocalHostIntent);
        }
        return true;
    }

    private void createVbngAgain(IpAddress privateIpAddress) {
        IpAddress publicIpAddress = this.vbngConfigurationService.getAssignedPublicIpAddress(privateIpAddress);
        if (publicIpAddress == null) {
            this.privateIpAddressSet.remove(privateIpAddress);
            return;
        }
        if (this.setupForwardingPaths(privateIpAddress, publicIpAddress)) {
            this.privateIpAddressSet.remove(privateIpAddress);
        }
    }

    private PointToPointIntent srcMatchIntentGenerator(IpAddress srcIpAddress, IpAddress newSrcIpAddress, MacAddress dstMacAddress, ConnectPoint dstConnectPoint, ConnectPoint srcConnectPoint) {
        Preconditions.checkNotNull((Object)srcIpAddress);
        Preconditions.checkNotNull((Object)newSrcIpAddress);
        Preconditions.checkNotNull((Object)dstMacAddress);
        Preconditions.checkNotNull((Object)dstConnectPoint);
        Preconditions.checkNotNull((Object)srcConnectPoint);
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        selector.matchEthType((short)2048);
        selector.matchIPSrc(IpPrefix.valueOf((IpAddress)srcIpAddress, (int)32));
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
        treatment.setEthDst(dstMacAddress);
        treatment.setIpSrc(newSrcIpAddress);
        Key key = Key.of((String)(srcIpAddress.toString() + "MatchSrc"), (ApplicationId)this.appId);
        PointToPointIntent intent = PointToPointIntent.builder().appId(this.appId).key(key).selector(selector.build()).treatment(treatment.build()).egressPoint(dstConnectPoint).ingressPoint(srcConnectPoint).build();
        this.log.info("Generated a PointToPointIntent for traffic from local host : {}", (Object)intent);
        return intent;
    }

    private PointToPointIntent dstMatchIntentGenerator(IpAddress dstIpAddress, IpAddress newDstIpAddress, MacAddress dstMacAddress, ConnectPoint dstConnectPoint, ConnectPoint srcConnectPoint) {
        Preconditions.checkNotNull((Object)dstIpAddress);
        Preconditions.checkNotNull((Object)newDstIpAddress);
        Preconditions.checkNotNull((Object)dstMacAddress);
        Preconditions.checkNotNull((Object)dstConnectPoint);
        Preconditions.checkNotNull((Object)srcConnectPoint);
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        selector.matchEthType((short)2048);
        selector.matchIPDst(IpPrefix.valueOf((IpAddress)dstIpAddress, (int)32));
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
        treatment.setEthDst(dstMacAddress);
        treatment.setIpDst(newDstIpAddress);
        Key key = Key.of((String)(newDstIpAddress.toString() + "MatchDst"), (ApplicationId)this.appId);
        PointToPointIntent intent = PointToPointIntent.builder().appId(this.appId).key(key).selector(selector.build()).treatment(treatment.build()).egressPoint(dstConnectPoint).ingressPoint(srcConnectPoint).build();
        this.log.info("Generated a PointToPointIntent for traffic to local host : {}", (Object)intent);
        return intent;
    }

    static /* synthetic */ Logger access$100(VbngManager x0) {
        return x0.log;
    }

    static /* synthetic */ Set access$200(VbngManager x0) {
        return x0.privateIpAddressSet;
    }

    static /* synthetic */ void access$300(VbngManager x0, IpAddress x1) {
        x0.createVbngAgain(x1);
    }

    static /* synthetic */ IpAddress access$400(VbngManager x0) {
        return x0.nextHopIpAddress;
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindHostService(HostService hostService) {
        this.hostService = hostService;
    }

    protected void unbindHostService(HostService hostService) {
        if (this.hostService == hostService) {
            this.hostService = null;
        }
    }

    protected void bindIntentService(IntentService intentService) {
        this.intentService = intentService;
    }

    protected void unbindIntentService(IntentService intentService) {
        if (this.intentService == intentService) {
            this.intentService = null;
        }
    }

    protected void bindVbngConfigurationService(VbngConfigurationService vbngConfigurationService) {
        this.vbngConfigurationService = vbngConfigurationService;
    }

    protected void unbindVbngConfigurationService(VbngConfigurationService vbngConfigurationService) {
        if (this.vbngConfigurationService == vbngConfigurationService) {
            this.vbngConfigurationService = null;
        }
    }
}

