/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.virtualbng;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.List;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.MacAddress;

public final class VbngConfiguration {
    private final List<IpPrefix> localPublicIpPrefixes;
    private final IpAddress nextHopIpAddress;
    private final MacAddress publicFacingMac;

    private VbngConfiguration() {
        this.localPublicIpPrefixes = null;
        this.nextHopIpAddress = null;
        this.publicFacingMac = null;
    }

    @JsonCreator
    public VbngConfiguration(@JsonProperty(value="localPublicIpPrefixes") List<IpPrefix> prefixes, @JsonProperty(value="nextHopIpAddress") IpAddress nextHopIpAddress, @JsonProperty(value="publicFacingMac") MacAddress publicFacingMac) {
        this.localPublicIpPrefixes = prefixes;
        this.nextHopIpAddress = nextHopIpAddress;
        this.publicFacingMac = publicFacingMac;
    }

    public List<IpPrefix> getLocalPublicIpPrefixes() {
        return Collections.unmodifiableList(this.localPublicIpPrefixes);
    }

    public IpAddress getNextHopIpAddress() {
        return this.nextHopIpAddress;
    }

    public MacAddress getPublicFacingMac() {
        return this.publicFacingMac;
    }
}

