/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.virtualbng;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Map;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.onlab.packet.IpAddress;
import org.onosproject.codec.CodecContext;
import org.onosproject.rest.AbstractWebResource;
import org.onosproject.virtualbng.IpAddressMapEntryCodec;
import org.onosproject.virtualbng.VbngConfigurationService;
import org.onosproject.virtualbng.VbngService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="privateip")
public class VbngResource
extends AbstractWebResource {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @POST
    @Path(value="{privateip}")
    public String privateIpAddNotification(@PathParam(value="privateip") String privateIp) {
        if (privateIp == null) {
            this.log.info("Private IP address to add is null");
            return "0";
        }
        this.log.info("Received a private IP address : {} to add", (Object)privateIp);
        IpAddress privateIpAddress = IpAddress.valueOf((String)privateIp);
        VbngService vbngService = (VbngService)this.get(VbngService.class);
        IpAddress publicIpAddress = null;
        publicIpAddress = vbngService.createVbng(privateIpAddress);
        if (publicIpAddress != null) {
            return publicIpAddress.toString();
        }
        return "0";
    }

    @DELETE
    @Path(value="{privateip}")
    public String privateIpDeleteNotification(@PathParam(value="privateip") String privateIp) {
        if (privateIp == null) {
            this.log.info("Private IP address to delete is null");
            return "0";
        }
        this.log.info("Received a private IP address : {} to delete", (Object)privateIp);
        IpAddress privateIpAddress = IpAddress.valueOf((String)privateIp);
        VbngService vbngService = (VbngService)this.get(VbngService.class);
        IpAddress assignedPublicIpAddress = null;
        assignedPublicIpAddress = vbngService.deleteVbng(privateIpAddress);
        if (assignedPublicIpAddress != null) {
            return assignedPublicIpAddress.toString();
        }
        return "0";
    }

    @GET
    @Path(value="map")
    @Produces(value={"application/json"})
    public Response privateIpDeleteNotification() {
        this.log.info("Received vBNG IP address map request");
        VbngConfigurationService vbngConfigurationService = (VbngConfigurationService)this.get(VbngConfigurationService.class);
        Map map = vbngConfigurationService.getIpAddressMappings();
        ObjectNode result = new ObjectMapper().createObjectNode();
        result.set("map", (JsonNode)new IpAddressMapEntryCodec().encode(map.entrySet(), (CodecContext)this));
        return VbngResource.ok((Object)result.toString()).build();
    }
}

