/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.virtualbng;

import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.packet.PacketPriority;
import org.onosproject.net.packet.PacketProcessor;
import org.onosproject.net.packet.PacketService;
import org.onosproject.virtualbng.VbngConfigurationService;
import org.onosproject.virtualbng.VirtualPublicHosts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class VirtualPublicHosts {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String APP_NAME = "org.onosproject.virtualbng.VirtualPublicHosts";
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected PacketService packetService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected VbngConfigurationService vbngConfigService;
    private ApplicationId appId;
    private ArpRequestProcessor processor = new ArpRequestProcessor(this, null);

    @Activate
    public void activate() {
        this.appId = this.coreService.registerApplication(APP_NAME);
        this.packetService.addProcessor((PacketProcessor)this.processor, 715827888);
        TrafficSelector.Builder selector = DefaultTrafficSelector.builder();
        selector.matchEthType((short)2054);
        this.packetService.requestPackets(selector.build(), PacketPriority.REACTIVE, this.appId);
        this.log.info("vBNG virtual public hosts started");
    }

    @Deactivate
    public void deactivate() {
        this.packetService.removeProcessor((PacketProcessor)this.processor);
        this.processor = null;
        this.log.info("vBNG virtual public hosts Stopped");
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindPacketService(PacketService packetService) {
        this.packetService = packetService;
    }

    protected void unbindPacketService(PacketService packetService) {
        if (this.packetService == packetService) {
            this.packetService = null;
        }
    }

    protected void bindVbngConfigService(VbngConfigurationService vbngConfigurationService) {
        this.vbngConfigService = vbngConfigurationService;
    }

    protected void unbindVbngConfigService(VbngConfigurationService vbngConfigurationService) {
        if (this.vbngConfigService == vbngConfigurationService) {
            this.vbngConfigService = null;
        }
    }
}

