/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vpls;

import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.util.Pair;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentService;
import org.onosproject.net.intent.Key;
import org.onosproject.net.intent.MultiPointToSinglePointIntent;
import org.onosproject.net.intent.SinglePointToMultiPointIntent;
import org.onosproject.routing.IntentSynchronizationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntentInstaller {
    private static final Logger log = LoggerFactory.getLogger(IntentInstaller.class);
    private static final int PRIORITY_OFFSET = 1000;
    private static final String PREFIX_BROADCAST = "brc";
    private static final String PREFIX_UNICAST = "uni";
    private final ApplicationId appId;
    private final IntentSynchronizationService intentSynchronizer;
    private final IntentService intentService;

    public IntentInstaller(ApplicationId appId, IntentService intentService, IntentSynchronizationService intentSynchronizer) {
        this.appId = appId;
        this.intentService = intentService;
        this.intentSynchronizer = intentSynchronizer;
    }

    protected void installIntents(SetMultimap<VlanId, Pair<ConnectPoint, MacAddress>> confHostPresentCPoint) {
        ArrayList<Intent> intents = new ArrayList<Intent>();
        confHostPresentCPoint.asMap().keySet().forEach(vlanId -> {
            List<Pair<ConnectPoint, MacAddress>> cPoints = confHostPresentCPoint.get(vlanId).stream().collect(Collectors.toList());
            if (cPoints != null && !cPoints.isEmpty()) {
                for (int i = 0; i < cPoints.size(); ++i) {
                    Key uniKey;
                    ConnectPoint src = (ConnectPoint)((Pair)cPoints.get(i)).getKey();
                    HashSet<ConnectPoint> dsts = new HashSet<ConnectPoint>();
                    MacAddress mac = (MacAddress)((Pair)cPoints.get(i)).getValue();
                    for (int j = 0; j < cPoints.size(); ++j) {
                        ConnectPoint dst = (ConnectPoint)((Pair)cPoints.get(j)).getKey();
                        if (dst.equals((Object)src)) continue;
                        dsts.add(dst);
                    }
                    Key brcKey = this.buildKey(PREFIX_BROADCAST, src, (VlanId)vlanId);
                    if (this.intentService.getIntent(brcKey) == null) {
                        SinglePointToMultiPointIntent brcIntent = this.buildBrcIntent(brcKey, src, (Set<ConnectPoint>)dsts, (VlanId)vlanId);
                        intents.add((Intent)brcIntent);
                    }
                    if (mac == null || this.countMacInCPoints(cPoints) <= 1 || this.intentService.getIntent(uniKey = this.buildKey(PREFIX_UNICAST, src, (VlanId)vlanId)) != null) continue;
                    MultiPointToSinglePointIntent uniIntent = this.buildUniIntent(uniKey, (Set<ConnectPoint>)dsts, src, (VlanId)vlanId, mac);
                    intents.add((Intent)uniIntent);
                }
            }
        });
        this.submitIntents(intents);
    }

    private void submitIntents(Collection<Intent> intents) {
        log.debug("Submitting intents to the IntentSynchronizer");
        for (Intent intent : intents) {
            this.intentSynchronizer.submit(intent);
        }
    }

    private SinglePointToMultiPointIntent buildBrcIntent(Key key, ConnectPoint src, Set<ConnectPoint> dsts, VlanId vlanId) {
        log.debug("Building p2mp intent from {}", (Object)src);
        TrafficTreatment treatment = DefaultTrafficTreatment.emptyTreatment();
        TrafficSelector.Builder builder = DefaultTrafficSelector.builder().matchEthDst(MacAddress.BROADCAST).matchVlanId(vlanId);
        TrafficSelector selector = builder.build();
        SinglePointToMultiPointIntent intent = SinglePointToMultiPointIntent.builder().appId(this.appId).key(key).selector(selector).treatment(treatment).ingressPoint(src).egressPoints(dsts).priority(1000).build();
        return intent;
    }

    private MultiPointToSinglePointIntent buildUniIntent(Key key, Set<ConnectPoint> srcs, ConnectPoint dst, VlanId vlanId, MacAddress mac) {
        log.debug("Building mp2p intent to {}", (Object)dst);
        TrafficTreatment treatment = DefaultTrafficTreatment.emptyTreatment();
        TrafficSelector.Builder builder = DefaultTrafficSelector.builder().matchEthDst(mac).matchVlanId(vlanId);
        TrafficSelector selector = builder.build();
        MultiPointToSinglePointIntent intent = MultiPointToSinglePointIntent.builder().appId(this.appId).key(key).selector(selector).treatment(treatment).ingressPoints(srcs).egressPoint(dst).priority(1000).build();
        return intent;
    }

    private Key buildKey(String prefix, ConnectPoint cPoint, VlanId vlanId) {
        String keyString = prefix + "-" + cPoint.deviceId() + "-" + cPoint.port() + "-" + vlanId;
        return Key.of((String)keyString, (ApplicationId)this.appId);
    }

    private int countMacInCPoints(List<Pair<ConnectPoint, MacAddress>> cPoints) {
        int macFound = 0;
        for (Pair<ConnectPoint, MacAddress> p : cPoints) {
            if (p.getValue() == null) continue;
            ++macFound;
        }
        return macFound;
    }
}

