/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtn.manager.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onlab.util.KryoNamespace;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.event.EventListener;
import org.onosproject.mastership.MastershipService;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Host;
import org.onosproject.net.HostId;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.behaviour.BridgeConfig;
import org.onosproject.net.behaviour.BridgeDescription;
import org.onosproject.net.behaviour.ExtensionTreatmentResolver;
import org.onosproject.net.config.NetworkConfigService;
import org.onosproject.net.config.basics.BasicDeviceConfig;
import org.onosproject.net.device.DeviceEvent;
import org.onosproject.net.device.DeviceListener;
import org.onosproject.net.device.DeviceService;
import org.onosproject.net.driver.DriverHandler;
import org.onosproject.net.driver.DriverService;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.instructions.ExtensionTreatment;
import org.onosproject.net.flow.instructions.ExtensionTreatmentType;
import org.onosproject.net.flowobjective.Objective;
import org.onosproject.net.group.DefaultGroupBucket;
import org.onosproject.net.group.DefaultGroupDescription;
import org.onosproject.net.group.DefaultGroupKey;
import org.onosproject.net.group.GroupBucket;
import org.onosproject.net.group.GroupBuckets;
import org.onosproject.net.group.GroupDescription;
import org.onosproject.net.group.GroupKey;
import org.onosproject.net.group.GroupService;
import org.onosproject.net.host.HostEvent;
import org.onosproject.net.host.HostListener;
import org.onosproject.net.host.HostService;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.EventuallyConsistentMap;
import org.onosproject.store.service.LogicalClockService;
import org.onosproject.store.service.StorageService;
import org.onosproject.vtn.manager.VTNService;
import org.onosproject.vtn.table.ArpService;
import org.onosproject.vtn.table.ClassifierService;
import org.onosproject.vtn.table.DnatService;
import org.onosproject.vtn.table.L2ForwardService;
import org.onosproject.vtn.table.L3ForwardService;
import org.onosproject.vtn.table.SnatService;
import org.onosproject.vtn.table.impl.ArpServiceImpl;
import org.onosproject.vtn.table.impl.ClassifierServiceImpl;
import org.onosproject.vtn.table.impl.DnatServiceImpl;
import org.onosproject.vtn.table.impl.L2ForwardServiceImpl;
import org.onosproject.vtn.table.impl.L3ForwardServiceImpl;
import org.onosproject.vtn.table.impl.SnatServiceImpl;
import org.onosproject.vtn.util.DataPathIdGenerator;
import org.onosproject.vtn.util.VtnConfig;
import org.onosproject.vtn.util.VtnData;
import org.onosproject.vtnrsc.AllowedAddressPair;
import org.onosproject.vtnrsc.BindingHostId;
import org.onosproject.vtnrsc.DefaultVirtualPort;
import org.onosproject.vtnrsc.FixedIp;
import org.onosproject.vtnrsc.FloatingIp;
import org.onosproject.vtnrsc.RouterInterface;
import org.onosproject.vtnrsc.SecurityGroup;
import org.onosproject.vtnrsc.SegmentationId;
import org.onosproject.vtnrsc.SubnetId;
import org.onosproject.vtnrsc.TenantId;
import org.onosproject.vtnrsc.TenantNetwork;
import org.onosproject.vtnrsc.TenantNetworkId;
import org.onosproject.vtnrsc.VirtualPort;
import org.onosproject.vtnrsc.VirtualPortId;
import org.onosproject.vtnrsc.event.VtnRscEvent;
import org.onosproject.vtnrsc.event.VtnRscEventFeedback;
import org.onosproject.vtnrsc.event.VtnRscListener;
import org.onosproject.vtnrsc.floatingip.FloatingIpService;
import org.onosproject.vtnrsc.routerinterface.RouterInterfaceService;
import org.onosproject.vtnrsc.service.VtnRscService;
import org.onosproject.vtnrsc.subnet.SubnetService;
import org.onosproject.vtnrsc.tenantnetwork.TenantNetworkService;
import org.onosproject.vtnrsc.virtualport.VirtualPortService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class VTNManager
implements VTNService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String APP_ID = "org.onosproject.app.vtn";
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected NetworkConfigService configService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DeviceService deviceService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected HostService hostService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected TenantNetworkService tenantNetworkService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected VirtualPortService virtualPortService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected DriverService driverService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected LogicalClockService clockService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected MastershipService mastershipService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected GroupService groupService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected SubnetService subnetService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected VtnRscService vtnRscService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected FloatingIpService floatingIpService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected RouterInterfaceService routerInterfaceService;
    private ApplicationId appId;
    private ClassifierService classifierService;
    private L2ForwardService l2ForwardService;
    private ArpService arpService;
    private L3ForwardService l3ForwardService;
    private SnatService snatService;
    private DnatService dnatService;
    private final HostListener hostListener = new InnerHostListener();
    private final DeviceListener deviceListener = new InnerDeviceListener();
    private final VtnRscListener l3EventListener = new VtnL3EventListener();
    private static String exPortName = "eth0";
    private static final String IFACEID = "ifaceid";
    private static final String CONTROLLER_IP_KEY = "ipaddress";
    public static final String DRIVER_NAME = "onosfw";
    private static final String VIRTUALPORT = "vtn-virtual-port";
    private static final String SWITCHES_OF_CONTROLLER = "switchesOfController";
    private static final String SWITCH_OF_LOCAL_HOST_PORTS = "switchOfLocalHostPorts";
    private static final String ROUTERINF_FLAG_OF_TENANT = "routerInfFlagOfTenant";
    private static final String HOSTS_OF_SUBNET = "hostsOfSubnet";
    private static final String EX_PORT_OF_DEVICE = "exPortOfDevice";
    private static final String DEFAULT_IP = "0.0.0.0";
    private static final int SUBNET_NUM = 2;
    private EventuallyConsistentMap<VirtualPortId, VirtualPort> vPortStore;
    private EventuallyConsistentMap<IpAddress, Boolean> switchesOfController;
    private EventuallyConsistentMap<DeviceId, NetworkOfLocalHostPorts> switchOfLocalHostPorts;
    private EventuallyConsistentMap<SubnetId, Map<HostId, Host>> hostsOfSubnet;
    private EventuallyConsistentMap<TenantId, Boolean> routerInfFlagOfTenant;
    private EventuallyConsistentMap<DeviceId, Port> exPortOfDevice;

    @Activate
    public void activate() {
        this.appId = this.coreService.registerApplication(APP_ID);
        this.classifierService = new ClassifierServiceImpl(this.appId);
        this.l2ForwardService = new L2ForwardServiceImpl(this.appId);
        this.arpService = new ArpServiceImpl(this.appId);
        this.l3ForwardService = new L3ForwardServiceImpl(this.appId);
        this.snatService = new SnatServiceImpl(this.appId);
        this.dnatService = new DnatServiceImpl(this.appId);
        this.deviceService.addListener((EventListener)this.deviceListener);
        this.hostService.addListener((EventListener)this.hostListener);
        this.vtnRscService.addListener((EventListener)this.l3EventListener);
        KryoNamespace.Builder serializer = KryoNamespace.newBuilder().register(KryoNamespaces.API).register(new Class[]{NetworkOfLocalHostPorts.class}).register(new Class[]{TenantNetworkId.class}).register(new Class[]{Host.class}).register(new Class[]{TenantNetwork.class}).register(new Class[]{TenantId.class}).register(new Class[]{SubnetId.class}).register(new Class[]{VirtualPortId.class}).register(new Class[]{VirtualPort.State.class}).register(new Class[]{AllowedAddressPair.class}).register(new Class[]{FixedIp.class}).register(new Class[]{BindingHostId.class}).register(new Class[]{SecurityGroup.class}).register(new Class[]{IpAddress.class}).register(new Class[]{DefaultVirtualPort.class});
        this.vPortStore = this.storageService.eventuallyConsistentMapBuilder().withName(VIRTUALPORT).withSerializer(serializer).withTimestampProvider((k, v) -> this.clockService.getTimestamp()).build();
        this.switchesOfController = this.storageService.eventuallyConsistentMapBuilder().withName(SWITCHES_OF_CONTROLLER).withSerializer(serializer).withTimestampProvider((k, v) -> this.clockService.getTimestamp()).build();
        this.switchOfLocalHostPorts = this.storageService.eventuallyConsistentMapBuilder().withName(SWITCH_OF_LOCAL_HOST_PORTS).withSerializer(serializer).withTimestampProvider((k, v) -> this.clockService.getTimestamp()).build();
        this.hostsOfSubnet = this.storageService.eventuallyConsistentMapBuilder().withName(HOSTS_OF_SUBNET).withSerializer(serializer).withTimestampProvider((k, v) -> this.clockService.getTimestamp()).build();
        this.routerInfFlagOfTenant = this.storageService.eventuallyConsistentMapBuilder().withName(ROUTERINF_FLAG_OF_TENANT).withSerializer(serializer).withTimestampProvider((k, v) -> this.clockService.getTimestamp()).build();
        this.exPortOfDevice = this.storageService.eventuallyConsistentMapBuilder().withName(EX_PORT_OF_DEVICE).withSerializer(serializer).withTimestampProvider((k, v) -> this.clockService.getTimestamp()).build();
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.deviceService.removeListener((EventListener)this.deviceListener);
        this.hostService.removeListener((EventListener)this.hostListener);
        this.vtnRscService.removeListener((EventListener)this.l3EventListener);
        this.log.info("Stopped");
    }

    @Override
    public void onControllerDetected(Device controllerDevice) {
        if (controllerDevice == null) {
            this.log.error("The controller device is null");
            return;
        }
        String localIpAddress = controllerDevice.annotations().value(CONTROLLER_IP_KEY);
        IpAddress localIp = IpAddress.valueOf((String)localIpAddress);
        DeviceId controllerDeviceId = controllerDevice.id();
        DriverHandler handler = this.driverService.createHandler(controllerDeviceId, new String[0]);
        if (this.mastershipService.isLocalMaster(controllerDeviceId)) {
            String ipaddress = controllerDevice.annotations().value(CONTROLLER_IP_KEY);
            DataPathIdGenerator dpidGenerator = DataPathIdGenerator.builder().addIpAddress(ipaddress).build();
            DeviceId deviceId = dpidGenerator.getDeviceId();
            String dpid = dpidGenerator.getDpId();
            BasicDeviceConfig config = (BasicDeviceConfig)this.configService.addConfig((Object)deviceId, BasicDeviceConfig.class);
            config.driver(DRIVER_NAME);
            this.configService.applyConfig((Object)deviceId, BasicDeviceConfig.class, config.node());
            VtnConfig.applyBridgeConfig(handler, dpid, exPortName);
            this.log.info("A new ovs is created in node {}", (Object)localIp.toString());
            this.switchesOfController.put((Object)localIp, (Object)true);
        }
        this.programTunnelConfig(controllerDeviceId, localIp, handler);
    }

    @Override
    public void onControllerVanished(Device controllerDevice) {
        if (controllerDevice == null) {
            this.log.error("The device is null");
            return;
        }
        String dstIp = controllerDevice.annotations().value(CONTROLLER_IP_KEY);
        IpAddress dstIpAddress = IpAddress.valueOf((String)dstIp);
        DeviceId controllerDeviceId = controllerDevice.id();
        if (this.mastershipService.isLocalMaster(controllerDeviceId)) {
            this.switchesOfController.remove((Object)dstIpAddress);
        }
        this.programTunnelConfig(controllerDeviceId, dstIpAddress, null);
    }

    @Override
    public void onOvsDetected(Device device) {
        this.applyTunnelOut(device, Objective.Operation.ADD);
    }

    @Override
    public void onOvsVanished(Device device) {
        this.applyTunnelOut(device, Objective.Operation.REMOVE);
    }

    @Override
    public void onHostDetected(Host host) {
        DeviceId deviceId = host.location().deviceId();
        if (!this.mastershipService.isLocalMaster(deviceId)) {
            return;
        }
        String ifaceId = host.annotations().value(IFACEID);
        if (ifaceId == null) {
            this.log.error("The ifaceId of Host is null");
            return;
        }
        this.applyHostMonitoredL2Rules(host, Objective.Operation.ADD);
        this.applyHostMonitoredL3Rules(host, Objective.Operation.ADD);
    }

    @Override
    public void onHostVanished(Host host) {
        DeviceId deviceId = host.location().deviceId();
        if (!this.mastershipService.isLocalMaster(deviceId)) {
            return;
        }
        String ifaceId = host.annotations().value(IFACEID);
        if (ifaceId == null) {
            this.log.error("The ifaceId of Host is null");
            return;
        }
        this.applyHostMonitoredL2Rules(host, Objective.Operation.REMOVE);
        this.applyHostMonitoredL3Rules(host, Objective.Operation.REMOVE);
        VirtualPortId virtualPortId = VirtualPortId.portId((String)ifaceId);
        this.vPortStore.remove((Object)virtualPortId);
    }

    private void programTunnelConfig(DeviceId localDeviceId, IpAddress localIp, DriverHandler localHandler) {
        if (this.mastershipService.isLocalMaster(localDeviceId)) {
            VtnConfig.applyTunnelConfig(localHandler, localIp, IpAddress.valueOf((String)DEFAULT_IP));
            this.log.info("Add tunnel on {}", (Object)localIp);
        }
    }

    private void applyTunnelOut(Device device, Objective.Operation type) {
        if (device == null) {
            this.log.error("The device is null");
            return;
        }
        if (!this.mastershipService.isLocalMaster(device.id())) {
            return;
        }
        String controllerIp = VtnData.getControllerIpOfSwitch(device);
        if (controllerIp == null) {
            this.log.error("Can't find controller of device: {}", (Object)device.id().toString());
            return;
        }
        IpAddress ipAddress = IpAddress.valueOf((String)controllerIp);
        if (!this.switchesOfController.containsKey((Object)ipAddress)) {
            this.log.error("Can't find controller of device: {}", (Object)device.id().toString());
            return;
        }
        if (type == Objective.Operation.ADD) {
            Port export = this.getExPort(device.id());
            if (export != null) {
                this.exPortOfDevice.put((Object)device.id(), (Object)export);
            }
            this.switchOfLocalHostPorts.put((Object)device.id(), (Object)new NetworkOfLocalHostPorts());
        } else if (type == Objective.Operation.REMOVE) {
            this.exPortOfDevice.remove((Object)device.id());
            this.switchOfLocalHostPorts.remove((Object)device.id());
        }
        Iterable devices = this.deviceService.getAvailableDevices();
        DeviceId localControllerId = VtnData.getControllerId(device, devices);
        DriverHandler handler = this.driverService.createHandler(localControllerId, new String[0]);
        Set<PortNumber> ports = VtnConfig.getPortNumbers(handler);
        Iterable allHosts = this.hostService.getHosts();
        String tunnelName = "vxlan-0.0.0.0";
        if (allHosts != null) {
            Sets.newHashSet((Iterable)allHosts).stream().forEach(host -> {
                MacAddress hostMac = host.mac();
                String ifaceId = host.annotations().value(IFACEID);
                if (ifaceId == null) {
                    this.log.error("The ifaceId of Host is null");
                    return;
                }
                VirtualPortId virtualPortId = VirtualPortId.portId((String)ifaceId);
                VirtualPort virtualPort = this.virtualPortService.getPort(virtualPortId);
                TenantNetwork network = this.tenantNetworkService.getNetwork(virtualPort.networkId());
                SegmentationId segmentationId = network.segmentationId();
                DeviceId remoteDeviceId = host.location().deviceId();
                Device remoteDevice = this.deviceService.getDevice(remoteDeviceId);
                String remoteControllerIp = VtnData.getControllerIpOfSwitch(remoteDevice);
                if (remoteControllerIp == null) {
                    this.log.error("Can't find remote controller of device: {}", (Object)remoteDeviceId.toString());
                    return;
                }
                IpAddress remoteIpAddress = IpAddress.valueOf((String)remoteControllerIp);
                ports.stream().filter(p -> p.name().equalsIgnoreCase(tunnelName)).forEach(p -> this.l2ForwardService.programTunnelOut(device.id(), segmentationId, (PortNumber)p, hostMac, type, remoteIpAddress));
            });
        }
    }

    private void applyHostMonitoredL2Rules(Host host, Objective.Operation type) {
        DeviceId deviceId = host.location().deviceId();
        if (!this.mastershipService.isLocalMaster(deviceId)) {
            return;
        }
        String ifaceId = host.annotations().value(IFACEID);
        if (ifaceId == null) {
            this.log.error("The ifaceId of Host is null");
            return;
        }
        VirtualPortId virtualPortId = VirtualPortId.portId((String)ifaceId);
        VirtualPort virtualPort = this.virtualPortService.getPort(virtualPortId);
        if (virtualPort == null) {
            virtualPort = VtnData.getPort(this.vPortStore, virtualPortId);
        }
        Iterator fixip = virtualPort.fixedIps().iterator();
        SubnetId subnetId = null;
        if (fixip.hasNext()) {
            subnetId = ((FixedIp)fixip.next()).subnetId();
        }
        if (subnetId != null) {
            Map hosts = new ConcurrentHashMap<HostId, Host>();
            if (this.hostsOfSubnet.get((Object)subnetId) != null) {
                hosts = (Map)this.hostsOfSubnet.get((Object)subnetId);
            }
            if (type == Objective.Operation.ADD) {
                hosts.put(host.id(), host);
                this.hostsOfSubnet.put((Object)subnetId, hosts);
            } else if (type == Objective.Operation.REMOVE) {
                hosts.remove(host.id());
                if (hosts.size() != 0) {
                    this.hostsOfSubnet.put((Object)subnetId, hosts);
                } else {
                    this.hostsOfSubnet.remove((Object)subnetId);
                }
            }
        }
        Iterable devices = this.deviceService.getAvailableDevices();
        PortNumber inPort = host.location().port();
        MacAddress mac = host.mac();
        Device device = this.deviceService.getDevice(deviceId);
        String controllerIp = VtnData.getControllerIpOfSwitch(device);
        IpAddress ipAddress = IpAddress.valueOf((String)controllerIp);
        TenantNetwork network = this.tenantNetworkService.getNetwork(virtualPort.networkId());
        if (network == null) {
            this.log.error("Can't find network of the host");
            return;
        }
        SegmentationId segmentationId = network.segmentationId();
        List ports = this.deviceService.getPorts(deviceId);
        Collection<PortNumber> localTunnelPorts = VtnData.getLocalTunnelPorts(ports);
        Map<TenantNetworkId, Set<PortNumber>> localHostPorts = ((NetworkOfLocalHostPorts)this.switchOfLocalHostPorts.get((Object)deviceId)).getNetworkOfLocalHostPorts();
        Set<PortNumber> networkOflocalHostPorts = localHostPorts.get(network.id());
        for (PortNumber p : localTunnelPorts) {
            this.programGroupTable(deviceId, this.appId, p, devices, type);
        }
        if (type == Objective.Operation.ADD) {
            this.vPortStore.put((Object)virtualPortId, (Object)virtualPort);
            if (networkOflocalHostPorts == null) {
                networkOflocalHostPorts = new HashSet<PortNumber>();
                localHostPorts.putIfAbsent(network.id(), networkOflocalHostPorts);
            }
            networkOflocalHostPorts.add(inPort);
            this.l2ForwardService.programLocalBcastRules(deviceId, segmentationId, inPort, networkOflocalHostPorts, localTunnelPorts, type);
            this.classifierService.programTunnelIn(deviceId, segmentationId, localTunnelPorts, type);
        } else if (type == Objective.Operation.REMOVE && networkOflocalHostPorts != null) {
            this.l2ForwardService.programLocalBcastRules(deviceId, segmentationId, inPort, networkOflocalHostPorts, localTunnelPorts, type);
            networkOflocalHostPorts.remove(inPort);
            if (networkOflocalHostPorts.isEmpty()) {
                this.classifierService.programTunnelIn(deviceId, segmentationId, localTunnelPorts, type);
                ((NetworkOfLocalHostPorts)this.switchOfLocalHostPorts.get((Object)deviceId)).getNetworkOfLocalHostPorts().remove(virtualPort.networkId());
            }
        }
        this.l2ForwardService.programLocalOut(deviceId, segmentationId, inPort, mac, type);
        this.l2ForwardService.programTunnelBcastRules(deviceId, segmentationId, networkOflocalHostPorts, localTunnelPorts, type);
        this.programTunnelOuts(devices, ipAddress, segmentationId, mac, type);
        this.classifierService.programLocalIn(deviceId, segmentationId, inPort, mac, this.appId, type);
    }

    private void programTunnelOuts(Iterable<Device> devices, IpAddress ipAddress, SegmentationId segmentationId, MacAddress dstMac, Objective.Operation type) {
        String tunnelName = "vxlan-0.0.0.0";
        Sets.newHashSet(devices).stream().filter(d -> d.type() == Device.Type.CONTROLLER).filter(d -> !("ovsdb:" + ipAddress).equals(d.id().toString())).forEach(d -> {
            DriverHandler handler = this.driverService.createHandler(d.id(), new String[0]);
            BridgeConfig bridgeConfig = (BridgeConfig)handler.behaviour(BridgeConfig.class);
            Collection bridgeDescriptions = bridgeConfig.getBridges();
            for (BridgeDescription sw : bridgeDescriptions) {
                if (!sw.bridgeName().name().equals("br-int")) continue;
                List ports = this.deviceService.getPorts(sw.deviceId());
                ports.stream().filter(p -> p.annotations().value("portName").equalsIgnoreCase(tunnelName)).forEach(p -> this.l2ForwardService.programTunnelOut(sw.deviceId(), segmentationId, p.number(), dstMac, type, ipAddress));
                break;
            }
        });
    }

    private void programGroupTable(DeviceId deviceId, ApplicationId appid, PortNumber portNumber, Iterable<Device> devices, Objective.Operation type) {
        if (type.equals((Object)Objective.Operation.REMOVE)) {
            return;
        }
        ArrayList buckets = Lists.newArrayList();
        Sets.newHashSet(devices).stream().filter(d -> d.type() == Device.Type.CONTROLLER).filter(d -> !deviceId.equals((Object)d.id())).forEach(d -> {
            String ipAddress = d.annotations().value(CONTROLLER_IP_KEY);
            Ip4Address dst = Ip4Address.valueOf((String)ipAddress);
            TrafficTreatment.Builder builder = DefaultTrafficTreatment.builder();
            DriverHandler handler = this.driverService.createHandler(deviceId, new String[0]);
            ExtensionTreatmentResolver resolver = (ExtensionTreatmentResolver)handler.behaviour(ExtensionTreatmentResolver.class);
            ExtensionTreatment treatment = resolver.getExtensionInstruction(ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_SET_TUNNEL_DST.type());
            try {
                treatment.setPropertyValue("tunnelDst", (Object)dst);
            }
            catch (Exception e) {
                this.log.error("Failed to get extension instruction to set tunnel dst {}", (Object)deviceId);
            }
            builder.extension(treatment, deviceId);
            builder.setOutput(portNumber);
            GroupBucket bucket = DefaultGroupBucket.createAllGroupBucket((TrafficTreatment)builder.build());
            buckets.add(bucket);
        });
        DefaultGroupKey key = new DefaultGroupKey(APP_ID.getBytes());
        DefaultGroupDescription groupDescription = new DefaultGroupDescription(deviceId, GroupDescription.Type.ALL, new GroupBuckets((List)buckets), (GroupKey)key, L2ForwardServiceImpl.GROUP_ID, appid);
        this.groupService.addGroup((GroupDescription)groupDescription);
    }

    @Override
    public void onRouterInterfaceDetected(VtnRscEventFeedback l3Feedback) {
        Objective.Operation operation = Objective.Operation.ADD;
        RouterInterface routerInf = l3Feedback.routerInterface();
        Collection interfaces = this.routerInterfaceService.getRouterInterfaces();
        Set<RouterInterface> interfacesSet = Sets.newHashSet((Iterable)interfaces).stream().filter(r -> r.tenantId().equals((Object)routerInf.tenantId())).collect(Collectors.toSet());
        if (this.routerInfFlagOfTenant.get((Object)routerInf.tenantId()) != null) {
            this.programRouterInterface(routerInf, operation);
        } else if (interfacesSet.size() >= 2) {
            this.programInterfacesSet(interfacesSet, operation);
        }
    }

    @Override
    public void onRouterInterfaceVanished(VtnRscEventFeedback l3Feedback) {
        Objective.Operation operation = Objective.Operation.REMOVE;
        RouterInterface routerInf = l3Feedback.routerInterface();
        Collection interfaces = this.routerInterfaceService.getRouterInterfaces();
        Set interfacesSet = Sets.newHashSet((Iterable)interfaces).stream().filter(r -> r.tenantId().equals((Object)routerInf.tenantId())).collect(Collectors.toSet());
        if (this.routerInfFlagOfTenant.get((Object)routerInf.tenantId()) != null) {
            this.programRouterInterface(routerInf, operation);
            if (interfacesSet.size() == 1) {
                this.routerInfFlagOfTenant.remove((Object)routerInf.tenantId());
                interfacesSet.stream().forEach(r -> this.programRouterInterface((RouterInterface)r, operation));
            }
        }
    }

    @Override
    public void onFloatingIpDetected(VtnRscEventFeedback l3Feedback) {
        this.programFloatingIpEvent(l3Feedback, VtnRscEvent.Type.FLOATINGIP_PUT);
    }

    @Override
    public void onFloatingIpVanished(VtnRscEventFeedback l3Feedback) {
        this.programFloatingIpEvent(l3Feedback, VtnRscEvent.Type.FLOATINGIP_DELETE);
    }

    private void programInterfacesSet(Set<RouterInterface> interfacesSet, Objective.Operation operation) {
        int subnetVmNum = 0;
        for (RouterInterface r : interfacesSet) {
            Map hosts = (Map)this.hostsOfSubnet.get((Object)r.subnetId());
            if (hosts == null || hosts.size() <= 0 || ++subnetVmNum < 2) continue;
            this.routerInfFlagOfTenant.put((Object)r.tenantId(), (Object)true);
            interfacesSet.stream().forEach(f -> this.programRouterInterface((RouterInterface)f, operation));
            break;
        }
    }

    private void programRouterInterface(RouterInterface routerInf, Objective.Operation operation) {
        SegmentationId l3vni = this.vtnRscService.getL3vni(routerInf.tenantId());
        Map hosts = (Map)this.hostsOfSubnet.get((Object)routerInf.subnetId());
        hosts.values().stream().forEach(h -> this.applyEastWestL3Flows((Host)h, l3vni, operation));
    }

    private void applyEastWestL3Flows(Host h, SegmentationId l3vni, Objective.Operation operation) {
        if (!this.mastershipService.isLocalMaster(h.location().deviceId())) {
            this.log.debug("not master device:{}", (Object)h.location().deviceId());
            return;
        }
        String ifaceId = h.annotations().value(IFACEID);
        VirtualPort hPort = this.virtualPortService.getPort(VirtualPortId.portId((String)ifaceId));
        if (hPort == null) {
            hPort = VtnData.getPort(this.vPortStore, VirtualPortId.portId((String)ifaceId));
        }
        IpAddress srcIp = null;
        IpAddress srcGwIp = null;
        MacAddress srcVmGwMac = null;
        SubnetId srcSubnetId = null;
        Iterator srcIps = hPort.fixedIps().iterator();
        if (srcIps.hasNext()) {
            FixedIp fixedIp = (FixedIp)srcIps.next();
            srcIp = fixedIp.ip();
            srcSubnetId = fixedIp.subnetId();
            FixedIp fixedGwIp = FixedIp.fixedIp((SubnetId)srcSubnetId, (IpAddress)(srcGwIp = this.subnetService.getSubnet(srcSubnetId).gatewayIp()));
            VirtualPort gwPort = this.virtualPortService.getPort(fixedGwIp);
            if (gwPort == null) {
                gwPort = VtnData.getPort(this.vPortStore, fixedGwIp);
            }
            srcVmGwMac = gwPort.macAddress();
        }
        TenantNetwork network = this.tenantNetworkService.getNetwork(hPort.networkId());
        this.classifierService.programL3InPortClassifierRules(h.location().deviceId(), h.location().port(), h.mac(), srcVmGwMac, l3vni, operation);
        if (operation == Objective.Operation.ADD) {
            this.classifierService.programArpClassifierRules(h.location().deviceId(), srcGwIp, network.segmentationId(), operation);
            DriverHandler handler = this.driverService.createHandler(h.location().deviceId(), new String[0]);
            this.arpService.programArpRules(handler, h.location().deviceId(), srcGwIp, network.segmentationId(), srcVmGwMac, operation);
        }
        Iterable devices = this.deviceService.getAvailableDevices();
        IpAddress srcArpIp = srcIp;
        MacAddress srcArpGwMac = srcVmGwMac;
        Sets.newHashSet((Iterable)devices).stream().filter(d -> Device.Type.SWITCH == d.type()).forEach(d -> this.l3ForwardService.programRouteRules(d.id(), l3vni, srcArpIp, network.segmentationId(), srcArpGwMac, h.mac(), operation));
    }

    private void programFloatingIpEvent(VtnRscEventFeedback l3Feedback, VtnRscEvent.Type type) {
        FloatingIp floaingIp = l3Feedback.floatingIp();
        if (floaingIp != null) {
            VirtualPortId vmPortId = floaingIp.portId();
            VirtualPort vmPort = this.virtualPortService.getPort(vmPortId);
            VirtualPort fipPort = this.virtualPortService.getPort(floaingIp.networkId(), floaingIp.floatingIp());
            if (vmPort == null) {
                vmPort = VtnData.getPort(this.vPortStore, vmPortId);
            }
            if (fipPort == null) {
                fipPort = VtnData.getPort(this.vPortStore, floaingIp.networkId(), floaingIp.floatingIp());
            }
            Set hostSet = this.hostService.getHostsByMac(vmPort.macAddress());
            Host host = null;
            for (Host h : hostSet) {
                String ifaceid = h.annotations().value(IFACEID);
                if (ifaceid == null || !ifaceid.equals(vmPortId.portId())) continue;
                host = h;
                break;
            }
            if (host != null && vmPort != null && fipPort != null) {
                DeviceId deviceId = host.location().deviceId();
                Port exPort = (Port)this.exPortOfDevice.get((Object)deviceId);
                SegmentationId l3vni = this.vtnRscService.getL3vni(vmPort.tenantId());
                if (type == VtnRscEvent.Type.FLOATINGIP_PUT) {
                    this.applyNorthSouthL3Flows(deviceId, host, vmPort, fipPort, floaingIp, l3vni, exPort, Objective.Operation.ADD);
                } else if (type == VtnRscEvent.Type.FLOATINGIP_DELETE) {
                    this.applyNorthSouthL3Flows(deviceId, host, vmPort, fipPort, floaingIp, l3vni, exPort, Objective.Operation.REMOVE);
                }
            }
        }
    }

    private void applyNorthSouthL3Flows(DeviceId deviceId, Host host, VirtualPort vmPort, VirtualPort fipPort, FloatingIp floatingIp, SegmentationId l3Vni, Port exPort, Objective.Operation operation) {
        if (!this.mastershipService.isLocalMaster(deviceId)) {
            this.log.debug("not master device:{}", (Object)deviceId);
            return;
        }
        List gwIpMac = this.getGwIpAndMac(vmPort);
        IpAddress dstVmGwIp = (IpAddress)gwIpMac.get(0);
        MacAddress dstVmGwMac = (MacAddress)gwIpMac.get(1);
        List fGwIpMac = this.getGwIpAndMac(fipPort);
        MacAddress fGwMac = (MacAddress)fGwIpMac.get(1);
        TenantNetwork vmNetwork = this.tenantNetworkService.getNetwork(vmPort.networkId());
        TenantNetwork fipNetwork = this.tenantNetworkService.getNetwork(fipPort.networkId());
        MacAddress exPortMac = MacAddress.valueOf((String)exPort.annotations().value("portMac"));
        this.classifierService.programArpClassifierRules(deviceId, floatingIp.floatingIp(), fipNetwork.segmentationId(), operation);
        this.classifierService.programL3ExPortClassifierRules(deviceId, exPort.number(), floatingIp.floatingIp(), operation);
        DriverHandler handler = this.driverService.createHandler(deviceId, new String[0]);
        this.arpService.programArpRules(handler, deviceId, floatingIp.floatingIp(), fipNetwork.segmentationId(), exPortMac, operation);
        this.dnatService.programRules(deviceId, floatingIp.floatingIp(), fGwMac, floatingIp.fixedIp(), l3Vni, operation);
        this.l3ForwardService.programRouteRules(deviceId, l3Vni, floatingIp.fixedIp(), vmNetwork.segmentationId(), dstVmGwMac, vmPort.macAddress(), operation);
        this.classifierService.programL3InPortClassifierRules(deviceId, host.location().port(), host.mac(), dstVmGwMac, l3Vni, operation);
        this.snatService.programRules(deviceId, l3Vni, floatingIp.fixedIp(), fGwMac, exPortMac, floatingIp.floatingIp(), fipNetwork.segmentationId(), operation);
        if (operation == Objective.Operation.ADD) {
            this.classifierService.programArpClassifierRules(deviceId, dstVmGwIp, vmNetwork.segmentationId(), operation);
            this.arpService.programArpRules(handler, deviceId, dstVmGwIp, vmNetwork.segmentationId(), dstVmGwMac, operation);
            this.l2ForwardService.programLocalOut(deviceId, fipNetwork.segmentationId(), exPort.number(), fGwMac, operation);
        }
    }

    private Port getExPort(DeviceId deviceId) {
        List ports = this.deviceService.getPorts(deviceId);
        Port exPort = null;
        for (Port port : ports) {
            String portName = port.annotations().value("portName");
            if (portName == null || !portName.equals(exPortName)) continue;
            exPort = port;
            break;
        }
        return exPort;
    }

    private List getGwIpAndMac(VirtualPort port) {
        ArrayList<Object> list = new ArrayList<Object>();
        MacAddress gwMac = null;
        SubnetId subnetId = null;
        IpAddress gwIp = null;
        Iterator fixips = port.fixedIps().iterator();
        if (fixips.hasNext()) {
            FixedIp fixip = (FixedIp)fixips.next();
            subnetId = fixip.subnetId();
            gwIp = this.subnetService.getSubnet(subnetId).gatewayIp();
            FixedIp fixedGwIp = FixedIp.fixedIp((SubnetId)fixip.subnetId(), (IpAddress)gwIp);
            VirtualPort gwPort = this.virtualPortService.getPort(fixedGwIp);
            if (gwPort == null) {
                gwPort = VtnData.getPort(this.vPortStore, fixedGwIp);
            }
            gwMac = gwPort.macAddress();
        }
        list.add(gwIp);
        list.add(gwMac);
        return list;
    }

    private void applyHostMonitoredL3Rules(Host host, Objective.Operation operation) {
        String ifaceId = host.annotations().value(IFACEID);
        DeviceId deviceId = host.location().deviceId();
        VirtualPortId portId = VirtualPortId.portId((String)ifaceId);
        VirtualPort port = this.virtualPortService.getPort(portId);
        if (port == null) {
            port = VtnData.getPort(this.vPortStore, portId);
        }
        TenantId tenantId = port.tenantId();
        Port exPort = (Port)this.exPortOfDevice.get((Object)deviceId);
        SegmentationId l3vni = this.vtnRscService.getL3vni(tenantId);
        Iterator fixips = port.fixedIps().iterator();
        SubnetId sid = null;
        IpAddress hostIp = null;
        if (fixips.hasNext()) {
            FixedIp fixip = (FixedIp)fixips.next();
            sid = fixip.subnetId();
            hostIp = fixip.ip();
        }
        SubnetId subnetId = sid;
        Collection interfaces = this.routerInterfaceService.getRouterInterfaces();
        Set<RouterInterface> interfacesSet = Sets.newHashSet((Iterable)interfaces).stream().filter(r -> r.tenantId().equals((Object)tenantId)).collect(Collectors.toSet());
        long count = interfacesSet.stream().filter(r -> !r.subnetId().equals((Object)subnetId)).count();
        if (count > 0L) {
            if (operation == Objective.Operation.ADD) {
                if (this.routerInfFlagOfTenant.get((Object)tenantId) != null) {
                    this.applyEastWestL3Flows(host, l3vni, operation);
                } else if (interfacesSet.size() > 1) {
                    this.programInterfacesSet(interfacesSet, operation);
                }
            } else if (operation == Objective.Operation.REMOVE && this.routerInfFlagOfTenant.get((Object)tenantId) != null) {
                this.applyEastWestL3Flows(host, l3vni, operation);
            }
        }
        FloatingIp floatingIp = null;
        Collection floatingIps = this.floatingIpService.getFloatingIps();
        Set floatingIpSet = Sets.newHashSet((Iterable)floatingIps).stream().filter(f -> f.tenantId().equals((Object)tenantId)).collect(Collectors.toSet());
        for (FloatingIp f2 : floatingIpSet) {
            IpAddress fixedIp = f2.fixedIp();
            if (!fixedIp.equals((Object)hostIp)) continue;
            floatingIp = f2;
            break;
        }
        if (floatingIp != null) {
            VirtualPort fipPort = this.virtualPortService.getPort(floatingIp.networkId(), floatingIp.floatingIp());
            if (fipPort == null) {
                fipPort = VtnData.getPort(this.vPortStore, floatingIp.networkId(), floatingIp.floatingIp());
            }
            this.applyNorthSouthL3Flows(deviceId, host, port, fipPort, floatingIp, l3vni, exPort, operation);
        }
    }

    public static void setExPortName(String name) {
        exPortName = name;
    }

    protected void bindConfigService(NetworkConfigService networkConfigService) {
        this.configService = networkConfigService;
    }

    protected void unbindConfigService(NetworkConfigService networkConfigService) {
        if (this.configService == networkConfigService) {
            this.configService = null;
        }
    }

    protected void bindDeviceService(DeviceService deviceService) {
        this.deviceService = deviceService;
    }

    protected void unbindDeviceService(DeviceService deviceService) {
        if (this.deviceService == deviceService) {
            this.deviceService = null;
        }
    }

    protected void bindHostService(HostService hostService) {
        this.hostService = hostService;
    }

    protected void unbindHostService(HostService hostService) {
        if (this.hostService == hostService) {
            this.hostService = null;
        }
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }

    protected void bindTenantNetworkService(TenantNetworkService tenantNetworkService) {
        this.tenantNetworkService = tenantNetworkService;
    }

    protected void unbindTenantNetworkService(TenantNetworkService tenantNetworkService) {
        if (this.tenantNetworkService == tenantNetworkService) {
            this.tenantNetworkService = null;
        }
    }

    protected void bindVirtualPortService(VirtualPortService virtualPortService) {
        this.virtualPortService = virtualPortService;
    }

    protected void unbindVirtualPortService(VirtualPortService virtualPortService) {
        if (this.virtualPortService == virtualPortService) {
            this.virtualPortService = null;
        }
    }

    protected void bindDriverService(DriverService driverService) {
        this.driverService = driverService;
    }

    protected void unbindDriverService(DriverService driverService) {
        if (this.driverService == driverService) {
            this.driverService = null;
        }
    }

    protected void bindClockService(LogicalClockService logicalClockService) {
        this.clockService = logicalClockService;
    }

    protected void unbindClockService(LogicalClockService logicalClockService) {
        if (this.clockService == logicalClockService) {
            this.clockService = null;
        }
    }

    protected void bindMastershipService(MastershipService mastershipService) {
        this.mastershipService = mastershipService;
    }

    protected void unbindMastershipService(MastershipService mastershipService) {
        if (this.mastershipService == mastershipService) {
            this.mastershipService = null;
        }
    }

    protected void bindGroupService(GroupService groupService) {
        this.groupService = groupService;
    }

    protected void unbindGroupService(GroupService groupService) {
        if (this.groupService == groupService) {
            this.groupService = null;
        }
    }

    protected void bindSubnetService(SubnetService subnetService) {
        this.subnetService = subnetService;
    }

    protected void unbindSubnetService(SubnetService subnetService) {
        if (this.subnetService == subnetService) {
            this.subnetService = null;
        }
    }

    protected void bindVtnRscService(VtnRscService vtnRscService) {
        this.vtnRscService = vtnRscService;
    }

    protected void unbindVtnRscService(VtnRscService vtnRscService) {
        if (this.vtnRscService == vtnRscService) {
            this.vtnRscService = null;
        }
    }

    protected void bindFloatingIpService(FloatingIpService floatingIpService) {
        this.floatingIpService = floatingIpService;
    }

    protected void unbindFloatingIpService(FloatingIpService floatingIpService) {
        if (this.floatingIpService == floatingIpService) {
            this.floatingIpService = null;
        }
    }

    protected void bindRouterInterfaceService(RouterInterfaceService routerInterfaceService) {
        this.routerInterfaceService = routerInterfaceService;
    }

    protected void unbindRouterInterfaceService(RouterInterfaceService routerInterfaceService) {
        if (this.routerInterfaceService == routerInterfaceService) {
            this.routerInterfaceService = null;
        }
    }

    private class VtnL3EventListener
    implements VtnRscListener {
        private VtnL3EventListener() {
        }

        public void event(VtnRscEvent event) {
            VtnRscEventFeedback l3Feedback = (VtnRscEventFeedback)event.subject();
            if (VtnRscEvent.Type.ROUTER_INTERFACE_PUT == event.type()) {
                VTNManager.this.onRouterInterfaceDetected(l3Feedback);
            } else if (VtnRscEvent.Type.ROUTER_INTERFACE_DELETE == event.type()) {
                VTNManager.this.onRouterInterfaceVanished(l3Feedback);
            } else if (VtnRscEvent.Type.FLOATINGIP_PUT == event.type()) {
                VTNManager.this.onFloatingIpDetected(l3Feedback);
            } else if (VtnRscEvent.Type.FLOATINGIP_DELETE == event.type()) {
                VTNManager.this.onFloatingIpVanished(l3Feedback);
            }
        }
    }

    private class NetworkOfLocalHostPorts {
        private final Map<TenantNetworkId, Set<PortNumber>> networkOfLocalHostPorts = new HashMap<TenantNetworkId, Set<PortNumber>>();

        private NetworkOfLocalHostPorts() {
        }

        public Map<TenantNetworkId, Set<PortNumber>> getNetworkOfLocalHostPorts() {
            return this.networkOfLocalHostPorts;
        }
    }

    private class InnerHostListener
    implements HostListener {
        private InnerHostListener() {
        }

        public void event(HostEvent event) {
            Host host = (Host)event.subject();
            if (HostEvent.Type.HOST_ADDED == event.type()) {
                VTNManager.this.onHostDetected(host);
            } else if (HostEvent.Type.HOST_REMOVED == event.type()) {
                VTNManager.this.onHostVanished(host);
            } else if (HostEvent.Type.HOST_UPDATED == event.type()) {
                VTNManager.this.onHostVanished(host);
                VTNManager.this.onHostDetected(host);
            }
        }
    }

    private class InnerDeviceListener
    implements DeviceListener {
        private InnerDeviceListener() {
        }

        public void event(DeviceEvent event) {
            Device device = (Device)event.subject();
            if (Device.Type.CONTROLLER == device.type()) {
                if (DeviceEvent.Type.DEVICE_ADDED == event.type()) {
                    VTNManager.this.onControllerDetected(device);
                }
                if (DeviceEvent.Type.DEVICE_AVAILABILITY_CHANGED == event.type()) {
                    if (VTNManager.this.deviceService.isAvailable(device.id())) {
                        VTNManager.this.onControllerDetected(device);
                    } else {
                        VTNManager.this.onControllerVanished(device);
                    }
                }
            } else if (Device.Type.SWITCH == device.type()) {
                if (DeviceEvent.Type.DEVICE_ADDED == event.type()) {
                    VTNManager.this.onOvsDetected(device);
                }
                if (DeviceEvent.Type.DEVICE_AVAILABILITY_CHANGED == event.type()) {
                    if (VTNManager.this.deviceService.isAvailable(device.id())) {
                        VTNManager.this.onOvsDetected(device);
                    } else {
                        VTNManager.this.onOvsVanished(device);
                    }
                }
            } else {
                VTNManager.this.log.info("Do nothing for this device type");
            }
        }
    }
}

