/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtn.table.impl;

import com.google.common.base.Preconditions;
import org.onlab.osgi.DefaultServiceDirectory;
import org.onlab.packet.EthType;
import org.onlab.packet.Ip4Address;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.DeviceId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.behaviour.ExtensionTreatmentResolver;
import org.onosproject.net.driver.DriverHandler;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.instructions.ExtensionTreatment;
import org.onosproject.net.flow.instructions.ExtensionTreatmentType;
import org.onosproject.net.flowobjective.DefaultForwardingObjective;
import org.onosproject.net.flowobjective.FlowObjectiveService;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.net.flowobjective.Objective;
import org.onosproject.vtn.table.ArpService;
import org.onosproject.vtnrsc.SegmentationId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArpServiceImpl
implements ArpService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final int ARP_PRIORITY = 65535;
    private static final short ARP_RESPONSE = 2;
    private static final EthType.EtherType ARP_TYPE = EthType.EtherType.ARP;
    private final FlowObjectiveService flowObjectiveService;
    private final ApplicationId appId;

    public ArpServiceImpl(ApplicationId appId) {
        this.appId = (ApplicationId)Preconditions.checkNotNull((Object)appId, (Object)"ApplicationId can not be null");
        DefaultServiceDirectory serviceDirectory = new DefaultServiceDirectory();
        this.flowObjectiveService = (FlowObjectiveService)serviceDirectory.get(FlowObjectiveService.class);
    }

    @Override
    public void programArpRules(DriverHandler hander, DeviceId deviceId, IpAddress dstIP, SegmentationId srcVni, MacAddress dstMac, Objective.Operation type) {
        TrafficSelector selector = DefaultTrafficSelector.builder().matchEthType(ARP_TYPE.ethType().toShort()).matchArpTpa(Ip4Address.valueOf((String)dstIP.toString())).matchTunnelId(Long.parseLong(srcVni.segmentationId())).build();
        ExtensionTreatmentResolver resolver = (ExtensionTreatmentResolver)hander.behaviour(ExtensionTreatmentResolver.class);
        ExtensionTreatment ethSrcToDst = resolver.getExtensionInstruction(ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_MOV_ETH_SRC_TO_DST.type());
        ExtensionTreatment arpShaToTha = resolver.getExtensionInstruction(ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_MOV_ARP_SHA_TO_THA.type());
        ExtensionTreatment arpSpaToTpa = resolver.getExtensionInstruction(ExtensionTreatmentType.ExtensionTreatmentTypes.NICIRA_MOV_ARP_SPA_TO_TPA.type());
        TrafficTreatment treatment = DefaultTrafficTreatment.builder().extension(ethSrcToDst, deviceId).setEthSrc(dstMac).setArpOp((short)2).extension(arpShaToTha, deviceId).extension(arpSpaToTpa, deviceId).setArpSha(dstMac).setArpSpa(dstIP).setOutput(PortNumber.IN_PORT).build();
        DefaultForwardingObjective.Builder objective = DefaultForwardingObjective.builder().withTreatment(treatment).withSelector(selector).fromApp(this.appId).withFlag(ForwardingObjective.Flag.SPECIFIC).withPriority(65535);
        if (type.equals((Object)Objective.Operation.ADD)) {
            this.log.debug("PrivateArpRules-->ADD");
            this.flowObjectiveService.forward(deviceId, objective.add());
        } else {
            this.log.debug("PrivateArpRules-->REMOVE");
            this.flowObjectiveService.forward(deviceId, objective.remove());
        }
    }
}

