/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtn.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.onlab.packet.IpAddress;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.PortNumber;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.behaviour.BridgeConfig;
import org.onosproject.net.behaviour.BridgeName;
import org.onosproject.net.behaviour.DefaultTunnelDescription;
import org.onosproject.net.behaviour.IpTunnelEndPoint;
import org.onosproject.net.behaviour.TunnelConfig;
import org.onosproject.net.behaviour.TunnelDescription;
import org.onosproject.net.behaviour.TunnelEndPoint;
import org.onosproject.net.behaviour.TunnelName;
import org.onosproject.net.driver.DriverHandler;

public final class VtnConfig {
    public static final String DEFAULT_BRIDGE_NAME = "br-int";
    private static final String DEFAULT_TUNNEL = "vxlan-0.0.0.0";
    private static final Map<String, String> DEFAULT_TUNNEL_OPTIONS = new HashMap<String, String>(){
        {
            this.put("key", "flow");
            this.put("remote_ip", "flow");
        }
    };

    private VtnConfig() {
    }

    public static void applyBridgeConfig(DriverHandler handler, String dpid, String exPortName) {
        BridgeConfig bridgeConfig = (BridgeConfig)handler.behaviour(BridgeConfig.class);
        bridgeConfig.addBridge(BridgeName.bridgeName((String)DEFAULT_BRIDGE_NAME), dpid, exPortName);
    }

    public static void applyTunnelConfig(DriverHandler handler, IpAddress srcIp, IpAddress dstIp) {
        DefaultAnnotations.Builder optionBuilder = DefaultAnnotations.builder();
        for (String key : DEFAULT_TUNNEL_OPTIONS.keySet()) {
            optionBuilder.set(key, DEFAULT_TUNNEL_OPTIONS.get(key));
        }
        TunnelConfig tunnelConfig = (TunnelConfig)handler.behaviour(TunnelConfig.class);
        IpTunnelEndPoint tunnelAsSrc = IpTunnelEndPoint.ipTunnelPoint((IpAddress)srcIp);
        DefaultTunnelDescription tunnel = new DefaultTunnelDescription((TunnelEndPoint)tunnelAsSrc, null, TunnelDescription.Type.VXLAN, TunnelName.tunnelName((String)DEFAULT_TUNNEL), new SparseAnnotations[]{optionBuilder.build()});
        tunnelConfig.createTunnelInterface(BridgeName.bridgeName((String)DEFAULT_BRIDGE_NAME), (TunnelDescription)tunnel);
    }

    public static void removeTunnelConfig(DriverHandler handler, IpAddress srcIp, IpAddress dstIp) {
        TunnelConfig tunnelConfig = (TunnelConfig)handler.behaviour(TunnelConfig.class);
        IpTunnelEndPoint tunnelAsSrc = IpTunnelEndPoint.ipTunnelPoint((IpAddress)srcIp);
        IpTunnelEndPoint tunnelAsDst = IpTunnelEndPoint.ipTunnelPoint((IpAddress)dstIp);
        DefaultTunnelDescription tunnel = new DefaultTunnelDescription((TunnelEndPoint)tunnelAsSrc, (TunnelEndPoint)tunnelAsDst, TunnelDescription.Type.VXLAN, null, new SparseAnnotations[0]);
        tunnelConfig.removeTunnel((TunnelDescription)tunnel);
    }

    public static Set<PortNumber> getPortNumbers(DriverHandler handler) {
        BridgeConfig bridgeConfig = (BridgeConfig)handler.behaviour(BridgeConfig.class);
        return bridgeConfig.getPortNumbers();
    }
}

