/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtn.table.impl;

import com.google.common.base.Preconditions;
import org.onlab.osgi.DefaultServiceDirectory;
import org.onlab.packet.Ethernet;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.MacAddress;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.DeviceId;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flowobjective.DefaultForwardingObjective;
import org.onosproject.net.flowobjective.FlowObjectiveService;
import org.onosproject.net.flowobjective.ForwardingObjective;
import org.onosproject.net.flowobjective.Objective;
import org.onosproject.vtn.table.DnatService;
import org.onosproject.vtnrsc.SegmentationId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DnatServiceImpl
implements DnatService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final int DNAT_PRIORITY = 65535;
    private static final int PREFIX_LENGTH = 32;
    private final FlowObjectiveService flowObjectiveService;
    private final ApplicationId appId;

    public DnatServiceImpl(ApplicationId appId) {
        this.appId = (ApplicationId)Preconditions.checkNotNull((Object)appId, (Object)"ApplicationId can not be null");
        DefaultServiceDirectory serviceDirectory = new DefaultServiceDirectory();
        this.flowObjectiveService = (FlowObjectiveService)serviceDirectory.get(FlowObjectiveService.class);
    }

    @Override
    public void programRules(DeviceId deviceId, IpAddress dstIp, MacAddress ethSrc, IpAddress ipDst, SegmentationId actionVni, Objective.Operation type) {
        TrafficSelector selector = DefaultTrafficSelector.builder().matchEthType(Ethernet.TYPE_IPV4).matchIPDst(IpPrefix.valueOf((IpAddress)dstIp, (int)32)).build();
        TrafficTreatment.Builder treatment = DefaultTrafficTreatment.builder();
        treatment.setEthSrc(ethSrc).setIpDst(ipDst).setTunnelId(Long.parseLong(actionVni.segmentationId()));
        DefaultForwardingObjective.Builder objective = DefaultForwardingObjective.builder().withTreatment(treatment.build()).withSelector(selector).fromApp(this.appId).withFlag(ForwardingObjective.Flag.SPECIFIC).withPriority(65535);
        if (type.equals((Object)Objective.Operation.ADD)) {
            this.log.debug("RouteRules-->ADD");
            this.flowObjectiveService.forward(deviceId, objective.add());
        } else {
            this.log.debug("RouteRules-->REMOVE");
            this.flowObjectiveService.forward(deviceId, objective.remove());
        }
    }
}

