/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtn.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Calendar;
import org.onlab.util.Tools;
import org.onosproject.core.IdGenerator;
import org.onosproject.net.DeviceId;

public final class DataPathIdGenerator
implements IdGenerator {
    private static final String SCHEME = "of";
    private String ipAddress;
    private String timeStamp;

    private DataPathIdGenerator(Builder builder) {
        this.ipAddress = builder.ipAddress;
        Calendar cal = Calendar.getInstance();
        this.timeStamp = String.valueOf(cal.get(13)) + String.valueOf(cal.get(14));
    }

    public long getNewId() {
        String dpid = this.ipAddress.replace(".", "") + this.timeStamp;
        return Long.parseLong(dpid);
    }

    public String getDpId() {
        return Tools.toHex((long)this.getNewId());
    }

    public DeviceId getDeviceId() {
        try {
            URI uri = new URI(SCHEME, Tools.toHex((long)this.getNewId()), null);
            return DeviceId.deviceId((URI)uri);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String ipAddress;

        public Builder addIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public DataPathIdGenerator build() {
            return new DataPathIdGenerator(this);
        }
    }
}

