/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtn.util;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.onlab.packet.IpAddress;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.store.service.EventuallyConsistentMap;
import org.onosproject.vtnrsc.FixedIp;
import org.onosproject.vtnrsc.TenantNetworkId;
import org.onosproject.vtnrsc.VirtualPort;
import org.onosproject.vtnrsc.VirtualPortId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VtnData {
    private static final Logger log = LoggerFactory.getLogger(VtnData.class);
    private static final String SWITCH_CHANNEL_ID = "channelId";
    private static final String PORT_HEAD = "vxlan";

    private VtnData() {
    }

    public static String getControllerIpOfSwitch(Device device) {
        String url = device.annotations().value(SWITCH_CHANNEL_ID);
        return url.substring(0, url.lastIndexOf(":"));
    }

    public static DeviceId getControllerId(Device device, Iterable<Device> devices) {
        for (Device d : devices) {
            if (d.type() != Device.Type.CONTROLLER || !d.id().toString().contains(VtnData.getControllerIpOfSwitch(device))) continue;
            return d.id();
        }
        log.info("Can not find controller for device : {}", (Object)device.id());
        return null;
    }

    public static Collection<PortNumber> getLocalTunnelPorts(Iterable<Port> ports) {
        ArrayList<PortNumber> localTunnelPorts = new ArrayList<PortNumber>();
        Sets.newHashSet(ports).stream().filter(p -> !p.number().equals((Object)PortNumber.LOCAL)).forEach(p -> {
            if (p.annotations().value("portName").startsWith(PORT_HEAD)) {
                localTunnelPorts.add(p.number());
            }
        });
        return localTunnelPorts;
    }

    public static VirtualPort getPort(EventuallyConsistentMap<VirtualPortId, VirtualPort> vPortStore, VirtualPortId vPortId) {
        if (vPortStore != null) {
            return (VirtualPort)vPortStore.get((Object)vPortId);
        }
        return null;
    }

    public static VirtualPort getPort(EventuallyConsistentMap<VirtualPortId, VirtualPort> vPortStore, FixedIp fixedIP) {
        if (vPortStore != null) {
            ArrayList vPorts = new ArrayList();
            vPortStore.values().stream().forEach(p -> {
                Iterator fixedIps = p.fixedIps().iterator();
                while (fixedIps.hasNext()) {
                    if (!((FixedIp)fixedIps.next()).equals((Object)fixedIP)) continue;
                    vPorts.add(p);
                    break;
                }
            });
            if (vPorts.size() == 0) {
                return null;
            }
            return (VirtualPort)vPorts.get(0);
        }
        return null;
    }

    public static VirtualPort getPort(EventuallyConsistentMap<VirtualPortId, VirtualPort> vPortStore, TenantNetworkId networkId, IpAddress ip) {
        if (vPortStore != null) {
            ArrayList vPorts = new ArrayList();
            vPortStore.values().stream().filter(p -> p.networkId().equals((Object)networkId)).forEach(p -> {
                Iterator fixedIps = p.fixedIps().iterator();
                while (fixedIps.hasNext()) {
                    if (!((FixedIp)fixedIps.next()).ip().equals((Object)ip)) continue;
                    vPorts.add(p);
                    break;
                }
            });
            if (vPorts.size() == 0) {
                return null;
            }
            return (VirtualPort)vPorts.get(0);
        }
        return null;
    }
}

