/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtnrsc;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.onosproject.vtnrsc.FlowClassifierId;
import org.onosproject.vtnrsc.PortChain;
import org.onosproject.vtnrsc.PortChainId;
import org.onosproject.vtnrsc.PortPairGroupId;
import org.onosproject.vtnrsc.TenantId;

public final class DefaultPortChain
implements PortChain {
    private final PortChainId portChainId;
    private final TenantId tenantId;
    private final String name;
    private final String description;
    private final List<PortPairGroupId> portPairGroupList;
    private final List<FlowClassifierId> flowClassifierList;

    private DefaultPortChain(PortChainId portChainId, TenantId tenantId, String name, String description, List<PortPairGroupId> portPairGroupList, List<FlowClassifierId> flowClassifierList) {
        this.portChainId = portChainId;
        this.tenantId = tenantId;
        this.name = name;
        this.description = description;
        this.portPairGroupList = portPairGroupList;
        this.flowClassifierList = flowClassifierList;
    }

    @Override
    public PortChainId portChainId() {
        return this.portChainId;
    }

    @Override
    public TenantId tenantId() {
        return this.tenantId;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public List<PortPairGroupId> portPairGroups() {
        return ImmutableList.copyOf(this.portPairGroupList);
    }

    @Override
    public List<FlowClassifierId> flowClassifiers() {
        return ImmutableList.copyOf(this.flowClassifierList);
    }

    public int hashCode() {
        return Objects.hash(this.portChainId, this.tenantId, this.name, this.description, this.portPairGroupList, this.flowClassifierList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultPortChain) {
            DefaultPortChain that = (DefaultPortChain)obj;
            return Objects.equals(this.portChainId, that.portChainId) && Objects.equals(this.tenantId, that.tenantId) && Objects.equals(this.name, that.name) && Objects.equals(this.description, that.description) && Objects.equals(this.portPairGroupList, that.portPairGroupList) && Objects.equals(this.flowClassifierList, that.flowClassifierList);
        }
        return false;
    }

    @Override
    public boolean exactMatch(PortChain portChain) {
        return this.equals(portChain) && Objects.equals(this.portChainId, portChain.portChainId()) && Objects.equals(this.tenantId, portChain.tenantId());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.portChainId.toString()).add("tenantId", (Object)this.tenantId.toString()).add("name", (Object)this.name).add("description", (Object)this.description).add("portPairGroupList", this.portPairGroupList).add("flowClassifier", this.flowClassifierList).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements PortChain.Builder {
        private PortChainId portChainId;
        private TenantId tenantId;
        private String name;
        private String description;
        private List<PortPairGroupId> portPairGroupList;
        private List<FlowClassifierId> flowClassifierList;

        @Override
        public Builder setId(PortChainId portChainId) {
            this.portChainId = portChainId;
            return this;
        }

        @Override
        public Builder setTenantId(TenantId tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @Override
        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        @Override
        public Builder setPortPairGroups(List<PortPairGroupId> portPairGroups) {
            this.portPairGroupList = portPairGroups;
            return this;
        }

        @Override
        public Builder setFlowClassifiers(List<FlowClassifierId> flowClassifiers) {
            this.flowClassifierList = flowClassifiers;
            return this;
        }

        @Override
        public PortChain build() {
            Preconditions.checkNotNull((Object)this.portChainId, (Object)"Port chain id cannot be null");
            Preconditions.checkNotNull((Object)this.tenantId, (Object)"Tenant id cannot be null");
            Preconditions.checkNotNull(this.portPairGroupList, (Object)"Port pair groups cannot be null");
            return new DefaultPortChain(this.portChainId, this.tenantId, this.name, this.description, this.portPairGroupList, this.flowClassifierList);
        }
    }
}

