/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtnrsc;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.onosproject.vtnrsc.PortPairGroup;
import org.onosproject.vtnrsc.PortPairGroupId;
import org.onosproject.vtnrsc.PortPairId;
import org.onosproject.vtnrsc.TenantId;

public final class DefaultPortPairGroup
implements PortPairGroup {
    private final PortPairGroupId portPairGroupId;
    private final TenantId tenantId;
    private final String name;
    private final String description;
    private final List<PortPairId> portPairList;

    private DefaultPortPairGroup(PortPairGroupId portPairGroupId, TenantId tenantId, String name, String description, List<PortPairId> portPairList) {
        this.portPairGroupId = portPairGroupId;
        this.tenantId = tenantId;
        this.name = name;
        this.description = description;
        this.portPairList = portPairList;
    }

    @Override
    public PortPairGroupId portPairGroupId() {
        return this.portPairGroupId;
    }

    @Override
    public TenantId tenantId() {
        return this.tenantId;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public List<PortPairId> portPairs() {
        return ImmutableList.copyOf(this.portPairList);
    }

    public int hashCode() {
        return Objects.hash(this.portPairGroupId, this.tenantId, this.name, this.description, this.portPairList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultPortPairGroup) {
            DefaultPortPairGroup that = (DefaultPortPairGroup)obj;
            return Objects.equals(this.portPairGroupId, that.portPairGroupId) && Objects.equals(this.tenantId, that.tenantId) && Objects.equals(this.name, that.name) && Objects.equals(this.description, that.description) && Objects.equals(this.portPairList, that.portPairList);
        }
        return false;
    }

    @Override
    public boolean exactMatch(PortPairGroup portPairGroup) {
        return this.equals(portPairGroup) && Objects.equals(this.portPairGroupId, portPairGroup.portPairGroupId()) && Objects.equals(this.tenantId, portPairGroup.tenantId());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.portPairGroupId.toString()).add("tenantId", (Object)this.tenantId.toString()).add("name", (Object)this.name).add("description", (Object)this.description).add("portPairGroupList", this.portPairList).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements PortPairGroup.Builder {
        private PortPairGroupId portPairGroupId;
        private TenantId tenantId;
        private String name;
        private String description;
        private List<PortPairId> portPairList;

        @Override
        public Builder setId(PortPairGroupId portPairGroupId) {
            this.portPairGroupId = portPairGroupId;
            return this;
        }

        @Override
        public Builder setTenantId(TenantId tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @Override
        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        @Override
        public Builder setPortPairs(List<PortPairId> portPairs) {
            this.portPairList = portPairs;
            return this;
        }

        @Override
        public PortPairGroup build() {
            Preconditions.checkNotNull((Object)this.portPairGroupId, (Object)"Port pair group id cannot be null");
            Preconditions.checkNotNull((Object)this.tenantId, (Object)"Tenant id cannot be null");
            Preconditions.checkNotNull(this.portPairList, (Object)"Port pairs cannot be null");
            return new DefaultPortPairGroup(this.portPairGroupId, this.tenantId, this.name, this.description, this.portPairList);
        }
    }
}

