/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtnrsc;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import org.onosproject.vtnrsc.Router;
import org.onosproject.vtnrsc.RouterGateway;
import org.onosproject.vtnrsc.RouterId;
import org.onosproject.vtnrsc.TenantId;
import org.onosproject.vtnrsc.VirtualPortId;

public final class DefaultRouter
implements Router {
    private final RouterId id;
    private final String name;
    private final boolean adminStateUp;
    private final Router.Status status;
    private final boolean distributed;
    private final RouterGateway externalGatewayInfo;
    private final VirtualPortId gatewayPortId;
    private final TenantId tenantId;
    private final List<String> routes;

    public DefaultRouter(RouterId id, String routerName, boolean adminStateUp, Router.Status status, boolean distributed, RouterGateway externalGatewayInfo, VirtualPortId gatewayPortId, TenantId tenantId, List<String> routes) {
        this.id = (RouterId)Preconditions.checkNotNull((Object)id, (Object)"id cannot be null");
        this.name = routerName;
        this.adminStateUp = (Boolean)Preconditions.checkNotNull((Object)adminStateUp, (Object)"adminStateUp cannot be null");
        this.status = (Router.Status)((Object)Preconditions.checkNotNull((Object)((Object)status), (Object)"status cannot be null"));
        this.distributed = (Boolean)Preconditions.checkNotNull((Object)distributed, (Object)"distributed cannot be null");
        this.externalGatewayInfo = externalGatewayInfo;
        this.gatewayPortId = gatewayPortId;
        this.tenantId = (TenantId)Preconditions.checkNotNull((Object)tenantId, (Object)"tenantId cannot be null");
        this.routes = routes;
    }

    @Override
    public RouterId id() {
        return this.id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public boolean adminStateUp() {
        return this.adminStateUp;
    }

    @Override
    public Router.Status status() {
        return this.status;
    }

    @Override
    public boolean distributed() {
        return this.distributed;
    }

    @Override
    public RouterGateway externalGatewayInfo() {
        return this.externalGatewayInfo;
    }

    @Override
    public VirtualPortId gatewayPortid() {
        return this.gatewayPortId;
    }

    @Override
    public TenantId tenantId() {
        return this.tenantId;
    }

    @Override
    public List<String> routes() {
        return this.routes;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.adminStateUp, this.status, this.distributed, this.externalGatewayInfo, this.gatewayPortId, this.routes});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultRouter) {
            DefaultRouter that = (DefaultRouter)obj;
            return Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && Objects.equals(this.adminStateUp, that.adminStateUp) && Objects.equals((Object)this.status, (Object)that.status) && Objects.equals(this.distributed, that.distributed) && Objects.equals(this.externalGatewayInfo, that.externalGatewayInfo) && Objects.equals(this.gatewayPortId, that.gatewayPortId) && Objects.equals(this.routes, that.routes);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("routerName", (Object)this.name).add("adminStateUp", this.adminStateUp).add("status", (Object)this.status).add("distributed", this.distributed).add("externalGatewayInfo", (Object)this.externalGatewayInfo).add("gatewayPortid", (Object)this.gatewayPortId).add("routes", this.routes).toString();
    }
}

