/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtnrsc;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.UUID;

public final class FlowClassifierId {
    private final UUID flowClassifierId;

    private FlowClassifierId(UUID flowClassifierId) {
        Preconditions.checkNotNull((Object)flowClassifierId, (Object)"Flow classifier id can not be null");
        this.flowClassifierId = flowClassifierId;
    }

    public static FlowClassifierId of(UUID flowClassifierId) {
        return new FlowClassifierId(flowClassifierId);
    }

    public static FlowClassifierId of(String flowClassifierId) {
        return new FlowClassifierId(UUID.fromString(flowClassifierId));
    }

    public UUID value() {
        return this.flowClassifierId;
    }

    public int hashCode() {
        return Objects.hashCode(this.flowClassifierId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof FlowClassifierId) {
            FlowClassifierId other = (FlowClassifierId)obj;
            return Objects.equals(this.flowClassifierId, other.flowClassifierId);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("FlowClassifierId", (Object)this.flowClassifierId).toString();
    }
}

