/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtnrsc;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.UUID;

public final class PortChainId {
    private final UUID portChainId;

    private PortChainId(UUID id) {
        Preconditions.checkNotNull((Object)id, (Object)"Port chain id can not be null");
        this.portChainId = id;
    }

    public static PortChainId of(UUID id) {
        return new PortChainId(id);
    }

    public static PortChainId of(String id) {
        return new PortChainId(UUID.fromString(id));
    }

    public UUID value() {
        return this.portChainId;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof PortChainId) {
            PortChainId other = (PortChainId)obj;
            return Objects.equals(this.portChainId, other.portChainId);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.portChainId);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("portChainId", (Object)this.portChainId).toString();
    }
}

