/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtnrsc;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onosproject.vtnrsc.RouterId;
import org.onosproject.vtnrsc.SubnetId;
import org.onosproject.vtnrsc.TenantId;
import org.onosproject.vtnrsc.VirtualPortId;

public final class RouterInterface {
    private final SubnetId subnetId;
    private final VirtualPortId portId;
    private final RouterId routerId;
    private final TenantId tenantId;

    private RouterInterface(SubnetId subnetId, VirtualPortId portId, RouterId routerId, TenantId tenantId) {
        this.subnetId = (SubnetId)Preconditions.checkNotNull((Object)subnetId, (Object)"subnetId cannot be null");
        this.portId = (VirtualPortId)Preconditions.checkNotNull((Object)portId, (Object)"portId cannot be null");
        this.routerId = (RouterId)Preconditions.checkNotNull((Object)routerId, (Object)"routerId cannot be null");
        this.tenantId = (TenantId)Preconditions.checkNotNull((Object)tenantId, (Object)"tenantId cannot be null");
    }

    public static RouterInterface routerInterface(SubnetId subnetId, VirtualPortId portId, RouterId routerId, TenantId tenantId) {
        return new RouterInterface(subnetId, portId, routerId, tenantId);
    }

    public SubnetId subnetId() {
        return this.subnetId;
    }

    public VirtualPortId portId() {
        return this.portId;
    }

    public RouterId routerId() {
        return this.routerId;
    }

    public TenantId tenantId() {
        return this.tenantId;
    }

    public int hashCode() {
        return Objects.hash(this.subnetId, this.portId, this.routerId, this.tenantId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof RouterInterface) {
            RouterInterface that = (RouterInterface)obj;
            return Objects.equals(this.subnetId, that.subnetId) && Objects.equals(this.portId, that.portId) && Objects.equals(this.routerId, that.routerId) && Objects.equals(this.tenantId, that.tenantId);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("subnetId", (Object)this.subnetId).add("portId", (Object)this.portId).add("routerId", (Object)this.routerId).add("tenantId", (Object)this.tenantId).toString();
    }
}

