/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtnrsc.classifier.impl;

import com.google.common.collect.ImmutableList;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.KryoNamespace;
import org.onosproject.net.DeviceId;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.DistributedSet;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.StorageService;
import org.onosproject.vtnrsc.classifier.ClassifierService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class ClassifierManager
implements ClassifierService {
    private final Logger log = LoggerFactory.getLogger(ClassifierManager.class);
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;
    private DistributedSet<DeviceId> classifierList;

    @Activate
    protected void activate() {
        this.classifierList = this.storageService.setBuilder().withName("classifier").withSerializer(Serializer.using((KryoNamespace)KryoNamespaces.API)).build();
        this.log.info("Started");
    }

    @Deactivate
    protected void deactivate() {
        this.log.info("Stopped");
    }

    @Override
    public void addClassifier(DeviceId deviceId) {
        this.classifierList.add((Object)deviceId);
    }

    @Override
    public Iterable<DeviceId> getClassifiers() {
        return ImmutableList.copyOf(this.classifierList);
    }

    @Override
    public void removeClassifier(DeviceId deviceId) {
        this.classifierList.remove((Object)deviceId);
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }
}

