/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtnrsc.cli.floatingip;

import com.google.common.collect.Sets;
import java.util.HashSet;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.onlab.packet.IpAddress;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.vtnrsc.DefaultFloatingIp;
import org.onosproject.vtnrsc.FloatingIp;
import org.onosproject.vtnrsc.FloatingIpId;
import org.onosproject.vtnrsc.RouterId;
import org.onosproject.vtnrsc.TenantId;
import org.onosproject.vtnrsc.TenantNetworkId;
import org.onosproject.vtnrsc.VirtualPortId;
import org.onosproject.vtnrsc.floatingip.FloatingIpService;

@Command(scope="onos", name="floatingip-create", description="Supports for creating a floating IP")
public class FloatingIpCreateCommand
extends AbstractShellCommand {
    @Argument(index=0, name="id", description="The floating IP identifier", required=true, multiValued=false)
    String id = null;
    @Argument(index=1, name="networkId", description="The network identifier of floating IP", required=true, multiValued=false)
    String networkId = null;
    @Argument(index=2, name="tenantId", description="The tenant identifier of floating IP", required=true, multiValued=false)
    String tenantId = null;
    @Argument(index=3, name="routerId", description="The router identifier of floating IP", required=true, multiValued=false)
    String routerId = null;
    @Argument(index=4, name="fixedIp", description="The fixed IP of floating IP", required=true, multiValued=false)
    String fixedIp = null;
    @Argument(index=5, name="floatingIp", description="The floating IP of floating IP", required=true, multiValued=false)
    String floatingIp = null;
    @Option(name="-p", aliases={"--portId"}, description="The port identifier of floating IP", required=false, multiValued=false)
    String portId = null;
    @Option(name="-s", aliases={"--status"}, description="The status of floating IP", required=false, multiValued=false)
    String status = null;

    protected void execute() {
        FloatingIpService service = (FloatingIpService)FloatingIpCreateCommand.get(FloatingIpService.class);
        try {
            DefaultFloatingIp floatingIpObj = new DefaultFloatingIp(FloatingIpId.of(this.id), TenantId.tenantId(this.tenantId), TenantNetworkId.networkId(this.networkId), VirtualPortId.portId(this.portId), RouterId.valueOf(this.routerId), this.floatingIp == null ? null : IpAddress.valueOf((String)this.floatingIp), this.fixedIp == null ? null : IpAddress.valueOf((String)this.fixedIp), this.status == null ? FloatingIp.Status.ACTIVE : FloatingIp.Status.valueOf(this.status));
            HashSet floatingIpSet = Sets.newHashSet((Object[])new FloatingIp[]{floatingIpObj});
            service.createFloatingIps(floatingIpSet);
        }
        catch (Exception e) {
            this.print(null, new Object[]{e.getMessage()});
        }
    }
}

