/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtnrsc.cli.floatingip;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.vtnrsc.FloatingIp;
import org.onosproject.vtnrsc.FloatingIpId;
import org.onosproject.vtnrsc.floatingip.FloatingIpService;

@Command(scope="onos", name="floatingip-remove", description="Supports for removing a floating IP")
public class FloatingIpRemoveCommand
extends AbstractShellCommand {
    @Option(name="-I", aliases={"--id"}, description="The floating IP identifier", required=false, multiValued=false)
    String id = null;
    @Option(name="-i", aliases={"--fixedIp"}, description="The fixed IP of floating IP", required=false, multiValued=false)
    String fixedIp = null;
    @Option(name="-l", aliases={"--floatingIp"}, description="The floating IP of floating IP", required=false, multiValued=false)
    String floatingIp = null;

    protected void execute() {
        FloatingIpService service = (FloatingIpService)FloatingIpRemoveCommand.get(FloatingIpService.class);
        if (this.id == null && this.fixedIp == null && this.floatingIp == null) {
            this.print(null, new Object[]{"one of id, fixedIp, floatingIp should not be null"});
        }
        try {
            HashSet floatingIpSet = Sets.newHashSet();
            if (this.id != null) {
                floatingIpSet.add(FloatingIpId.of(this.id));
                service.removeFloatingIps(floatingIpSet);
            } else {
                Collection<FloatingIp> floatingIps = service.getFloatingIps();
                if (floatingIps == null) {
                    return;
                }
                if (this.fixedIp != null) {
                    for (FloatingIp floatingIp : floatingIps) {
                        if (!floatingIp.fixedIp().toString().equals(this.fixedIp)) continue;
                        floatingIpSet.add(floatingIp.id());
                        service.removeFloatingIps(floatingIpSet);
                        return;
                    }
                    this.print(null, new Object[]{"The fixedIp is not existed"});
                    return;
                }
                if (this.floatingIp != null) {
                    for (FloatingIp floatingIpObj : floatingIps) {
                        if (!floatingIpObj.fixedIp().toString().equals(this.floatingIp)) continue;
                        floatingIpSet.add(floatingIpObj.id());
                        service.removeFloatingIps(floatingIpSet);
                        return;
                    }
                    this.print(null, new Object[]{"The floatingIp is not existed"});
                    return;
                }
            }
        }
        catch (Exception e) {
            this.print(null, new Object[]{e.getMessage()});
        }
    }
}

