/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtnrsc.cli.router;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.vtnrsc.DefaultRouter;
import org.onosproject.vtnrsc.Router;
import org.onosproject.vtnrsc.RouterId;
import org.onosproject.vtnrsc.TenantId;
import org.onosproject.vtnrsc.VirtualPortId;
import org.onosproject.vtnrsc.router.RouterService;

@Command(scope="onos", name="router-create", description="Supports for creating a router")
public class RouterCreateCommand
extends AbstractShellCommand {
    @Argument(index=0, name="id", description="The router identifier", required=true, multiValued=false)
    String id = null;
    @Argument(index=1, name="routerName", description="The name of router", required=true, multiValued=false)
    String routerName = null;
    @Argument(index=2, name="tenantId", description="The tenant identifier of router", required=true, multiValued=false)
    String tenantId = null;
    @Option(name="-g", aliases={"--gatewayPortId"}, description="The gatewayPort identifier of router", required=false, multiValued=false)
    String gatewayPortId = null;
    @Option(name="-e", aliases={"--externalGatewayInfo"}, description="The external gateway info of router", required=false, multiValued=false)
    String externalGatewayInfo = null;
    @Option(name="-s", aliases={"--status"}, description="The status of router", required=false, multiValued=false)
    String status = null;
    @Option(name="-a", aliases={"--adminStateUp"}, description="The boolean adminStateUp of router", required=false, multiValued=false)
    boolean adminStateUp = true;
    @Option(name="-d", aliases={"--distributed"}, description="The boolean distributed of router", required=false, multiValued=false)
    boolean distributed = false;

    protected void execute() {
        RouterService service = (RouterService)RouterCreateCommand.get(RouterService.class);
        try {
            ArrayList<String> routes = new ArrayList<String>();
            DefaultRouter router = new DefaultRouter(RouterId.valueOf(this.id), this.routerName, this.adminStateUp, this.status == null ? Router.Status.ACTIVE : Router.Status.valueOf(this.status), this.distributed, null, VirtualPortId.portId(this.gatewayPortId), TenantId.tenantId(this.tenantId), routes);
            HashSet routerSet = Sets.newHashSet((Object[])new Router[]{router});
            service.createRouters(routerSet);
        }
        catch (Exception e) {
            this.print(null, new Object[]{e.getMessage()});
        }
    }
}

