/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtnrsc.cli.subnet;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.vtnrsc.AllocationPool;
import org.onosproject.vtnrsc.DefaultSubnet;
import org.onosproject.vtnrsc.HostRoute;
import org.onosproject.vtnrsc.Subnet;
import org.onosproject.vtnrsc.SubnetId;
import org.onosproject.vtnrsc.TenantId;
import org.onosproject.vtnrsc.TenantNetworkId;
import org.onosproject.vtnrsc.subnet.SubnetService;

@Command(scope="onos", name="subnet-create", description="Supports for creating a subnet")
public class SubnetCreateCommand
extends AbstractShellCommand {
    @Argument(index=0, name="id", description="Subnet Id", required=true, multiValued=false)
    String id = null;
    @Argument(index=1, name="subnetName", description="Subnet String name", required=true, multiValued=false)
    String subnetName = null;
    @Argument(index=2, name="networkId", description="Subnet Network Id", required=true, multiValued=false)
    String networkId = null;
    @Argument(index=3, name="tenantId", description="Subnet Tenant Id", required=true, multiValued=false)
    String tenantId = null;
    @Option(name="-i", aliases={"--ipVersion"}, description="Subnet Version ipVersion", required=false, multiValued=false)
    IpAddress.Version ipVersion = null;
    @Option(name="-c", aliases={"--cidr"}, description="Subnet IpPrefix cidr", required=false, multiValued=false)
    String cidr = "0.0.0.0/0";
    @Option(name="-g", aliases={"--gatewayIp"}, description="Subnet IpAddress gatewayIp", required=false, multiValued=false)
    String gatewayIp = "0.0.0.0";
    @Option(name="-d", aliases={"--dhcpEnabled"}, description="Subnet boolean dhcpEnabled", required=false, multiValued=false)
    boolean dhcpEnabled = false;
    @Option(name="-s", aliases={"--shared"}, description="Subnet boolean shared", required=false, multiValued=false)
    boolean shared = false;
    @Option(name="-m", aliases={"--ipV6AddressMode"}, description="Subnet Mode ipV6AddressMode", required=false, multiValued=false)
    String ipV6AddressMode = null;
    @Option(name="-r", aliases={"--ipV6RaMode"}, description="Subnet Mode ipV6RaMode", required=false, multiValued=false)
    String ipV6RaMode = null;
    @Option(name="-h", aliases={"--hostRoutes"}, description="Subnet jsonnode hostRoutes", required=false, multiValued=false)
    Set<HostRoute> hostRoutes = Sets.newHashSet();
    @Option(name="-a", aliases={"--allocationPools"}, description="Subnet jsonnode allocationPools", required=false, multiValued=false)
    Set<AllocationPool> allocationPools = Sets.newHashSet();

    protected void execute() {
        SubnetService service = (SubnetService)SubnetCreateCommand.get(SubnetService.class);
        if (this.id == null || this.networkId == null || this.tenantId == null) {
            this.print("id,networkId,tenantId can not be null", new Object[0]);
            return;
        }
        DefaultSubnet subnet = new DefaultSubnet(SubnetId.subnetId(this.id), this.subnetName, TenantNetworkId.networkId(this.networkId), TenantId.tenantId(this.tenantId), this.ipVersion, this.cidr == null ? null : IpPrefix.valueOf((String)this.cidr), this.gatewayIp == null ? null : IpAddress.valueOf((String)this.gatewayIp), this.dhcpEnabled, this.shared, this.hostRoutes, this.ipV6AddressMode == null ? null : Subnet.Mode.valueOf(this.ipV6AddressMode), this.ipV6RaMode == null ? null : Subnet.Mode.valueOf(this.ipV6RaMode), this.allocationPools);
        HashSet subnetsSet = Sets.newHashSet((Object[])new Subnet[]{subnet});
        service.createSubnets(subnetsSet);
    }
}

