/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtnrsc.cli.virtualport;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onosproject.cli.AbstractShellCommand;
import org.onosproject.vtnrsc.BindingHostId;
import org.onosproject.vtnrsc.DefaultVirtualPort;
import org.onosproject.vtnrsc.FixedIp;
import org.onosproject.vtnrsc.Subnet;
import org.onosproject.vtnrsc.TenantNetwork;
import org.onosproject.vtnrsc.VirtualPort;
import org.onosproject.vtnrsc.VirtualPortId;
import org.onosproject.vtnrsc.subnet.SubnetService;
import org.onosproject.vtnrsc.tenantnetwork.TenantNetworkService;
import org.onosproject.vtnrsc.virtualport.VirtualPortService;

@Command(scope="onos", name="externalgateway-update", description="Supports for updating the external gateway virtualPort.")
public class VirtualPortExGwUpdateCommand
extends AbstractShellCommand {
    @Option(name="-m", aliases={"--macAddress"}, description="MAC address.", required=true, multiValued=false)
    String macAddress = "";

    protected void execute() {
        VirtualPortService service = (VirtualPortService)VirtualPortExGwUpdateCommand.get(VirtualPortService.class);
        SubnetService subnetService = (SubnetService)VirtualPortExGwUpdateCommand.get(SubnetService.class);
        TenantNetworkService tenantNetworkService = (TenantNetworkService)VirtualPortExGwUpdateCommand.get(TenantNetworkService.class);
        Iterable<TenantNetwork> networks = tenantNetworkService.getNetworks();
        if (networks != null) {
            for (TenantNetwork network : networks) {
                Iterable<Subnet> subnets;
                if (!network.routerExternal() || (subnets = subnetService.getSubnets()) == null) continue;
                for (Subnet subnet : subnets) {
                    if (!network.id().networkId().equals(subnet.networkId().networkId())) continue;
                    IpAddress exgwip = subnet.gatewayIp();
                    FixedIp fixedGwIp = FixedIp.fixedIp(subnet.id(), exgwip);
                    VirtualPort exgwPort = service.getPort(fixedGwIp);
                    if (exgwPort == null) {
                        this.createExGwPort(network, subnet, fixedGwIp);
                        continue;
                    }
                    this.updateExGwPort(exgwPort);
                }
            }
        }
    }

    private void createExGwPort(TenantNetwork network, Subnet subnet, FixedIp fixedGwIp) {
        VirtualPortService service = (VirtualPortService)VirtualPortExGwUpdateCommand.get(VirtualPortService.class);
        HashMap strMap = Maps.newHashMap();
        DefaultVirtualPort virtualPort = new DefaultVirtualPort(VirtualPortId.portId("externalgateway-update-id"), network.id(), false, strMap, VirtualPort.State.DOWN, MacAddress.valueOf((String)this.macAddress), subnet.tenantId(), null, Sets.newHashSet((Object[])new FixedIp[]{fixedGwIp}), BindingHostId.bindingHostId(""), Sets.newHashSet(), Sets.newHashSet());
        HashSet virtualPorts = Sets.newHashSet((Object[])new VirtualPort[]{virtualPort});
        service.createPorts(virtualPorts);
    }

    private void updateExGwPort(VirtualPort exgwPort) {
        VirtualPortService service = (VirtualPortService)VirtualPortExGwUpdateCommand.get(VirtualPortService.class);
        HashMap strMap = Maps.newHashMap();
        strMap.putIfAbsent("name", exgwPort.name());
        strMap.putIfAbsent("deviceOwner", exgwPort.deviceOwner());
        strMap.putIfAbsent("bindingvnicType", exgwPort.bindingVnicType());
        strMap.putIfAbsent("bindingvifType", exgwPort.bindingVifType());
        strMap.putIfAbsent("bindingvnicDetails", exgwPort.bindingVifDetails());
        DefaultVirtualPort virtualPort = new DefaultVirtualPort(exgwPort.portId(), exgwPort.networkId(), false, strMap, VirtualPort.State.DOWN, MacAddress.valueOf((String)this.macAddress), exgwPort.tenantId(), exgwPort.deviceId(), exgwPort.fixedIps(), exgwPort.bindingHostId(), Sets.newHashSet(exgwPort.allowedAddressPairs()), Sets.newHashSet(exgwPort.securityGroups()));
        HashSet virtualPorts = Sets.newHashSet((Object[])new VirtualPort[]{virtualPort});
        service.updatePorts(virtualPorts);
    }
}

