/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtnrsc.portchain.impl;

import com.google.common.base.Preconditions;
import java.util.Collections;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.KryoNamespace;
import org.onosproject.event.AbstractListenerManager;
import org.onosproject.event.Event;
import org.onosproject.event.EventSink;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.EventuallyConsistentMap;
import org.onosproject.store.service.EventuallyConsistentMapEvent;
import org.onosproject.store.service.EventuallyConsistentMapListener;
import org.onosproject.store.service.MultiValuedTimestamp;
import org.onosproject.store.service.StorageService;
import org.onosproject.store.service.WallClockTimestamp;
import org.onosproject.vtnrsc.PortChain;
import org.onosproject.vtnrsc.PortChainId;
import org.onosproject.vtnrsc.portchain.PortChainEvent;
import org.onosproject.vtnrsc.portchain.PortChainListener;
import org.onosproject.vtnrsc.portchain.PortChainService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class PortChainManager
extends AbstractListenerManager<PortChainEvent, PortChainListener>
implements PortChainService {
    private static final String PORT_CHAIN_ID_NULL = "PortChain ID cannot be null";
    private static final String PORT_CHAIN_NULL = "PortChain cannot be null";
    private static final String EVENT_NOT_NULL = "event cannot be null";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private EventuallyConsistentMap<PortChainId, PortChain> portChainStore;
    private EventuallyConsistentMapListener<PortChainId, PortChain> portChainListener = new InnerPortChainStoreListener();
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;

    @Activate
    public void activate() {
        this.eventDispatcher.addSink(PortChainEvent.class, (EventSink)this.listenerRegistry);
        KryoNamespace.Builder serializer = KryoNamespace.newBuilder().register(KryoNamespaces.API).register(new Class[]{MultiValuedTimestamp.class}).register(new Class[]{PortChain.class});
        this.portChainStore = this.storageService.eventuallyConsistentMapBuilder().withName("portchainstore").withSerializer(serializer).withTimestampProvider((k, v) -> new WallClockTimestamp()).build();
        this.portChainStore.addListener(this.portChainListener);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.eventDispatcher.removeSink(PortChainEvent.class);
        this.portChainStore.destroy();
        this.log.info("Stopped");
    }

    @Override
    public boolean exists(PortChainId portChainId) {
        Preconditions.checkNotNull((Object)portChainId, (Object)PORT_CHAIN_ID_NULL);
        return this.portChainStore.containsKey((Object)portChainId);
    }

    @Override
    public int getPortChainCount() {
        return this.portChainStore.size();
    }

    @Override
    public Iterable<PortChain> getPortChains() {
        return Collections.unmodifiableCollection(this.portChainStore.values());
    }

    @Override
    public PortChain getPortChain(PortChainId portChainId) {
        Preconditions.checkNotNull((Object)portChainId, (Object)PORT_CHAIN_ID_NULL);
        return (PortChain)this.portChainStore.get((Object)portChainId);
    }

    @Override
    public boolean createPortChain(PortChain portChain) {
        Preconditions.checkNotNull((Object)portChain, (Object)PORT_CHAIN_NULL);
        this.portChainStore.put((Object)portChain.portChainId(), (Object)portChain);
        if (!this.portChainStore.containsKey((Object)portChain.portChainId())) {
            this.log.debug("The portChain is created failed which identifier was {}", (Object)portChain.portChainId().toString());
            return false;
        }
        return true;
    }

    @Override
    public boolean updatePortChain(PortChain portChain) {
        Preconditions.checkNotNull((Object)portChain, (Object)PORT_CHAIN_NULL);
        if (!this.portChainStore.containsKey((Object)portChain.portChainId())) {
            this.log.debug("The portChain is not exist whose identifier was {} ", (Object)portChain.portChainId().toString());
            return false;
        }
        this.portChainStore.put((Object)portChain.portChainId(), (Object)portChain);
        if (!portChain.equals(this.portChainStore.get((Object)portChain.portChainId()))) {
            this.log.debug("The portChain is updated failed whose identifier was {} ", (Object)portChain.portChainId().toString());
            return false;
        }
        return true;
    }

    @Override
    public boolean removePortChain(PortChainId portChainId) {
        Preconditions.checkNotNull((Object)portChainId, (Object)PORT_CHAIN_NULL);
        this.portChainStore.remove((Object)portChainId);
        if (this.portChainStore.containsKey((Object)portChainId)) {
            this.log.debug("The portChain is removed failed whose identifier was {}", (Object)portChainId.toString());
            return false;
        }
        return true;
    }

    private void notifyListeners(PortChainEvent event) {
        Preconditions.checkNotNull((Object)((Object)event), (Object)EVENT_NOT_NULL);
        this.post((Event)event);
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }

    private class InnerPortChainStoreListener
    implements EventuallyConsistentMapListener<PortChainId, PortChain> {
        private InnerPortChainStoreListener() {
        }

        public void event(EventuallyConsistentMapEvent<PortChainId, PortChain> event) {
            Preconditions.checkNotNull(event, (Object)PortChainManager.EVENT_NOT_NULL);
            PortChain portChain = (PortChain)event.value();
            if (EventuallyConsistentMapEvent.Type.PUT == event.type()) {
                PortChainManager.this.notifyListeners(new PortChainEvent(PortChainEvent.Type.PORT_CHAIN_PUT, portChain));
            }
            if (EventuallyConsistentMapEvent.Type.REMOVE == event.type()) {
                PortChainManager.this.notifyListeners(new PortChainEvent(PortChainEvent.Type.PORT_CHAIN_DELETE, portChain));
            }
        }
    }
}

