/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtnrsc.router.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.KryoNamespace;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.event.Event;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.EventuallyConsistentMap;
import org.onosproject.store.service.EventuallyConsistentMapEvent;
import org.onosproject.store.service.EventuallyConsistentMapListener;
import org.onosproject.store.service.StorageService;
import org.onosproject.store.service.WallClockTimestamp;
import org.onosproject.vtnrsc.DefaultRouter;
import org.onosproject.vtnrsc.FixedIp;
import org.onosproject.vtnrsc.Router;
import org.onosproject.vtnrsc.RouterGateway;
import org.onosproject.vtnrsc.RouterId;
import org.onosproject.vtnrsc.SubnetId;
import org.onosproject.vtnrsc.TenantId;
import org.onosproject.vtnrsc.TenantNetworkId;
import org.onosproject.vtnrsc.VirtualPortId;
import org.onosproject.vtnrsc.router.RouterEvent;
import org.onosproject.vtnrsc.router.RouterListener;
import org.onosproject.vtnrsc.router.RouterService;
import org.onosproject.vtnrsc.subnet.SubnetService;
import org.onosproject.vtnrsc.tenantnetwork.TenantNetworkService;
import org.onosproject.vtnrsc.virtualport.VirtualPortService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class RouterManager
implements RouterService {
    private static final String ROUTER_ID_NULL = "Router ID cannot be null";
    private static final String ROUTER_NOT_NULL = "Router cannot be null";
    private static final String ROUTER = "vtn-router-store";
    private static final String VTNRSC_APP = "org.onosproject.vtnrsc";
    private static final String LISTENER_NOT_NULL = "Listener cannot be null";
    private static final String EVENT_NOT_NULL = "event cannot be null";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Set<RouterListener> listeners = Sets.newCopyOnWriteArraySet();
    private EventuallyConsistentMapListener<RouterId, Router> routerListener = new InnerRouterStoreListener();
    protected EventuallyConsistentMap<RouterId, Router> routerStore;
    protected ApplicationId appId;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected TenantNetworkService tenantNetworkService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected VirtualPortService virtualPortService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected SubnetService subnetService;

    @Activate
    public void activate() {
        this.appId = this.coreService.registerApplication(VTNRSC_APP);
        KryoNamespace.Builder serializer = KryoNamespace.newBuilder().register(KryoNamespaces.API).register(new Class[]{Router.class, RouterId.class, DefaultRouter.class, TenantNetworkId.class, TenantId.class, VirtualPortId.class, DefaultRouter.class, RouterGateway.class, Router.Status.class, SubnetId.class});
        this.routerStore = this.storageService.eventuallyConsistentMapBuilder().withName(ROUTER).withSerializer(serializer).withTimestampProvider((k, v) -> new WallClockTimestamp()).build();
        this.routerStore.addListener(this.routerListener);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.routerStore.removeListener(this.routerListener);
        this.routerStore.destroy();
        this.listeners.clear();
        this.log.info("Stopped");
    }

    @Override
    public boolean exists(RouterId routerId) {
        Preconditions.checkNotNull((Object)routerId, (Object)ROUTER_ID_NULL);
        return this.routerStore.containsKey((Object)routerId);
    }

    @Override
    public Collection<Router> getRouters() {
        return Collections.unmodifiableCollection(this.routerStore.values());
    }

    @Override
    public Router getRouter(RouterId routerId) {
        Preconditions.checkNotNull((Object)routerId, (Object)ROUTER_ID_NULL);
        return (Router)this.routerStore.get((Object)routerId);
    }

    @Override
    public boolean createRouters(Collection<Router> routers) {
        Preconditions.checkNotNull(routers, (Object)ROUTER_NOT_NULL);
        for (Router router : routers) {
            this.verifyRouterData(router);
            this.routerStore.put((Object)router.id(), (Object)router);
            if (this.routerStore.containsKey((Object)router.id())) continue;
            this.log.debug("The router is created failed whose identifier is {}", (Object)router.id().toString());
            return false;
        }
        return true;
    }

    @Override
    public boolean updateRouters(Collection<Router> routers) {
        Preconditions.checkNotNull(routers, (Object)ROUTER_NOT_NULL);
        for (Router router : routers) {
            if (!this.routerStore.containsKey((Object)router.id())) {
                this.log.debug("The routers is not exist whose identifier is {}", (Object)router.id().toString());
                throw new IllegalArgumentException("routers ID doesn't exist");
            }
            this.verifyRouterData(router);
            this.routerStore.put((Object)router.id(), (Object)router);
            if (router.equals(this.routerStore.get((Object)router.id()))) continue;
            this.log.debug("The router is updated failed whose identifier is {}", (Object)router.id().toString());
            return false;
        }
        return true;
    }

    @Override
    public boolean removeRouters(Collection<RouterId> routerIds) {
        Preconditions.checkNotNull(routerIds, (Object)ROUTER_ID_NULL);
        for (RouterId routerId : routerIds) {
            if (!this.routerStore.containsKey((Object)routerId)) {
                this.log.debug("The router is not exist whose identifier is {}", (Object)routerId.toString());
                throw new IllegalArgumentException("router ID doesn't exist");
            }
            Router router = (Router)this.routerStore.get((Object)routerId);
            this.routerStore.remove((Object)routerId, (Object)router);
            if (!this.routerStore.containsKey((Object)routerId)) continue;
            this.log.debug("The router deleted is failed whose identifier is {}", (Object)routerId.toString());
            return false;
        }
        return true;
    }

    @Override
    public void addListener(RouterListener listener) {
        Preconditions.checkNotNull((Object)listener, (Object)LISTENER_NOT_NULL);
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(RouterListener listener) {
        Preconditions.checkNotNull((Object)listener, (Object)LISTENER_NOT_NULL);
        this.listeners.remove(listener);
    }

    private void verifyRouterData(Router routers) {
        Preconditions.checkNotNull((Object)routers, (Object)ROUTER_NOT_NULL);
        if (routers.gatewayPortid() != null && !this.virtualPortService.exists(routers.gatewayPortid())) {
            this.log.debug("The gateway port ID is not exist whose identifier is {}", (Object)routers.gatewayPortid().toString());
            throw new IllegalArgumentException("gateway port ID doesn't exist");
        }
        if (routers.externalGatewayInfo() != null) {
            RouterGateway routerGateway = routers.externalGatewayInfo();
            if (!this.tenantNetworkService.exists(routerGateway.networkId())) {
                this.log.debug("The network ID of gateway info is not exist whose identifier is {}", (Object)routers.id().toString());
                throw new IllegalArgumentException("network ID of gateway info doesn't exist");
            }
            Collection<FixedIp> fixedIps = routerGateway.externalFixedIps();
            for (FixedIp fixedIp : fixedIps) {
                if (this.subnetService.exists(fixedIp.subnetId())) continue;
                this.log.debug("The subnet ID of gateway info is not exist whose identifier is {}", (Object)routers.id().toString());
                throw new IllegalArgumentException("subnet ID of gateway info doesn't exist");
            }
        }
    }

    private void notifyListeners(RouterEvent event) {
        Preconditions.checkNotNull((Object)((Object)event), (Object)EVENT_NOT_NULL);
        this.listeners.forEach(listener -> listener.event((Event)event));
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindTenantNetworkService(TenantNetworkService tenantNetworkService) {
        this.tenantNetworkService = tenantNetworkService;
    }

    protected void unbindTenantNetworkService(TenantNetworkService tenantNetworkService) {
        if (this.tenantNetworkService == tenantNetworkService) {
            this.tenantNetworkService = null;
        }
    }

    protected void bindVirtualPortService(VirtualPortService virtualPortService) {
        this.virtualPortService = virtualPortService;
    }

    protected void unbindVirtualPortService(VirtualPortService virtualPortService) {
        if (this.virtualPortService == virtualPortService) {
            this.virtualPortService = null;
        }
    }

    protected void bindSubnetService(SubnetService subnetService) {
        this.subnetService = subnetService;
    }

    protected void unbindSubnetService(SubnetService subnetService) {
        if (this.subnetService == subnetService) {
            this.subnetService = null;
        }
    }

    private class InnerRouterStoreListener
    implements EventuallyConsistentMapListener<RouterId, Router> {
        private InnerRouterStoreListener() {
        }

        public void event(EventuallyConsistentMapEvent<RouterId, Router> event) {
            Preconditions.checkNotNull(event, (Object)RouterManager.EVENT_NOT_NULL);
            Router router = (Router)event.value();
            if (EventuallyConsistentMapEvent.Type.PUT == event.type()) {
                RouterManager.this.notifyListeners(new RouterEvent(RouterEvent.Type.ROUTER_PUT, router));
            }
            if (EventuallyConsistentMapEvent.Type.REMOVE == event.type()) {
                RouterManager.this.notifyListeners(new RouterEvent(RouterEvent.Type.ROUTER_DELETE, router));
            }
        }
    }
}

