/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtnrsc.routerinterface.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.util.KryoNamespace;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.event.Event;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.EventuallyConsistentMap;
import org.onosproject.store.service.EventuallyConsistentMapEvent;
import org.onosproject.store.service.EventuallyConsistentMapListener;
import org.onosproject.store.service.StorageService;
import org.onosproject.store.service.WallClockTimestamp;
import org.onosproject.vtnrsc.RouterId;
import org.onosproject.vtnrsc.RouterInterface;
import org.onosproject.vtnrsc.SubnetId;
import org.onosproject.vtnrsc.TenantId;
import org.onosproject.vtnrsc.VirtualPortId;
import org.onosproject.vtnrsc.router.RouterService;
import org.onosproject.vtnrsc.routerinterface.RouterInterfaceEvent;
import org.onosproject.vtnrsc.routerinterface.RouterInterfaceListener;
import org.onosproject.vtnrsc.routerinterface.RouterInterfaceService;
import org.onosproject.vtnrsc.subnet.SubnetService;
import org.onosproject.vtnrsc.virtualport.VirtualPortService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class RouterInterfaceManager
implements RouterInterfaceService {
    private static final String SUBNET_ID_NULL = "Subnet ID cannot be null";
    private static final String ROUTER_INTERFACE_NULL = "Router Interface cannot be null";
    private static final String ROUTER_INTERFACE = "vtn-router-interface-store";
    private static final String VTNRSC_APP = "org.onosproject.vtnrsc";
    private static final String LISTENER_NOT_NULL = "Listener cannot be null";
    private static final String EVENT_NOT_NULL = "event cannot be null";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Set<RouterInterfaceListener> listeners = Sets.newCopyOnWriteArraySet();
    private EventuallyConsistentMapListener<SubnetId, RouterInterface> routerInterfaceListener = new InnerRouterInterfaceStoreListener();
    protected EventuallyConsistentMap<SubnetId, RouterInterface> routerInterfaceStore;
    protected ApplicationId appId;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected VirtualPortService virtualPortService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected SubnetService subnetService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected RouterService routerService;

    @Activate
    public void activate() {
        this.appId = this.coreService.registerApplication(VTNRSC_APP);
        KryoNamespace.Builder serializer = KryoNamespace.newBuilder().register(KryoNamespaces.API).register(new Class[]{RouterId.class, TenantId.class, VirtualPortId.class, RouterInterface.class, SubnetId.class});
        this.routerInterfaceStore = this.storageService.eventuallyConsistentMapBuilder().withName(ROUTER_INTERFACE).withSerializer(serializer).withTimestampProvider((k, v) -> new WallClockTimestamp()).build();
        this.routerInterfaceStore.addListener(this.routerInterfaceListener);
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.routerInterfaceStore.removeListener(this.routerInterfaceListener);
        this.routerInterfaceStore.destroy();
        this.listeners.clear();
        this.log.info("Stopped");
    }

    @Override
    public boolean exists(SubnetId subnetId) {
        Preconditions.checkNotNull((Object)subnetId, (Object)SUBNET_ID_NULL);
        return this.routerInterfaceStore.containsKey((Object)subnetId);
    }

    @Override
    public Collection<RouterInterface> getRouterInterfaces() {
        return Collections.unmodifiableCollection(this.routerInterfaceStore.values());
    }

    @Override
    public RouterInterface getRouterInterface(SubnetId subnetId) {
        Preconditions.checkNotNull((Object)subnetId, (Object)SUBNET_ID_NULL);
        return (RouterInterface)this.routerInterfaceStore.get((Object)subnetId);
    }

    @Override
    public boolean addRouterInterface(RouterInterface routerInterface) {
        Preconditions.checkNotNull((Object)routerInterface, (Object)ROUTER_INTERFACE_NULL);
        if (!this.virtualPortService.exists(routerInterface.portId())) {
            this.log.debug("The port ID of interface is not exist whose identifier is {}", (Object)routerInterface.portId().toString());
            throw new IllegalArgumentException("port ID of interface doesn't exist");
        }
        this.verifyRouterInterfaceData(routerInterface);
        this.routerInterfaceStore.put((Object)routerInterface.subnetId(), (Object)routerInterface);
        if (!this.routerInterfaceStore.containsKey((Object)routerInterface.subnetId())) {
            this.log.debug("The router interface is created failed whose identifier is {}", (Object)routerInterface.subnetId().toString());
            return false;
        }
        return true;
    }

    @Override
    public boolean removeRouterInterface(RouterInterface routerInterface) {
        Preconditions.checkNotNull((Object)routerInterface, (Object)ROUTER_INTERFACE_NULL);
        if (!this.routerInterfaceStore.containsKey((Object)routerInterface.subnetId())) {
            this.log.debug("The router interface is not exist whose identifier is {}", (Object)routerInterface.subnetId().toString());
            throw new IllegalArgumentException("subnet ID doesn't exist");
        }
        this.verifyRouterInterfaceData(routerInterface);
        this.routerInterfaceStore.remove((Object)routerInterface.subnetId(), (Object)routerInterface);
        if (this.routerInterfaceStore.containsKey((Object)routerInterface.subnetId())) {
            this.log.debug("The router interface deleted is failed whose identifier is {}", (Object)routerInterface.subnetId().toString());
            return false;
        }
        return true;
    }

    @Override
    public void addListener(RouterInterfaceListener listener) {
        Preconditions.checkNotNull((Object)listener, (Object)LISTENER_NOT_NULL);
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(RouterInterfaceListener listener) {
        Preconditions.checkNotNull((Object)listener, (Object)LISTENER_NOT_NULL);
        this.listeners.remove(listener);
    }

    private void verifyRouterInterfaceData(RouterInterface routerInterface) {
        Preconditions.checkNotNull((Object)routerInterface, (Object)ROUTER_INTERFACE_NULL);
        if (!this.subnetService.exists(routerInterface.subnetId())) {
            this.log.debug("The subnet ID of interface is not exist whose identifier is {}", (Object)routerInterface.subnetId().toString());
            throw new IllegalArgumentException("subnet ID of interface doesn't exist");
        }
        if (!this.routerService.exists(routerInterface.routerId())) {
            this.log.debug("The router ID of interface is not exist whose identifier is {}", (Object)routerInterface.routerId().toString());
            throw new IllegalArgumentException("router ID of interface doesn't exist");
        }
    }

    private void notifyListeners(RouterInterfaceEvent event) {
        Preconditions.checkNotNull((Object)((Object)event), (Object)EVENT_NOT_NULL);
        this.listeners.forEach(listener -> listener.event((Event)event));
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindVirtualPortService(VirtualPortService virtualPortService) {
        this.virtualPortService = virtualPortService;
    }

    protected void unbindVirtualPortService(VirtualPortService virtualPortService) {
        if (this.virtualPortService == virtualPortService) {
            this.virtualPortService = null;
        }
    }

    protected void bindSubnetService(SubnetService subnetService) {
        this.subnetService = subnetService;
    }

    protected void unbindSubnetService(SubnetService subnetService) {
        if (this.subnetService == subnetService) {
            this.subnetService = null;
        }
    }

    protected void bindRouterService(RouterService routerService) {
        this.routerService = routerService;
    }

    protected void unbindRouterService(RouterService routerService) {
        if (this.routerService == routerService) {
            this.routerService = null;
        }
    }

    private class InnerRouterInterfaceStoreListener
    implements EventuallyConsistentMapListener<SubnetId, RouterInterface> {
        private InnerRouterInterfaceStoreListener() {
        }

        public void event(EventuallyConsistentMapEvent<SubnetId, RouterInterface> event) {
            Preconditions.checkNotNull(event, (Object)RouterInterfaceManager.EVENT_NOT_NULL);
            RouterInterface routerInterface = (RouterInterface)event.value();
            if (EventuallyConsistentMapEvent.Type.PUT == event.type()) {
                RouterInterfaceManager.this.notifyListeners(new RouterInterfaceEvent(RouterInterfaceEvent.Type.ROUTER_INTERFACE_PUT, routerInterface));
            }
            if (EventuallyConsistentMapEvent.Type.REMOVE == event.type()) {
                RouterInterfaceManager.this.notifyListeners(new RouterInterfaceEvent(RouterInterfaceEvent.Type.ROUTER_INTERFACE_DELETE, routerInterface));
            }
        }
    }
}

