/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtnrsc.subnet.impl;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onlab.packet.IpAddress;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.StorageService;
import org.onosproject.vtnrsc.AllocationPool;
import org.onosproject.vtnrsc.DefaultAllocationPool;
import org.onosproject.vtnrsc.DefaultHostRoute;
import org.onosproject.vtnrsc.DefaultSubnet;
import org.onosproject.vtnrsc.HostRoute;
import org.onosproject.vtnrsc.Subnet;
import org.onosproject.vtnrsc.SubnetId;
import org.onosproject.vtnrsc.TenantId;
import org.onosproject.vtnrsc.TenantNetworkId;
import org.onosproject.vtnrsc.subnet.SubnetService;
import org.onosproject.vtnrsc.tenantnetwork.TenantNetworkService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class SubnetManager
implements SubnetService {
    private static final String SUBNET_ID_NULL = "Subnet ID cannot be null";
    private static final String SUBNET_NOT_NULL = "Subnet cannot be null";
    private static final String SUBNET = "vtn-subnet-store";
    private static final String VTNRSC_APP = "org.onosproject.vtnrsc";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    protected Map<SubnetId, Subnet> subnetStore;
    protected ApplicationId appId;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected TenantNetworkService tenantNetworkService;

    @Activate
    public void activate() {
        this.appId = this.coreService.registerApplication(VTNRSC_APP);
        this.subnetStore = this.storageService.consistentMapBuilder().withName(SUBNET).withApplicationId(this.appId).withPurgeOnUninstall().withSerializer(Serializer.using(Arrays.asList(KryoNamespaces.API), (Class[])new Class[]{Subnet.class, SubnetId.class, TenantNetworkId.class, TenantId.class, HostRoute.class, DefaultHostRoute.class, Subnet.Mode.class, AllocationPool.class, DefaultAllocationPool.class, DefaultSubnet.class, IpAddress.Version.class})).build().asJavaMap();
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.log.info("Stopped");
    }

    @Override
    public Iterable<Subnet> getSubnets() {
        return Collections.unmodifiableCollection(this.subnetStore.values());
    }

    @Override
    public Subnet getSubnet(SubnetId subnetId) {
        Preconditions.checkNotNull((Object)subnetId, (Object)SUBNET_ID_NULL);
        return this.subnetStore.get(subnetId);
    }

    @Override
    public boolean exists(SubnetId subnetId) {
        Preconditions.checkNotNull((Object)subnetId, (Object)SUBNET_ID_NULL);
        return this.subnetStore.containsKey(subnetId);
    }

    @Override
    public boolean createSubnets(Iterable<Subnet> subnets) {
        Preconditions.checkNotNull(subnets, (Object)SUBNET_NOT_NULL);
        for (Subnet subnet : subnets) {
            if (!this.tenantNetworkService.exists(subnet.networkId())) {
                this.log.debug("The network identifier that the subnet {} belong to is not exist", (Object)subnet.networkId().toString(), (Object)subnet.id().toString());
                return false;
            }
            this.subnetStore.put(subnet.id(), subnet);
            if (this.subnetStore.containsKey(subnet.id())) continue;
            this.log.debug("The identified subnet whose identifier is {}  create failed", (Object)subnet.id().toString());
            return false;
        }
        return true;
    }

    @Override
    public boolean updateSubnets(Iterable<Subnet> subnets) {
        Preconditions.checkNotNull(subnets, (Object)SUBNET_NOT_NULL);
        for (Subnet subnet : subnets) {
            if (!this.subnetStore.containsKey(subnet.id())) {
                this.log.debug("The subnet is not exist whose identifier is {}", (Object)subnet.id().toString());
                return false;
            }
            this.subnetStore.put(subnet.id(), subnet);
            if (subnet.equals(this.subnetStore.get(subnet.id()))) continue;
            this.log.debug("The subnet is updated failed whose identifier is {}", (Object)subnet.id().toString());
            return false;
        }
        return true;
    }

    @Override
    public boolean removeSubnets(Iterable<SubnetId> subnetIds) {
        Preconditions.checkNotNull(subnetIds, (Object)SUBNET_ID_NULL);
        for (SubnetId subnetId : subnetIds) {
            this.subnetStore.remove(subnetId);
            if (!this.subnetStore.containsKey(subnetId)) continue;
            this.log.debug("The subnet created is failed whose identifier is {}", (Object)subnetId.toString());
            return false;
        }
        return true;
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }

    protected void bindTenantNetworkService(TenantNetworkService tenantNetworkService) {
        this.tenantNetworkService = tenantNetworkService;
    }

    protected void unbindTenantNetworkService(TenantNetworkService tenantNetworkService) {
        if (this.tenantNetworkService == tenantNetworkService) {
            this.tenantNetworkService = null;
        }
    }
}

