/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtnrsc.tenantnetwork.impl;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.Service;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.CoreService;
import org.onosproject.store.serializers.KryoNamespaces;
import org.onosproject.store.service.Serializer;
import org.onosproject.store.service.StorageService;
import org.onosproject.vtnrsc.DefaultTenantNetwork;
import org.onosproject.vtnrsc.PhysicalNetwork;
import org.onosproject.vtnrsc.SegmentationId;
import org.onosproject.vtnrsc.TenantId;
import org.onosproject.vtnrsc.TenantNetwork;
import org.onosproject.vtnrsc.TenantNetworkId;
import org.onosproject.vtnrsc.tenantnetwork.TenantNetworkService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
@Service
public class TenantNetworkManager
implements TenantNetworkService {
    private static final String NETWORK_ID_NULL = "Network ID cannot be null";
    private static final String NETWORK_NOT_NULL = "Network ID cannot be null";
    private static final String TENANTNETWORK = "vtn-tenant-network-store";
    private static final String VTNRSC_APP = "org.onosproject.vtnrsc";
    protected Map<TenantNetworkId, TenantNetwork> networkIdAsKeyStore;
    protected ApplicationId appId;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected StorageService storageService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected CoreService coreService;

    @Activate
    public void activate() {
        this.appId = this.coreService.registerApplication(VTNRSC_APP);
        this.networkIdAsKeyStore = this.storageService.consistentMapBuilder().withName(TENANTNETWORK).withApplicationId(this.appId).withPurgeOnUninstall().withSerializer(Serializer.using(Arrays.asList(KryoNamespaces.API), (Class[])new Class[]{TenantNetworkId.class, DefaultTenantNetwork.class, TenantNetwork.State.class, TenantId.class, TenantNetwork.Type.class, PhysicalNetwork.class, SegmentationId.class})).build().asJavaMap();
        this.log.info("Started");
    }

    @Deactivate
    public void deactivate() {
        this.log.info("Stopped");
    }

    @Override
    public boolean exists(TenantNetworkId networkId) {
        Preconditions.checkNotNull((Object)networkId, (Object)"Network ID cannot be null");
        return this.networkIdAsKeyStore.containsKey(networkId);
    }

    @Override
    public int getNetworkCount() {
        return this.networkIdAsKeyStore.size();
    }

    @Override
    public Iterable<TenantNetwork> getNetworks() {
        return Collections.unmodifiableCollection(this.networkIdAsKeyStore.values());
    }

    @Override
    public TenantNetwork getNetwork(TenantNetworkId networkId) {
        Preconditions.checkNotNull((Object)networkId, (Object)"Network ID cannot be null");
        return this.networkIdAsKeyStore.get(networkId);
    }

    @Override
    public boolean createNetworks(Iterable<TenantNetwork> networks) {
        Preconditions.checkNotNull(networks, (Object)"Network ID cannot be null");
        for (TenantNetwork network : networks) {
            this.networkIdAsKeyStore.put(network.id(), network);
            if (this.networkIdAsKeyStore.containsKey(network.id())) continue;
            this.log.debug("The tenantNetwork is created failed which identifier was {}", (Object)network.id().toString());
            return false;
        }
        return true;
    }

    @Override
    public boolean updateNetworks(Iterable<TenantNetwork> networks) {
        Preconditions.checkNotNull(networks, (Object)"Network ID cannot be null");
        for (TenantNetwork network : networks) {
            if (!this.networkIdAsKeyStore.containsKey(network.id())) {
                this.log.debug("The tenantNetwork is not exist whose identifier was {} ", (Object)network.id().toString());
                return false;
            }
            this.networkIdAsKeyStore.put(network.id(), network);
            if (network.equals(this.networkIdAsKeyStore.get(network.id()))) continue;
            this.log.debug("The tenantNetwork is updated failed whose identifier was {} ", (Object)network.id().toString());
            return false;
        }
        return true;
    }

    @Override
    public boolean removeNetworks(Iterable<TenantNetworkId> networkIds) {
        Preconditions.checkNotNull(networkIds, (Object)"Network ID cannot be null");
        for (TenantNetworkId networkId : networkIds) {
            this.networkIdAsKeyStore.remove(networkId);
            if (!this.networkIdAsKeyStore.containsKey(networkId)) continue;
            this.log.debug("The tenantNetwork is removed failed whose identifier was {}", (Object)networkId.toString());
            return false;
        }
        return true;
    }

    protected void bindStorageService(StorageService storageService) {
        this.storageService = storageService;
    }

    protected void unbindStorageService(StorageService storageService) {
        if (this.storageService == storageService) {
            this.storageService = null;
        }
    }

    protected void bindCoreService(CoreService coreService) {
        this.coreService = coreService;
    }

    protected void unbindCoreService(CoreService coreService) {
        if (this.coreService == coreService) {
            this.coreService = null;
        }
    }
}

