/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtnrsc;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onlab.packet.IpAddress;
import org.onosproject.net.PortNumber;
import org.onosproject.vtnrsc.FiveTuple;
import org.onosproject.vtnrsc.TenantId;

public final class DefaultFiveTuple
implements FiveTuple {
    private final IpAddress ipSrc;
    private final IpAddress ipDst;
    private final PortNumber portSrc;
    private final PortNumber portDst;
    private final byte protocol;
    private final TenantId tenantId;

    private DefaultFiveTuple(byte protocol, IpAddress ipSrc, IpAddress ipDst, PortNumber portSrc, PortNumber portDst, TenantId tenantId) {
        this.protocol = protocol;
        this.ipSrc = ipSrc;
        this.ipDst = ipDst;
        this.portSrc = portSrc;
        this.portDst = portDst;
        this.tenantId = tenantId;
    }

    @Override
    public byte protocol() {
        return this.protocol;
    }

    @Override
    public IpAddress ipSrc() {
        return this.ipSrc;
    }

    @Override
    public IpAddress ipDst() {
        return this.ipDst;
    }

    @Override
    public PortNumber portSrc() {
        return this.portSrc;
    }

    @Override
    public PortNumber portDst() {
        return this.portDst;
    }

    @Override
    public TenantId tenantId() {
        return this.tenantId;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultFiveTuple) {
            DefaultFiveTuple other = (DefaultFiveTuple)obj;
            return Objects.equals(this.protocol, other.protocol) && Objects.equals(this.ipSrc, other.ipSrc) && Objects.equals(this.ipDst, other.ipDst) && Objects.equals(this.portSrc, other.portSrc) && Objects.equals(this.portDst, other.portDst);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.protocol, this.ipSrc, this.ipDst, this.portSrc, this.portDst);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("protocol", (int)this.protocol).add("ipSrc", (Object)this.ipSrc).add("ipDst", (Object)this.ipDst).add("portSrc", (Object)this.portSrc).add("portDst", (Object)this.portDst).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements FiveTuple.Builder {
        private IpAddress ipSrc;
        private IpAddress ipDst;
        private PortNumber portSrc;
        private PortNumber portDst;
        private byte protocol;
        private TenantId tenantId;

        @Override
        public Builder setIpSrc(IpAddress ipSrc) {
            this.ipSrc = ipSrc;
            return this;
        }

        @Override
        public Builder setIpDst(IpAddress ipDst) {
            this.ipDst = ipDst;
            return this;
        }

        @Override
        public Builder setPortSrc(PortNumber portSrc) {
            this.portSrc = portSrc;
            return this;
        }

        @Override
        public Builder setPortDst(PortNumber portDst) {
            this.portDst = portDst;
            return this;
        }

        @Override
        public Builder setProtocol(byte protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public FiveTuple.Builder setTenantId(TenantId tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @Override
        public FiveTuple build() {
            Preconditions.checkArgument((this.protocol == 6 || this.protocol == 17 || this.protocol == 1 ? 1 : 0) != 0, (Object)"Unsupported value for protocol while creating five tuple");
            return new DefaultFiveTuple(this.protocol, this.ipSrc, this.ipDst, this.portSrc, this.portDst, this.tenantId);
        }
    }
}

