/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtnrsc;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onosproject.vtnrsc.PortPair;
import org.onosproject.vtnrsc.PortPairId;
import org.onosproject.vtnrsc.TenantId;

public final class DefaultPortPair
implements PortPair {
    private final PortPairId portPairId;
    private final TenantId tenantId;
    private final String name;
    private final String description;
    private final String ingress;
    private final String egress;

    private DefaultPortPair(PortPairId portPairId, TenantId tenantId, String name, String description, String ingress, String egress) {
        this.portPairId = portPairId;
        this.tenantId = tenantId;
        this.name = name;
        this.description = description;
        this.ingress = ingress;
        this.egress = egress;
    }

    @Override
    public PortPairId portPairId() {
        return this.portPairId;
    }

    @Override
    public TenantId tenantId() {
        return this.tenantId;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public String ingress() {
        return this.ingress;
    }

    @Override
    public String egress() {
        return this.egress;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.portPairId, this.tenantId, this.name, this.description, this.ingress, this.egress});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultPortPair) {
            DefaultPortPair that = (DefaultPortPair)obj;
            return Objects.equals((Object)this.portPairId, (Object)that.portPairId) && Objects.equals((Object)this.tenantId, (Object)that.tenantId) && Objects.equals(this.name, that.name) && Objects.equals(this.description, that.description) && Objects.equals(this.ingress, that.ingress) && Objects.equals(this.egress, that.egress);
        }
        return false;
    }

    @Override
    public boolean exactMatch(PortPair portPair) {
        return this.equals(portPair) && Objects.equals((Object)this.portPairId, (Object)portPair.portPairId()) && Objects.equals((Object)this.tenantId, (Object)portPair.tenantId());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.portPairId.toString()).add("tenantId", (Object)this.tenantId.tenantId()).add("name", (Object)this.name).add("description", (Object)this.description).add("ingress", (Object)this.ingress).add("egress", (Object)this.egress).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements PortPair.Builder {
        private PortPairId portPairId;
        private TenantId tenantId;
        private String name;
        private String description;
        private String ingress;
        private String egress;

        @Override
        public Builder setId(PortPairId portPairId) {
            this.portPairId = portPairId;
            return this;
        }

        @Override
        public Builder setTenantId(TenantId tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @Override
        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        @Override
        public Builder setIngress(String ingress) {
            this.ingress = ingress;
            return this;
        }

        @Override
        public Builder setEgress(String egress) {
            this.egress = egress;
            return this;
        }

        @Override
        public PortPair build() {
            Preconditions.checkNotNull((Object)((Object)this.portPairId), (Object)"Port pair id cannot be null");
            Preconditions.checkNotNull((Object)((Object)this.tenantId), (Object)"Tenant id cannot be null");
            Preconditions.checkNotNull((Object)this.ingress, (Object)"Ingress of a port pair cannot be null");
            Preconditions.checkNotNull((Object)this.egress, (Object)"Egress of a port pair cannot be null");
            return new DefaultPortPair(this.portPairId, this.tenantId, this.name, this.description, this.ingress, this.egress);
        }
    }
}

