/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtnrsc;

import com.google.common.base.MoreObjects;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.onlab.packet.MacAddress;
import org.onosproject.net.DeviceId;
import org.onosproject.vtnrsc.AllowedAddressPair;
import org.onosproject.vtnrsc.BindingHostId;
import org.onosproject.vtnrsc.FixedIp;
import org.onosproject.vtnrsc.SecurityGroup;
import org.onosproject.vtnrsc.TenantId;
import org.onosproject.vtnrsc.TenantNetworkId;
import org.onosproject.vtnrsc.VirtualPort;
import org.onosproject.vtnrsc.VirtualPortId;

public final class DefaultVirtualPort
implements VirtualPort {
    private final VirtualPortId id;
    private final TenantNetworkId networkId;
    private final Boolean adminStateUp;
    private final String name;
    private final VirtualPort.State state;
    private final MacAddress macAddress;
    private final TenantId tenantId;
    private final String deviceOwner;
    private final DeviceId deviceId;
    private final Set<FixedIp> fixedIps;
    private final BindingHostId bindingHostId;
    private final String bindingVnicType;
    private final String bindingVifType;
    private final String bindingVifDetails;
    private final Set<AllowedAddressPair> allowedAddressPairs;
    private final Set<SecurityGroup> securityGroups;

    public DefaultVirtualPort(VirtualPortId id, TenantNetworkId networkId, Boolean adminStateUp, Map<String, String> strMap, VirtualPort.State state, MacAddress macAddress, TenantId tenantId, DeviceId deviceId, Set<FixedIp> fixedIps, BindingHostId bindingHostId, Set<AllowedAddressPair> allowedAddressPairs, Set<SecurityGroup> securityGroups) {
        this.id = id;
        this.networkId = networkId;
        this.adminStateUp = adminStateUp;
        this.name = strMap.get("name");
        this.state = state;
        this.macAddress = macAddress;
        this.tenantId = tenantId;
        this.deviceOwner = strMap.get("deviceOwner");
        this.deviceId = deviceId;
        this.fixedIps = fixedIps;
        this.bindingHostId = bindingHostId;
        this.bindingVnicType = strMap.get("bindingVnicType");
        this.bindingVifType = strMap.get("bindingVifType");
        this.bindingVifDetails = strMap.get("bindingVifDetails");
        this.allowedAddressPairs = allowedAddressPairs;
        this.securityGroups = securityGroups;
    }

    @Override
    public VirtualPortId portId() {
        return this.id;
    }

    @Override
    public TenantNetworkId networkId() {
        return this.networkId;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public boolean adminStateUp() {
        return this.adminStateUp;
    }

    @Override
    public VirtualPort.State state() {
        return this.state;
    }

    @Override
    public MacAddress macAddress() {
        return this.macAddress;
    }

    @Override
    public TenantId tenantId() {
        return this.tenantId;
    }

    @Override
    public DeviceId deviceId() {
        return this.deviceId;
    }

    @Override
    public String deviceOwner() {
        return this.deviceOwner;
    }

    @Override
    public Collection<AllowedAddressPair> allowedAddressPairs() {
        return this.allowedAddressPairs;
    }

    @Override
    public Set<FixedIp> fixedIps() {
        return this.fixedIps;
    }

    @Override
    public BindingHostId bindingHostId() {
        return this.bindingHostId;
    }

    @Override
    public String bindingVnicType() {
        return this.bindingVifType;
    }

    @Override
    public String bindingVifType() {
        return this.bindingVifType;
    }

    @Override
    public String bindingVifDetails() {
        return this.bindingVifDetails;
    }

    public Collection<SecurityGroup> securityGroups() {
        return this.securityGroups;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.networkId, this.adminStateUp, this.name, this.state, this.macAddress, this.tenantId, this.deviceId, this.deviceOwner, this.allowedAddressPairs, this.fixedIps, this.bindingHostId, this.bindingVnicType, this.bindingVifType, this.bindingVifDetails, this.securityGroups});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultVirtualPort) {
            DefaultVirtualPort that = (DefaultVirtualPort)obj;
            return Objects.equals((Object)this.id, (Object)that.id) && Objects.equals((Object)this.networkId, (Object)that.networkId) && Objects.equals(this.adminStateUp, that.adminStateUp) && Objects.equals((Object)this.state, (Object)that.state) && Objects.equals(this.name, that.name) && Objects.equals((Object)this.tenantId, (Object)that.tenantId) && Objects.equals(this.macAddress, that.macAddress) && Objects.equals(this.deviceId, that.deviceId) && Objects.equals(this.deviceOwner, that.deviceOwner) && Objects.equals(this.allowedAddressPairs, that.allowedAddressPairs) && Objects.equals(this.fixedIps, that.fixedIps) && Objects.equals((Object)this.bindingHostId, (Object)that.bindingHostId) && Objects.equals(this.bindingVifDetails, that.bindingVifDetails) && Objects.equals(this.bindingVifType, that.bindingVifType) && Objects.equals(this.bindingVnicType, that.bindingVnicType) && Objects.equals(this.securityGroups, that.securityGroups);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("network_id", (Object)this.networkId).add("adminStateUp", (Object)this.adminStateUp).add("state", (Object)this.state).add("name", (Object)this.name).add("state", (Object)this.state).add("macAddress", (Object)this.macAddress).add("tenantId", (Object)this.tenantId).add("deviced", (Object)this.deviceId).add("deviceOwner", (Object)this.deviceOwner).add("allowedAddressPairs", this.allowedAddressPairs).add("fixedIp", this.fixedIps).add("bindingHostId", (Object)this.bindingHostId).add("bindingVnicType", (Object)this.bindingVnicType).add("bindingVifDetails", (Object)this.bindingVifDetails).add("bindingVifType", (Object)this.bindingVifType).add("securityGroups", this.securityGroups).toString();
    }
}

