/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtnrsc;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onlab.packet.IpAddress;
import org.onosproject.vtnrsc.SubnetId;

public final class FixedIp {
    private final SubnetId subnetId;
    private final IpAddress ip;

    private FixedIp(SubnetId subnetId, IpAddress ip) {
        Preconditions.checkNotNull((Object)((Object)subnetId), (Object)"SubnetId cannot be null");
        Preconditions.checkNotNull((Object)ip, (Object)"IpAddress cannot be null");
        this.subnetId = subnetId;
        this.ip = ip;
    }

    public SubnetId subnetId() {
        return this.subnetId;
    }

    public IpAddress ip() {
        return this.ip;
    }

    public static FixedIp fixedIp(SubnetId subnetId, IpAddress ip) {
        return new FixedIp(subnetId, ip);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.subnetId, this.ip});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof FixedIp) {
            FixedIp that = (FixedIp)obj;
            return Objects.equals((Object)this.subnetId, (Object)that.subnetId) && Objects.equals(this.ip, that.ip);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("subnetId", (Object)this.subnetId).add("ip", (Object)this.ip).toString();
    }
}

