/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.vtnrsc;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Objects;
import org.onosproject.vtnrsc.FixedIp;
import org.onosproject.vtnrsc.TenantNetworkId;

public final class RouterGateway {
    private final TenantNetworkId networkId;
    private final boolean enableSnat;
    private final Collection<FixedIp> externalFixedIps;

    private RouterGateway(TenantNetworkId networkId, boolean enableSnat, Collection<FixedIp> externalFixedIps) {
        this.networkId = (TenantNetworkId)((Object)Preconditions.checkNotNull((Object)((Object)networkId), (Object)"networkId cannot be null"));
        this.enableSnat = (Boolean)Preconditions.checkNotNull((Object)enableSnat, (Object)"enableSnat cannot be null");
        this.externalFixedIps = (Collection)Preconditions.checkNotNull(externalFixedIps, (Object)"externalFixedIps cannot be null");
    }

    public static RouterGateway routerGateway(TenantNetworkId networkId, boolean enableSnat, Collection<FixedIp> externalFixedIps) {
        return new RouterGateway(networkId, enableSnat, externalFixedIps);
    }

    public TenantNetworkId networkId() {
        return this.networkId;
    }

    public boolean enableSnat() {
        return this.enableSnat;
    }

    public Collection<FixedIp> externalFixedIps() {
        return this.externalFixedIps;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.networkId, this.enableSnat, this.externalFixedIps});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof RouterGateway) {
            RouterGateway that = (RouterGateway)obj;
            return Objects.equals((Object)this.networkId, (Object)that.networkId) && Objects.equals(this.enableSnat, that.enableSnat) && Objects.equals(this.externalFixedIps, that.externalFixedIps);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("networkId", (Object)this.networkId).add("enableSnat", this.enableSnat).add("externalFixedIps", this.externalFixedIps).toString();
    }
}

